/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Cursor;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.SnapshotsDiffWindow;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class ResultsManager {
    private static ResultsManager defaultResultsManager;
    private static final String PROFILED_APP_TERMINATED_MSG;
    private static final String DATA_NOT_AVAILABLE_MSG;
    private static final String OUT_OF_MEMORY_MSG;
    private static final String SNAPSHOT_DELETE_FAILED_MSG;
    private static final String SNAPSHOT_SAVE_FAILED_MSG;
    private static final String CANT_FIND_SNAPSHOT_LOCATION_MSG;
    private static final String SNAPSHOT_CREATE_IN_PROJECT_FAILED_MSG;
    private static final String SNAPSHOT_LOAD_FAILED_MSG;
    private static final String SNAPSHOTS_LOAD_FAILED_MSG;
    private static final String OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG;
    private static final String SELECT_DIR_DIALOG_CAPTION;
    private static final String SAVE_BUTTON_NAME;
    private static final String OVERWRITE_FILE_DIALOG_CAPTION;
    private static final String OVERWRITE_FILE_DIALOG_MSG;
    private static final String FILE_DELETE_FAILED_MSG;
    private static final String SNAPSHOT_EXPORT_FAILED_MSG;
    private static final String SAVE_SNAPSHOTS_DIALOG_CAPTION;
    private static final String SAVE_SNAPSHOTS_DIALOG_MSG;
    private static final String SELECT_FILE_OR_DIR_DIALOG_CAPTION;
    private static final String PROFILER_SNAPSHOT_FILE_FILTER;
    private static final String PROFILER_HEAPDUMP_FILE_FILTER;
    private static final String SNAPSHOT_CREATE_FAILED_MSG;
    private static final String OUT_OF_MEMORY_SAVING;
    private static final String CANNOT_COMPARE_SNAPSHOTS_MSG;
    private static final String DIRECTORY_DOESNT_EXIST_CAPTION;
    private static final String DIRECTORY_DOESNT_EXIST_MSG;
    private static final String CANNOT_OPEN_SNAPSHOT_MSG;
    public static final String SNAPSHOT_EXTENSION = "nps";
    public static final String HEAPDUMP_EXTENSION = "hprof";
    public static final String STACKTRACES_SNAPSHOT_EXTENSION = "npss";
    private ArrayList<LoadedSnapshot> loadedSnapshots = new ArrayList();
    private File exportDir;
    private HashMap<FileObject, ProfilingSettings> settingsCache = new HashMap();
    private HashMap<FileObject, Integer> typeCache = new HashMap();
    private Vector resultsListeners;
    private Vector snapshotListeners;
    private Window mainWindow;
    private boolean resultsAvailable = false;

    private ResultsManager() {
    }

    public static ResultsManager getDefault() {
        if (defaultResultsManager == null) {
            defaultResultsManager = new ResultsManager();
        }
        return defaultResultsManager;
    }

    public String getDefaultSnapshotFileName(LoadedSnapshot loadedSnapshot) {
        return "snapshot-" + loadedSnapshot.getSnapshot().getTimeTaken();
    }

    public LoadedSnapshot[] getLoadedSnapshots() {
        return this.loadedSnapshots.toArray(new LoadedSnapshot[0]);
    }

    public LoadedSnapshot getSnapshotFromFileObject(FileObject fileObject) {
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot;
        }
        try {
            return this.loadSnapshotFromFileObject(fileObject);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return null;
        }
    }

    public ProfilingSettings getSnapshotSettings(FileObject fileObject) {
        ProfilingSettings profilingSettings = this.settingsCache.get(fileObject);
        if (profilingSettings == null && !this.settingsCache.containsKey(fileObject)) {
            profilingSettings = this.readSettingsFromFile(fileObject);
            this.settingsCache.put(fileObject, profilingSettings);
        }
        return profilingSettings;
    }

    public int getSnapshotType(FileObject fileObject) {
        Integer n = this.typeCache.get(fileObject);
        if (n == null) {
            n = new Integer(this.readTypeFromFile(fileObject));
            this.typeCache.put(fileObject, n);
        }
        return n;
    }

    public void addResultsListener(ResultsListener resultsListener) {
        if (this.resultsListeners == null) {
            this.resultsListeners = new Vector();
        }
        if (!this.resultsListeners.contains(resultsListener)) {
            this.resultsListeners.add(resultsListener);
        }
    }

    public void addSnapshotsListener(SnapshotsListener snapshotsListener) {
        if (this.snapshotListeners == null) {
            this.snapshotListeners = new Vector();
        }
        if (!this.snapshotListeners.contains(snapshotsListener)) {
            this.snapshotListeners.add(snapshotsListener);
        }
    }

    public void cctEstablished(RuntimeCCTNode runtimeCCTNode) {
        if (NetBeansProfiler.getDefaultNB().getProfilingState() == 1) {
            return;
        }
        this.resultsAvailable = true;
        this.fireResultsAvailable();
    }

    public void cctReset() {
        this.resultsAvailable = false;
        this.fireResultsReset();
    }

    public void closeSnapshot(LoadedSnapshot loadedSnapshot) {
        if (loadedSnapshot != null) {
            this.loadedSnapshots.remove(loadedSnapshot);
            this.fireSnapshotRemoved(loadedSnapshot);
        }
    }

    public void compareSnapshots(FileObject fileObject, FileObject fileObject2) {
        LoadedSnapshot loadedSnapshot = null;
        LoadedSnapshot loadedSnapshot2 = null;
        try {
            loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
            if (loadedSnapshot == null) {
                loadedSnapshot = this.loadSnapshotFromFileObject(fileObject);
            }
            if ((loadedSnapshot2 = this.findAlreadyLoadedSnapshot(fileObject2)) == null) {
                loadedSnapshot2 = this.loadSnapshotFromFileObject(fileObject2);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, MessageFormat.format(SNAPSHOT_LOAD_FAILED_MSG, exception.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)exception);
            return;
        }
        if (loadedSnapshot != null && loadedSnapshot2 != null) {
            this.compareSnapshots(loadedSnapshot, loadedSnapshot2);
        } else {
            NetBeansProfiler.getDefaultNB().displayError(SNAPSHOTS_LOAD_FAILED_MSG);
        }
    }

    public void compareSnapshots(LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2) {
        AllocMemoryResultsDiff allocMemoryResultsDiff = null;
        if (loadedSnapshot.getSnapshot() instanceof AllocMemoryResultsSnapshot && loadedSnapshot2.getSnapshot() instanceof AllocMemoryResultsSnapshot) {
            allocMemoryResultsDiff = new AllocMemoryResultsDiff((AllocMemoryResultsSnapshot)loadedSnapshot.getSnapshot(), (AllocMemoryResultsSnapshot)loadedSnapshot2.getSnapshot());
        } else if (loadedSnapshot.getSnapshot() instanceof LivenessMemoryResultsSnapshot && loadedSnapshot2.getSnapshot() instanceof LivenessMemoryResultsSnapshot) {
            allocMemoryResultsDiff = new LivenessMemoryResultsDiff((LivenessMemoryResultsSnapshot)loadedSnapshot.getSnapshot(), (LivenessMemoryResultsSnapshot)loadedSnapshot2.getSnapshot());
        }
        if (allocMemoryResultsDiff != null) {
            SnapshotsDiffWindow snapshotsDiffWindow = SnapshotsDiffWindow.get(allocMemoryResultsDiff, loadedSnapshot, loadedSnapshot2);
            snapshotsDiffWindow.open();
            snapshotsDiffWindow.requestActive();
        } else {
            NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_COMPARE_SNAPSHOTS_MSG, loadedSnapshot.getFile().getName(), loadedSnapshot2.getFile().getName()));
        }
    }

    public void deleteSnapshot(FileObject fileObject) {
        LoadedSnapshot loadedSnapshot = this.findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
        try {
            fileObject.delete();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(SNAPSHOT_DELETE_FAILED_MSG, iOException.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return;
        }
        if (loadedSnapshot != null) {
            this.loadedSnapshots.remove(loadedSnapshot);
            this.fireSnapshotRemoved(loadedSnapshot);
        }
    }

    public void exportSnapshots(FileObject[] fileObjectArray) {
        assert (fileObjectArray != null);
        assert (fileObjectArray.length > 0);
        if (fileObjectArray.length == 1) {
            SelectedFile selectedFile = this.selectSnapshotTargetFile(fileObjectArray[0].getName(), fileObjectArray[0].getExt().equals(HEAPDUMP_EXTENSION));
            if (selectedFile != null && this.checkFileExists(selectedFile)) {
                this.exportSnapshot(fileObjectArray[0], selectedFile.folder, selectedFile.fileName, selectedFile.fileExt);
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            if (this.exportDir != null) {
                jFileChooser.setCurrentDirectory(this.exportDir);
            }
            jFileChooser.setDialogTitle(SELECT_DIR_DIALOG_CAPTION);
            jFileChooser.setApproveButtonText(SAVE_BUTTON_NAME);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            if (jFileChooser.showSaveDialog(IDEUtils.getMainWindow()) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (!file.exists()) {
                    if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)DIRECTORY_DOESNT_EXIST_MSG, DIRECTORY_DOESNT_EXIST_CAPTION, 0)) != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                    file.mkdir();
                }
                this.exportDir = file;
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    this.exportSnapshot(fileObjectArray[i], fileObject, fileObjectArray[i].getName(), fileObjectArray[i].getExt());
                }
            }
        }
    }

    public LoadedSnapshot findLoadedSnapshot(ResultsSnapshot resultsSnapshot) {
        for (LoadedSnapshot loadedSnapshot : this.loadedSnapshots) {
            if (loadedSnapshot.getSnapshot() != resultsSnapshot) continue;
            return loadedSnapshot;
        }
        return null;
    }

    public LoadedSnapshot findLoadedSnapshot(File file) {
        for (LoadedSnapshot loadedSnapshot : this.loadedSnapshots) {
            if (loadedSnapshot.getFile() == null || !loadedSnapshot.getFile().equals(file)) continue;
            return loadedSnapshot;
        }
        return null;
    }

    public boolean ideClosing() {
        Object object;
        Iterator<LoadedSnapshot> iterator = this.loadedSnapshots.iterator();
        ArrayList<LoadedSnapshot> arrayList = new ArrayList<LoadedSnapshot>();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((LoadedSnapshot)object).isSaved()) continue;
            arrayList.add((LoadedSnapshot)object);
        }
        if (arrayList.size() > 0) {
            object = ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(SAVE_SNAPSHOTS_DIALOG_MSG, "" + arrayList.size()), SAVE_SNAPSHOTS_DIALOG_CAPTION, 1));
            if (object == NotifyDescriptor.YES_OPTION) {
                for (LoadedSnapshot loadedSnapshot : arrayList) {
                    this.saveSnapshot(loadedSnapshot);
                }
                return true;
            }
            return object == NotifyDescriptor.NO_OPTION;
        }
        return true;
    }

    public FileObject[] listSavedHeapdumps() {
        try {
            FileObject fileObject = IDEUtils.getProjectSettingsFolder(false);
            if (fileObject == null) {
                return new FileObject[0];
            }
            fileObject.refresh();
            FileObject[] fileObjectArray = fileObject.getChildren();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (!fileObject2.getExt().equalsIgnoreCase(HEAPDUMP_EXTENSION)) continue;
                arrayList.add(fileObject2);
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    FileObject fileObject = (FileObject)object;
                    FileObject fileObject2 = (FileObject)object2;
                    return fileObject.getName().compareTo(fileObject2.getName());
                }
            });
            FileObject[] fileObjectArray2 = new FileObject[arrayList.size()];
            arrayList.toArray(fileObjectArray2);
            return fileObjectArray2;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG, iOException.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return new FileObject[0];
        }
    }

    public FileObject[] listSavedSnapshots() {
        try {
            FileObject fileObject = IDEUtils.getProjectSettingsFolder(false);
            if (fileObject == null) {
                return new FileObject[0];
            }
            fileObject.refresh();
            FileObject[] fileObjectArray = fileObject.getChildren();
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (!fileObject2.getExt().equalsIgnoreCase(SNAPSHOT_EXTENSION)) continue;
                arrayList.add(fileObject2);
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    FileObject fileObject = (FileObject)object;
                    FileObject fileObject2 = (FileObject)object2;
                    return fileObject.getName().compareTo(fileObject2.getName());
                }
            });
            FileObject[] fileObjectArray2 = new FileObject[arrayList.size()];
            arrayList.toArray(fileObjectArray2);
            return fileObjectArray2;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG, iOException.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return new FileObject[0];
        }
    }

    public LoadedSnapshot loadSnapshot(FileObject fileObject) {
        try {
            return this.loadSnapshotImpl(fileObject);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(SNAPSHOT_LOAD_FAILED_MSG, iOException.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return null;
        }
    }

    public LoadedSnapshot[] loadSnapshots(FileObject[] fileObjectArray) {
        LoadedSnapshot[] loadedSnapshotArray = new LoadedSnapshot[fileObjectArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            try {
                if (fileObjectArray[i] == null) continue;
                loadedSnapshotArray[i] = this.loadSnapshotImpl(fileObjectArray[i]);
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(SNAPSHOT_LOAD_FAILED_MSG, iOException.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            }
        }
        return loadedSnapshotArray;
    }

    public void openSnapshot(LoadedSnapshot loadedSnapshot) {
        this.openSnapshot(loadedSnapshot, -1, false);
    }

    public void openSnapshot(final LoadedSnapshot loadedSnapshot, final int n, final boolean bl) {
        if (loadedSnapshot == null) {
            NetBeansProfiler.getDefaultNB().displayError(CANNOT_OPEN_SNAPSHOT_MSG);
        } else {
            IDEUtils.runInEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    SnapshotResultsWindow snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot, n, bl);
                    snapshotResultsWindow.open();
                    snapshotResultsWindow.requestActive();
                }
            });
        }
    }

    public void openSnapshots(LoadedSnapshot[] loadedSnapshotArray) {
        LoadedSnapshot loadedSnapshot = null;
        try {
            SnapshotResultsWindow snapshotResultsWindow = null;
            for (int i = 0; i < loadedSnapshotArray.length; ++i) {
                loadedSnapshot = loadedSnapshotArray[i];
                if (loadedSnapshotArray[i] == null) continue;
                snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot);
                snapshotResultsWindow.open();
            }
            if (snapshotResultsWindow != null) {
                snapshotResultsWindow.requestActive();
            }
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotLoadFailed", (Object[])new Object[]{loadedSnapshot.getFile().getAbsolutePath()}));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    public LoadedSnapshot prepareSnapshot() {
        return this.prepareSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot prepareSnapshot(boolean bl) {
        TargetAppRunner targetAppRunner;
        CodeRegionResultsSnapshot codeRegionResultsSnapshot = null;
        if (!this.resultsAvailable()) {
            return null;
        }
        try {
            targetAppRunner = Profiler.getDefault().getTargetAppRunner();
            ProfilerClient profilerClient = targetAppRunner.getProfilerClient();
            int n = profilerClient.getCurrentInstrType();
            try {
                switch (n) {
                    case 4: 
                    case 5: {
                        codeRegionResultsSnapshot = profilerClient.getMemoryProfilingResultsSnapshot(bl);
                        break;
                    }
                    case 2: 
                    case 3: {
                        codeRegionResultsSnapshot = profilerClient.getCPUProfilingResultsSnapshot(bl);
                        break;
                    }
                    case 1: {
                        codeRegionResultsSnapshot = profilerClient.getCodeRegionProfilingResultsSnapshot();
                    }
                }
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                ErrorManager.getDefault().annotate((Throwable)targetAppOrVMTerminated, PROFILED_APP_TERMINATED_MSG);
                ErrorManager.getDefault().notify(65536, (Throwable)targetAppOrVMTerminated);
            }
            catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
                ErrorManager.getDefault().annotate((Throwable)noDataAvailableException, DATA_NOT_AVAILABLE_MSG);
                ErrorManager.getDefault().notify(65536, (Throwable)noDataAvailableException);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                try {
                    this.reset();
                    targetAppRunner.resetTimers();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    targetAppRunner.getProfilerClient().resetClientData();
                }
                ErrorManager.getDefault().annotate((Throwable)outOfMemoryError, OUT_OF_MEMORY_MSG);
                ErrorManager.getDefault().notify(65536, (Throwable)outOfMemoryError);
            }
        }
        finally {
            if (codeRegionResultsSnapshot != null) {
                targetAppRunner = new ProfilingSettings();
                Profiler.getDefault().getLastProfilingSettings().copySettingsInto((ProfilingSettings)targetAppRunner);
                targetAppRunner.setSettingsName(Profiler.getDefault().getLastProfilingSettings().getSettingsName());
                return new LoadedSnapshot((ResultsSnapshot)codeRegionResultsSnapshot, (ProfilingSettings)targetAppRunner, null);
            }
        }
        return null;
    }

    public void removeResultsListener(ResultsListener resultsListener) {
        if (this.resultsListeners != null) {
            this.resultsListeners.remove(resultsListener);
        }
    }

    public void removeSnapshotsListener(SnapshotsListener snapshotsListener) {
        if (this.snapshotListeners != null) {
            this.snapshotListeners.remove(snapshotsListener);
        }
    }

    public void reset() {
        ProfilingResultsDispatcher.getDefault().reset();
        this.resultsReset();
    }

    public boolean resultsAvailable() {
        return this.resultsAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveSnapshot(LoadedSnapshot loadedSnapshot, FileObject fileObject) {
        FileLock fileLock = null;
        FilterOutputStream filterOutputStream = null;
        try {
            fileLock = fileObject.lock();
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            filterOutputStream = new DataOutputStream(bufferedOutputStream);
            loadedSnapshot.save((DataOutputStream)filterOutputStream);
            filterOutputStream.close();
            loadedSnapshot.setFile(FileUtil.toFile((FileObject)fileObject));
            loadedSnapshot.setSaved(true);
            this.fireSnapshotSaved(loadedSnapshot);
        }
        catch (IOException iOException) {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileLock != null) {
                    fileObject.delete(fileLock);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(SNAPSHOT_SAVE_FAILED_MSG, iOException.getMessage()));
            boolean bl = false;
            return bl;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileLock != null) {
                    fileObject.delete(fileLock);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            NetBeansProfiler.getDefaultNB().displayError(OUT_OF_MEMORY_SAVING);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return true;
    }

    public boolean saveSnapshot(LoadedSnapshot loadedSnapshot) {
        FileObject fileObject = null;
        FileObject fileObject2 = null;
        try {
            fileObject2 = IDEUtils.getProjectSettingsFolder(true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(CANT_FIND_SNAPSHOT_LOCATION_MSG, iOException.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return false;
        }
        try {
            fileObject = fileObject2.createData(this.getDefaultSnapshotFileName(loadedSnapshot), SNAPSHOT_EXTENSION);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(SNAPSHOT_CREATE_IN_PROJECT_FAILED_MSG, iOException.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return false;
        }
        return this.saveSnapshot(loadedSnapshot, fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedSnapshot takeSnapshot() {
        IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

            @Override
            public void run() {
                ResultsManager.this.mainWindow = WindowManager.getDefault().getMainWindow();
            }
        });
        Cursor cursor = this.mainWindow.getCursor();
        this.mainWindow.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LoadedSnapshot loadedSnapshot = this.prepareSnapshot();
            if (loadedSnapshot != null) {
                this.loadedSnapshots.add(loadedSnapshot);
                this.fireSnapshotTaken(loadedSnapshot);
                LoadedSnapshot loadedSnapshot2 = loadedSnapshot;
                return loadedSnapshot2;
            }
        }
        finally {
            this.mainWindow.setCursor(cursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResultsAvailable() {
        Vector vector;
        if (this.resultsListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.resultsListeners.clone();
        }
        object = vector.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable((Iterator)object){
            final /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            @Override
            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((ResultsListener)this.val$iterator.next()).resultsAvailable();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireResultsReset() {
        Vector vector;
        if (this.resultsListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.resultsListeners.clone();
        }
        object = vector.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable((Iterator)object){
            final /* synthetic */ Iterator val$iterator;
            {
                this.val$iterator = iterator;
            }

            @Override
            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((ResultsListener)this.val$iterator.next()).resultsReset();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSnapshotLoaded(LoadedSnapshot loadedSnapshot) {
        Vector vector;
        if (this.snapshotListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.snapshotListeners.clone();
        }
        object = vector.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable((Iterator)object, loadedSnapshot){
            final /* synthetic */ Iterator val$iterator;
            final /* synthetic */ LoadedSnapshot val$snapshot;
            {
                this.val$iterator = iterator;
                this.val$snapshot = loadedSnapshot;
            }

            @Override
            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((SnapshotsListener)this.val$iterator.next()).snapshotLoaded(this.val$snapshot);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSnapshotRemoved(LoadedSnapshot loadedSnapshot) {
        Vector vector;
        if (this.snapshotListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.snapshotListeners.clone();
        }
        object = vector.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable((Iterator)object, loadedSnapshot){
            final /* synthetic */ Iterator val$iterator;
            final /* synthetic */ LoadedSnapshot val$snapshot;
            {
                this.val$iterator = iterator;
                this.val$snapshot = loadedSnapshot;
            }

            @Override
            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((SnapshotsListener)this.val$iterator.next()).snapshotRemoved(this.val$snapshot);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSnapshotSaved(LoadedSnapshot loadedSnapshot) {
        Vector vector;
        if (this.snapshotListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.snapshotListeners.clone();
        }
        object = vector.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable((Iterator)object, loadedSnapshot){
            final /* synthetic */ Iterator val$iterator;
            final /* synthetic */ LoadedSnapshot val$snapshot;
            {
                this.val$iterator = iterator;
                this.val$snapshot = loadedSnapshot;
            }

            @Override
            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((SnapshotsListener)this.val$iterator.next()).snapshotSaved(this.val$snapshot);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSnapshotTaken(LoadedSnapshot loadedSnapshot) {
        Vector vector;
        if (this.snapshotListeners == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.snapshotListeners.clone();
        }
        object = vector.iterator();
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable((Iterator)object, loadedSnapshot){
            final /* synthetic */ Iterator val$iterator;
            final /* synthetic */ LoadedSnapshot val$snapshot;
            {
                this.val$iterator = iterator;
                this.val$snapshot = loadedSnapshot;
            }

            @Override
            public void run() {
                while (this.val$iterator.hasNext()) {
                    ((SnapshotsListener)this.val$iterator.next()).snapshotTaken(this.val$snapshot);
                }
            }
        });
    }

    void resultsBecameAvailable() {
        if (NetBeansProfiler.getDefaultNB().getProfilingState() == 1) {
            return;
        }
        this.resultsAvailable = true;
        this.fireResultsAvailable();
    }

    void resultsReset() {
        this.resultsAvailable = false;
        this.fireResultsReset();
    }

    SelectedFile selectSnapshotTargetFile(String string, final boolean bl) {
        String string2;
        FileObject fileObject;
        String string3;
        JFileChooser jFileChooser = new JFileChooser();
        if (this.exportDir != null) {
            jFileChooser.setCurrentDirectory(this.exportDir);
        }
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(SELECT_FILE_OR_DIR_DIALOG_CAPTION);
        jFileChooser.setApproveButtonText(SAVE_BUTTON_NAME);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith("." + (bl ? ResultsManager.HEAPDUMP_EXTENSION : ResultsManager.SNAPSHOT_EXTENSION));
            }

            @Override
            public String getDescription() {
                return MessageFormat.format(PROFILER_SNAPSHOT_FILE_FILTER, bl ? ResultsManager.HEAPDUMP_EXTENSION : ResultsManager.SNAPSHOT_EXTENSION);
            }
        });
        if (jFileChooser.showSaveDialog(IDEUtils.getMainWindow()) != 0) {
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        String string4 = string3 = bl ? HEAPDUMP_EXTENSION : SNAPSHOT_EXTENSION;
        if (file.isDirectory()) {
            this.exportDir = jFileChooser.getCurrentDirectory();
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            string2 = string;
        } else {
            this.exportDir = jFileChooser.getCurrentDirectory();
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.exportDir));
            String string5 = file.getName();
            int n = string5.lastIndexOf(".");
            if (n == -1) {
                string2 = string5;
            } else {
                string2 = string5.substring(0, n);
                string3 = string5.substring(n + 1);
            }
        }
        return new SelectedFile(fileObject, string2, string3);
    }

    private boolean checkFileExists(SelectedFile selectedFile) {
        FileObject fileObject = selectedFile.folder.getFileObject(selectedFile.fileName, selectedFile.fileExt);
        if (fileObject != null) {
            if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(OVERWRITE_FILE_DIALOG_MSG, selectedFile.fileName + "." + selectedFile.fileExt), OVERWRITE_FILE_DIALOG_CAPTION, 0)) != NotifyDescriptor.YES_OPTION) {
                return false;
            }
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(FILE_DELETE_FAILED_MSG, iOException.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                return false;
            }
        }
        return true;
    }

    private void exportSnapshot(FileObject fileObject, FileObject fileObject2, String string, String string2) {
        if (this.checkFileExists(new SelectedFile(fileObject2, string, string2))) {
            try {
                FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)string, (String)string2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(SNAPSHOT_EXPORT_FAILED_MSG, iOException.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            }
        }
    }

    private LoadedSnapshot findAlreadyLoadedSnapshot(FileObject fileObject) {
        Iterator<LoadedSnapshot> iterator = this.loadedSnapshots.iterator();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        while (iterator.hasNext()) {
            LoadedSnapshot loadedSnapshot = iterator.next();
            if (loadedSnapshot.getFile() == null || !loadedSnapshot.getFile().equals(file)) continue;
            return loadedSnapshot;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedSnapshot loadSnapshotFromFileObject(FileObject fileObject) throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = fileObject.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            LoadedSnapshot loadedSnapshot = LoadedSnapshot.loadSnapshot((DataInputStream)filterInputStream);
            if (loadedSnapshot != null) {
                loadedSnapshot.setFile(FileUtil.toFile((FileObject)fileObject));
            }
            LoadedSnapshot loadedSnapshot2 = loadedSnapshot;
            return loadedSnapshot2;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    private LoadedSnapshot loadSnapshotImpl(FileObject fileObject) throws IOException {
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot;
        }
        loadedSnapshot = this.loadSnapshotFromFileObject(fileObject);
        if (loadedSnapshot != null) {
            this.loadedSnapshots.add(loadedSnapshot);
            this.fireSnapshotLoaded(loadedSnapshot);
        }
        return loadedSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilingSettings readSettingsFromFile(FileObject fileObject) {
        BufferedInputStream bufferedInputStream;
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot.getSettings();
        }
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = fileObject.getInputStream();
            bufferedInputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            byte[] byArray = new byte["nBpRoFiLeR".length()];
            int n = ((DataInputStream)filterInputStream).read(byArray);
            if (n != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(byArray))) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            byte by = ((DataInputStream)filterInputStream).readByte();
            byte by2 = ((DataInputStream)filterInputStream).readByte();
            int n2 = ((DataInputStream)filterInputStream).readInt();
            int n3 = ((DataInputStream)filterInputStream).readInt();
            int n4 = ((DataInputStream)filterInputStream).readInt();
            if (((DataInputStream)filterInputStream).skipBytes(n3) != n3) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            int n5 = ((DataInputStream)filterInputStream).readInt();
            byte[] byArray2 = new byte[n5];
            if (((DataInputStream)filterInputStream).read(byArray2) != n5) {
                ProfilingSettings profilingSettings = null;
                return profilingSettings;
            }
            Properties properties = new Properties();
            ProfilingSettings profilingSettings = new ProfilingSettings();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(byteArrayInputStream);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream2);
            try {
                properties.load(dataInputStream);
            }
            catch (IOException iOException) {
                ProfilerLogger.log((Exception)iOException);
                ProfilingSettings profilingSettings2 = null;
                try {
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    ProfilerLogger.log((Exception)iOException2);
                }
                return profilingSettings2;
            }
            finally {
                dataInputStream.close();
            }
            profilingSettings.load((Map)properties);
            ProfilingSettings profilingSettings3 = profilingSettings;
            return profilingSettings3;
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            bufferedInputStream = null;
            return bufferedInputStream;
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                ProfilerLogger.log((Exception)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readTypeFromFile(FileObject fileObject) {
        LoadedSnapshot loadedSnapshot = this.findAlreadyLoadedSnapshot(fileObject);
        if (loadedSnapshot != null) {
            return loadedSnapshot.getType();
        }
        FilterInputStream filterInputStream = null;
        try {
            int n;
            InputStream inputStream = fileObject.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            filterInputStream = new DataInputStream(bufferedInputStream);
            byte[] byArray = new byte["nBpRoFiLeR".length()];
            int n2 = ((DataInputStream)filterInputStream).read(byArray);
            if (n2 != "nBpRoFiLeR".length() || !"nBpRoFiLeR".equals(new String(byArray))) {
                int n3 = 0;
                return n3;
            }
            byte by = ((DataInputStream)filterInputStream).readByte();
            byte by2 = ((DataInputStream)filterInputStream).readByte();
            int n4 = n = ((DataInputStream)filterInputStream).readInt();
            return n4;
        }
        catch (Exception exception) {
            int n = 0;
            return n;
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    static {
        PROFILED_APP_TERMINATED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ProfiledAppTerminatedMsg");
        DATA_NOT_AVAILABLE_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_DataNotAvailableMsg");
        OUT_OF_MEMORY_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_OutOfMemoryMsg");
        SNAPSHOT_DELETE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotDeleteFailedMsg");
        SNAPSHOT_SAVE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotSaveFailedMsg");
        CANT_FIND_SNAPSHOT_LOCATION_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_CantFindSnapshotLocationMsg");
        SNAPSHOT_CREATE_IN_PROJECT_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotCreateInProjectFailedMsg");
        SNAPSHOT_LOAD_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotLoadFailedMsg");
        SNAPSHOTS_LOAD_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotsLoadFailedMsg");
        OBTAIN_SAVED_SNAPSHOTS_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ObtainSavedSnapshotsFailedMsg");
        SELECT_DIR_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SelectDirDialogCaption");
        SAVE_BUTTON_NAME = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SaveButtonName");
        OVERWRITE_FILE_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_OverwriteFileDialogCaption");
        OVERWRITE_FILE_DIALOG_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_OverwriteFileDialogMsg");
        FILE_DELETE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_FileDeleteFailedMsg");
        SNAPSHOT_EXPORT_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotExportFailedMsg");
        SAVE_SNAPSHOTS_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SaveSnapshotsDialogCaption");
        SAVE_SNAPSHOTS_DIALOG_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SaveSnapshotsDialogMsg");
        SELECT_FILE_OR_DIR_DIALOG_CAPTION = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SelectFileOrDirDialogCaption");
        PROFILER_SNAPSHOT_FILE_FILTER = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ProfilerSnapshotFileFilter");
        PROFILER_HEAPDUMP_FILE_FILTER = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_ProfilerHeapdumpFileFilter");
        SNAPSHOT_CREATE_FAILED_MSG = NbBundle.getMessage(ResultsManager.class, (String)"ResultsManager_SnapshotCreateFailedMsg");
        OUT_OF_MEMORY_SAVING = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_OutOfMemorySavingMsg");
        CANNOT_COMPARE_SNAPSHOTS_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_CannotCompareSnapshotsMsg");
        DIRECTORY_DOESNT_EXIST_CAPTION = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_DirectoryDoesntExistCaption");
        DIRECTORY_DOESNT_EXIST_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_DirectoryDoesntExistMsg");
        CANNOT_OPEN_SNAPSHOT_MSG = NbBundle.getMessage(LoadedSnapshot.class, (String)"ResultsManager_CannotOpenSnapshotMsg");
    }

    static class SelectedFile {
        FileObject folder;
        String fileExt;
        String fileName;

        SelectedFile(FileObject fileObject, String string, String string2) {
            this.folder = fileObject;
            this.fileName = string;
            this.fileExt = string2;
        }
    }
}

