/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.toolbars.ConfigureToolbarPanel;
import org.netbeans.core.windows.view.ui.toolbars.DnDSupport;
import org.netbeans.core.windows.view.ui.toolbars.ResetToolbarsAction;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarContainer;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarRow;
import org.netbeans.spi.settings.Saver;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class ToolbarConfiguration
implements ToolbarPool.Configuration {
    private final JPanel toolbarPanel;
    private static WeakHashMap<String, ToolbarConfiguration> name2config = new WeakHashMap(10);
    private static JMenu toolbarMenu;
    private final String configName;
    private final String configDisplayName;
    private final List<ToolbarRow> rows;
    private DnDSupport dndSupport;
    private Saver saver;
    private List<List<ToolbarConstraints>> snapshot;
    private static Boolean isXP;
    private static Color mid;
    private static final Border lowerBorder;
    private static final Border upperBorder;

    ToolbarConfiguration(String string, String string2, List<ToolbarRow> list) {
        this.configName = string;
        if (string2.endsWith(".xml")) {
            string2 = string2.substring(0, string2.length() - ".xml".length());
        }
        this.configDisplayName = string2;
        name2config.put(string, this);
        this.toolbarPanel = new JPanel(new GridLayout(0, 1));
        this.rows = new ArrayList<ToolbarRow>(list);
    }

    private synchronized DnDSupport dndSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DnDSupport(this);
        }
        return this.dndSupport;
    }

    public static final ToolbarConfiguration findConfiguration(String string) {
        return name2config.get(string);
    }

    private static final ToolbarPool getToolbarPool() {
        return ToolbarPool.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildMenu() {
        Class<ToolbarConfiguration> clazz = ToolbarConfiguration.class;
        synchronized (ToolbarConfiguration.class) {
            if (toolbarMenu != null) {
                toolbarMenu.removeAll();
                this.fillToolbarsMenu(toolbarMenu, false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void fillToolbarsMenu(JComponent jComponent, boolean bl) {
        AbstractButton abstractButton;
        Frame frame = WindowManager.getDefault().getMainWindow();
        boolean bl2 = frame instanceof MainWindow && ((MainWindow)frame).isFullScreenMode();
        Map<String, ToolbarConstraints> map = this.collectAllConstraints();
        Toolbar[] toolbarArray = ToolbarConfiguration.getToolbarPool().getToolbars();
        int n = toolbarArray.length;
        for (int i = 0; i < n; ++i) {
            Component[] componentArray;
            Component[] componentArray2 = componentArray = toolbarArray[i];
            final String string = componentArray.getName();
            ToolbarConstraints object = map.get(string);
            if (object == null || componentArray == null) continue;
            abstractButton = new JCheckBoxMenuItem(componentArray.getDisplayName(), object.isVisible());
            abstractButton.putClientProperty("ToolbarName", string);
            abstractButton.addActionListener(new ActionListener((Toolbar)componentArray2){
                final /* synthetic */ Toolbar val$bar;
                {
                    this.val$bar = toolbar;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ToolbarConstraints toolbarConstraints = ToolbarConfiguration.this.getConstraints(string);
                    ToolbarConfiguration.this.setToolbarVisible(this.val$bar, !toolbarConstraints.isVisible());
                }
            });
            ((JMenuItem)abstractButton).setEnabled(!bl2);
            jComponent.add(abstractButton);
        }
        jComponent.add(new JPopupMenu.Separator());
        boolean bl3 = ToolbarConfiguration.getToolbarPool().getPreferredIconSize() == 16;
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(ToolbarConfiguration.class, (String)"PROP_smallToolbarIcons"), bl3);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                    boolean bl = jCheckBoxMenuItem.getState();
                    if (bl) {
                        ToolbarPool.getDefault().setPreferredIconSize(16);
                    } else {
                        ToolbarPool.getDefault().setPreferredIconSize(24);
                    }
                    String string = ToolbarPool.getDefault().getConfiguration();
                    ToolbarConfiguration toolbarConfiguration = ToolbarConfiguration.findConfiguration(string);
                    if (toolbarConfiguration != null) {
                        toolbarConfiguration.refresh();
                    }
                }
            }
        });
        jCheckBoxMenuItem.setEnabled(!bl2);
        jComponent.add(jCheckBoxMenuItem);
        jComponent.add(new JPopupMenu.Separator());
        JMenuItem jMenuItem = new JMenuItem(new ResetToolbarsAction());
        jMenuItem.setEnabled(!bl2);
        jComponent.add(jMenuItem);
        jMenuItem = new JMenuItem(NbBundle.getMessage(ToolbarConfiguration.class, (String)"CTL_CustomizeToolbars"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureToolbarPanel.showConfigureDialog();
            }
        });
        jMenuItem.setEnabled(!bl2);
        jComponent.add(jMenuItem);
        for (Component component : jComponent instanceof JPopupMenu ? jComponent.getComponents() : ((JMenu)jComponent).getPopupMenu().getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            abstractButton = (AbstractButton)component;
            if (bl) {
                abstractButton.setText(Actions.cutAmpersand((String)abstractButton.getText()));
                continue;
            }
            Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)abstractButton.getText());
        }
    }

    void refresh() {
        Toolbar toolbar;
        this.toolbarPanel.removeAll();
        Toolbar[] toolbarArray = ToolbarConfiguration.getToolbarPool().getToolbars();
        HashMap<String, Toolbar> hashMap = new HashMap<String, Toolbar>(toolbarArray.length);
        boolean bl = ToolbarConfiguration.getToolbarPool().getPreferredIconSize() == 16;
        for (int i = 0; i < toolbarArray.length; ++i) {
            Toolbar object = toolbarArray[i];
            String string = object.getName();
            ToolbarConstraints toolbarConstraints = this.getConstraints(string);
            toolbar = object.getComponents();
            for (int j = 0; j < ((Component[])toolbar).length; ++j) {
                if (!(toolbar[j] instanceof JComponent)) continue;
                if (bl) {
                    ((JComponent)toolbar[j]).putClientProperty("PreferredIconSize", null);
                    continue;
                }
                ((JComponent)toolbar[j]).putClientProperty("PreferredIconSize", 24);
            }
            hashMap.put(string, object);
        }
        this.removeEmptyRows();
        for (ToolbarRow toolbarRow : this.rows) {
            toolbarRow.removeAll();
            if (!toolbarRow.isVisible()) continue;
            for (ToolbarConstraints toolbarConstraints : toolbarRow.getConstraints()) {
                if (!toolbarConstraints.isVisible() || null == (toolbar = (Toolbar)hashMap.get(toolbarConstraints.getName()))) continue;
                ToolbarContainer toolbarContainer = new ToolbarContainer(toolbar, this.dndSupport(), toolbarConstraints.isDraggable());
                toolbarRow.add(toolbarConstraints.getName(), toolbarContainer);
            }
            this.toolbarPanel.add(toolbarRow);
        }
        this.adjustToolbarPanelBorder();
        this.rebuildMenu();
        this.repaint();
    }

    ToolbarRow maybeAddEmptyRow(Point point) {
        if (this.rows.isEmpty()) {
            return null;
        }
        if (this.rows.size() > 0 && this.rows.get(this.rows.size() - 1).isEmpty()) {
            return null;
        }
        if (!this.toolbarPanel.isShowing()) {
            return null;
        }
        int n = this.rows.get(0).getHeight();
        int n2 = this.toolbarPanel.getLocationOnScreen().y + this.toolbarPanel.getHeight();
        if (point.y >= n2 && point.y <= n2 + n) {
            ToolbarRow toolbarRow = new ToolbarRow();
            this.rows.add(toolbarRow);
            this.toolbarPanel.add(toolbarRow);
            this.repaint();
            return toolbarRow;
        }
        return null;
    }

    boolean isLastRow(ToolbarRow toolbarRow) {
        return this.rows.size() > 1 && this.rows.get(this.rows.size() - 1) == toolbarRow;
    }

    void maybeRemoveLastRow() {
        ToolbarRow toolbarRow;
        if (this.rows.size() > 1 && (toolbarRow = this.rows.get(this.rows.size() - 1)).isEmpty()) {
            this.rows.remove(toolbarRow);
            this.toolbarPanel.remove(toolbarRow);
            this.repaint();
        }
    }

    void removeEmptyRows() {
        ArrayList<ToolbarRow> arrayList = new ArrayList<ToolbarRow>(this.rows.size());
        for (ToolbarRow toolbarRow : this.rows) {
            if (!toolbarRow.isEmpty()) continue;
            arrayList.add(toolbarRow);
            this.toolbarPanel.remove(toolbarRow);
        }
        this.rows.removeAll(arrayList);
        this.repaint();
    }

    void repaint() {
        this.toolbarPanel.invalidate();
        this.toolbarPanel.revalidate();
        this.toolbarPanel.repaint();
    }

    public Component activate() {
        this.refresh();
        return this.toolbarPanel;
    }

    public String getName() {
        return this.configName;
    }

    public String getDisplayName() {
        return this.configDisplayName;
    }

    public JPopupMenu getContextMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.fillToolbarsMenu(jPopupMenu, true);
        return jPopupMenu;
    }

    public JMenu getToolbarsMenu(JMenu jMenu) {
        this.fillToolbarsMenu(jMenu, false);
        toolbarMenu = jMenu;
        return jMenu;
    }

    public void setToolbarVisible(Toolbar toolbar, boolean bl) {
        ToolbarConstraints toolbarConstraints = this.getConstraints(toolbar.getName());
        boolean bl2 = toolbarConstraints.isVisible();
        toolbarConstraints.setVisible(bl);
        if (bl != bl2) {
            this.refresh();
            this.save();
        }
    }

    public boolean isToolbarVisible(Toolbar toolbar) {
        ToolbarConstraints toolbarConstraints = this.getConstraints(toolbar.getName());
        return toolbarConstraints.isVisible();
    }

    void setToolbarButtonDragAndDropAllowed(boolean bl) {
        this.dndSupport().setButtonDragAndDropAllowed(bl);
    }

    private ToolbarConstraints getConstraints(String string) {
        ToolbarConstraints toolbarConstraints = this.collectAllConstraints().get(string);
        if (null == toolbarConstraints) {
            boolean bl = "QuickSearch".equals(string);
            toolbarConstraints = new ToolbarConstraints(string, bl ? ToolbarConstraints.Align.right : ToolbarConstraints.Align.left, true, true);
            ToolbarRow toolbarRow = null;
            if (this.rows.isEmpty()) {
                toolbarRow = new ToolbarRow();
                this.rows.add(toolbarRow);
            } else {
                toolbarRow = bl ? this.rows.get(0) : this.rows.get(this.rows.size() - 1);
            }
            toolbarRow.addConstraint(toolbarConstraints);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolbarConfiguration.this.refresh();
                }
            });
        }
        return toolbarConstraints;
    }

    ToolbarRow getToolbarRowAt(Point point) {
        Rectangle rectangle = new Rectangle();
        for (ToolbarRow toolbarRow : this.rows) {
            rectangle = toolbarRow.getBounds(rectangle);
            if (!toolbarRow.isShowing()) continue;
            rectangle.setLocation(toolbarRow.getLocationOnScreen());
            if (!rectangle.contains(point)) continue;
            return toolbarRow;
        }
        return null;
    }

    void save() {
        if (null == this.saver) {
            return;
        }
        try {
            this.createSnapshot();
            this.saver.requestSave();
        }
        catch (IOException iOException) {
            Logger.getLogger(ToolbarConfiguration.class.getName()).log(Level.INFO, "Error while saving toolbar configuration", iOException);
        }
    }

    void setSaverCallback(Saver saver) {
        this.saver = saver;
    }

    private void createSnapshot() {
        this.snapshot = new ArrayList<List<ToolbarConstraints>>(this.rows.size());
        for (ToolbarRow toolbarRow : this.rows) {
            ArrayList<ToolbarConstraints> arrayList = new ArrayList<ToolbarConstraints>(20);
            for (ToolbarConstraints toolbarConstraints : toolbarRow.getConstraints()) {
                arrayList.add(toolbarConstraints);
            }
            this.snapshot.add(arrayList);
        }
    }

    List<? extends List<? extends ToolbarConstraints>> getSnapshot() {
        return this.snapshot;
    }

    private Map<String, ToolbarConstraints> collectAllConstraints() {
        HashMap<String, ToolbarConstraints> hashMap = new HashMap<String, ToolbarConstraints>(20);
        for (ToolbarRow toolbarRow : this.rows) {
            for (ToolbarConstraints toolbarConstraints : toolbarRow.getConstraints()) {
                hashMap.put(toolbarConstraints.getName(), toolbarConstraints);
            }
        }
        return hashMap;
    }

    private static boolean isXPTheme() {
        if (isXP == null) {
            Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
            isXP = Boolean.TRUE.equals(bl) ? Boolean.TRUE : Boolean.FALSE;
        }
        return isXP;
    }

    private static Color fetchColor(String string, Color color) {
        Color color2 = (Color)UIManager.get(string);
        if (color2 == null) {
            color2 = color;
        }
        return color2;
    }

    private void adjustToolbarPanelBorder() {
        if (this.toolbarPanel.getComponentCount() > 0) {
            if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                if (ToolbarConfiguration.isXPTheme()) {
                    this.toolbarPanel.setBorder(BorderFactory.createCompoundBorder(upperBorder, BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ToolbarConfiguration.fetchColor("controlShadow", Color.DARK_GRAY)), BorderFactory.createMatteBorder(0, 0, 1, 0, mid))));
                } else {
                    this.toolbarPanel.setBorder(BorderFactory.createEtchedBorder());
                }
            } else if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
                this.toolbarPanel.setBorder(BorderFactory.createEmptyBorder());
            }
        } else if ("GTK".equals(UIManager.getLookAndFeel().getID())) {
            this.toolbarPanel.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.toolbarPanel.setBorder(lowerBorder);
        }
    }

    static {
        isXP = null;
        Color color = ToolbarConfiguration.fetchColor("controlShadow", Color.DARK_GRAY);
        Color color2 = ToolbarConfiguration.fetchColor("control", Color.GRAY);
        int n = (color.getRed() + color2.getRed()) / 2;
        int n2 = (color.getGreen() + color2.getGreen()) / 2;
        int n3 = (color.getBlue() + color2.getBlue()) / 2;
        mid = new Color(n, n2, n3);
        lowerBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ToolbarConfiguration.fetchColor("controlShadow", Color.DARK_GRAY)), BorderFactory.createMatteBorder(0, 0, 1, 0, mid));
        upperBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ToolbarConfiguration.fetchColor("controlShadow", Color.DARK_GRAY)), BorderFactory.createMatteBorder(1, 0, 0, 0, ToolbarConfiguration.fetchColor("controlLtHighlight", Color.WHITE)));
    }
}

