/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.tree.TreeNode;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

final class VisualizerChildren {
    public static final VisualizerChildren EMPTY = new VisualizerChildren();
    public final VisualizerNode parent;
    private final List<VisualizerNode> visNodes;
    private List<Node> snapshot;

    private VisualizerChildren() {
        this.visNodes = Collections.emptyList();
        this.snapshot = Collections.emptyList();
        this.parent = null;
    }

    public VisualizerChildren(VisualizerNode visualizerNode, List<Node> list) {
        this.parent = visualizerNode;
        int n = list.size();
        this.visNodes = new ArrayList<VisualizerNode>(n);
        for (int i = 0; i < n; ++i) {
            this.visNodes.add(null);
        }
        this.snapshot = list;
    }

    private final void recomputeIndexes(VisualizerNode visualizerNode) {
        VisualizerNode visualizerNode2;
        int n;
        assert (this.visNodes.size() == this.snapshot.size()) : "visnodes.size()=" + this.visNodes.size() + " snapshot.size()=" + this.snapshot.size();
        for (n = 0; n < this.visNodes.size(); ++n) {
            visualizerNode2 = this.visNodes.get(n);
            if (visualizerNode2 == null) continue;
            visualizerNode2.indexOf = n;
        }
        if (visualizerNode != null && visualizerNode.indexOf == -1) {
            n = 0;
            while (n < this.visNodes.size()) {
                visualizerNode2 = (VisualizerNode)this.getChildAt(n);
                visualizerNode2.indexOf = n++;
                if (visualizerNode2 != visualizerNode) continue;
                return;
            }
        }
    }

    public TreeNode getChildAt(int n) {
        if (n >= this.visNodes.size()) {
            return VisualizerNode.EMPTY;
        }
        VisualizerNode visualizerNode = this.visNodes.get(n);
        if (visualizerNode == null) {
            Node node = this.snapshot.get(n);
            visualizerNode = VisualizerNode.getVisualizer(this, node);
            visualizerNode.indexOf = n;
            this.visNodes.set(n, visualizerNode);
            this.parent.notifyVisualizerChildrenChange(false, this);
        }
        return visualizerNode;
    }

    public int getChildCount() {
        return this.visNodes.size();
    }

    public Enumeration<VisualizerNode> children(final boolean bl) {
        return new Enumeration<VisualizerNode>(){
            private int index;

            @Override
            public boolean hasMoreElements() {
                return this.index < VisualizerChildren.this.visNodes.size();
            }

            @Override
            public VisualizerNode nextElement() {
                return bl ? (VisualizerNode)VisualizerChildren.this.getChildAt(this.index++) : (VisualizerNode)VisualizerChildren.this.visNodes.get(this.index++);
            }
        };
    }

    public int getIndex(TreeNode treeNode) {
        VisualizerNode visualizerNode = (VisualizerNode)treeNode;
        if (visualizerNode.indexOf != -1) {
            if (visualizerNode.indexOf >= this.visNodes.size() || this.visNodes.get(visualizerNode.indexOf) != visualizerNode) {
                return -1;
            }
        } else {
            this.recomputeIndexes(visualizerNode);
        }
        return visualizerNode.indexOf;
    }

    final String dumpIndexes(VisualizerNode visualizerNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EMPTY: " + (visualizerNode == VisualizerNode.EMPTY) + ", Lazy: " + this.snapshot.getClass().getName().endsWith("LazySnapshot"));
        stringBuilder.append("\nSeeking for: ").append(visualizerNode.toId());
        stringBuilder.append("\nwith parent: ").append((VisualizerNode)visualizerNode.getParent() != null ? ((VisualizerNode)visualizerNode.getParent()).toId() : "null");
        stringBuilder.append("\nSeeking in : ").append(this.parent != null ? this.parent.toId() : "null").append("\n");
        this.addVisNodesInfo(stringBuilder);
        return stringBuilder.toString();
    }

    private void addVisNodesInfo(StringBuilder stringBuilder) {
        for (int i = 0; i < this.visNodes.size(); ++i) {
            VisualizerNode visualizerNode = this.visNodes.get(i);
            stringBuilder.append("  ").append(i);
            if (visualizerNode != null) {
                stringBuilder.append(" = ").append(visualizerNode.toId());
            } else {
                stringBuilder.append(" = null");
            }
            stringBuilder.append('\n');
        }
    }

    final String dumpEventInfo(VisualizerEvent visualizerEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nEvent: " + visualizerEvent.getClass().getName());
        stringBuilder.append("\nOriginal event: " + visualizerEvent.originalEvent.getClass().getName());
        stringBuilder.append("\ncurrent vis. nodes:");
        this.addVisNodesInfo(stringBuilder);
        stringBuilder.append("\nIndexes: ");
        int[] nArray = visualizerEvent.getArray();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(Integer.toString(nArray[i]));
            stringBuilder.append(" ");
        }
        stringBuilder.append("\n");
        stringBuilder.append(visualizerEvent.originalEvent.toString());
        return stringBuilder.toString();
    }

    public void added(VisualizerEvent.Added added) {
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = added.getSnapshot();
        ListIterator<VisualizerNode> listIterator = this.visNodes.listIterator();
        int[] nArray = added.getArray();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            while (n++ < nArray[i]) {
                listIterator.next();
            }
            listIterator.add(null);
        }
        this.recomputeIndexes(null);
        for (VisualizerNode visualizerNode = this.parent; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            Object[] objectArray = visualizerNode.getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((NodeModel)objectArray[i]).added(added);
            }
        }
    }

    public void removed(VisualizerEvent.Removed removed) {
        Object[] objectArray;
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = removed.getSnapshot();
        int[] nArray = removed.getArray();
        if (nArray.length == 0) {
            return;
        }
        assert (this.visNodes.size() > nArray[nArray.length - 1]) : this.dumpEventInfo(removed);
        for (int i = nArray.length - 1; i >= 0; --i) {
            objectArray = this.visNodes.remove(nArray[i]);
            removed.removed.add((VisualizerNode)(objectArray != null ? objectArray : VisualizerNode.EMPTY));
        }
        this.recomputeIndexes(null);
        for (VisualizerNode visualizerNode = this.parent; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            objectArray = visualizerNode.getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((NodeModel)objectArray[i]).removed(removed);
            }
        }
        if (this.visNodes.isEmpty()) {
            this.parent.notifyVisualizerChildrenChange(true, this);
        }
    }

    public void reordered(VisualizerEvent.Reordered reordered) {
        int n;
        Object[] objectArray;
        if (this != this.parent.getChildren()) {
            return;
        }
        this.snapshot = reordered.getSnapshot();
        int[] nArray = reordered.getArray();
        VisualizerNode[] visualizerNodeArray = this.visNodes.toArray(new VisualizerNode[this.visNodes.size()]);
        VisualizerNode[] visualizerNodeArray2 = new VisualizerNode[visualizerNodeArray.length];
        int n2 = nArray.length;
        try {
            for (int i = 0; i < n2; ++i) {
                objectArray = visualizerNodeArray[i];
                n = nArray[i];
                if (visualizerNodeArray2[n] != null) {
                    System.err.println("Writing to this index for the second time: " + n);
                    System.err.println("Length of indxs array: " + nArray.length);
                    System.err.println("Length of actual array: " + visualizerNodeArray.length);
                    System.err.println("Indices of reorder event:");
                    int n3 = 0;
                    while (i < nArray.length) {
                        System.err.println("\t" + nArray[n3]);
                        ++n3;
                    }
                    Thread.dumpStack();
                    return;
                }
                visualizerNodeArray2[n] = objectArray;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            System.err.println("Length of actual array: " + visualizerNodeArray.length);
            System.err.println("Indices of reorder event:");
            for (int i = 0; i < nArray.length; ++i) {
                System.err.println("\t" + nArray[i]);
            }
            return;
        }
        this.visNodes.clear();
        this.visNodes.addAll(Arrays.asList(visualizerNodeArray2));
        this.recomputeIndexes(null);
        for (VisualizerNode visualizerNode = this.parent; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            objectArray = visualizerNode.getListenerList();
            for (n = objectArray.length - 1; n >= 0; n -= 2) {
                ((NodeModel)objectArray[n]).reordered(reordered);
            }
        }
    }

    public String toString() {
        String string = "";
        if (this.parent != null) {
            string = "Parent: " + this.parent + " ";
        }
        string = string + "[";
        for (VisualizerNode visualizerNode : this.visNodes) {
            VisualizerChildren visualizerChildren;
            string = string + visualizerNode;
            if (visualizerNode != null && (visualizerChildren = visualizerNode.getChildren(false)) != EMPTY) {
                string = string + visualizerChildren;
            }
            string = string + " ";
        }
        string = string + " {" + this.snapshot + "}";
        string = string + "]";
        return string;
    }
}

