/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.explorer.propertysheet.CheckboxInplaceEditor;
import org.openide.explorer.propertysheet.EditorPropertyDisplayer;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDisplayer_Inline;
import org.openide.explorer.propertysheet.PropertyDisplayer_Mutable;
import org.openide.explorer.propertysheet.RadioInplaceEditor;
import org.openide.explorer.propertysheet.RendererFactory;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.ReusablePropertyModel;
import org.openide.nodes.Node;

final class RendererPropertyDisplayer
extends JComponent
implements PropertyDisplayer_Mutable,
PropertyDisplayer_Inline {
    private boolean showCustomEditorButton = true;
    private boolean tableUI = false;
    private int radioButtonMax = 0;
    private boolean useLabels = true;
    private Node.Property prop;
    private boolean radioBoolean;
    private ReusablePropertyEnv reusableEnv = new ReusablePropertyEnv();
    private ReusablePropertyModel reusableModel = new ReusablePropertyModel(this.reusableEnv);
    boolean inGetRenderer = false;
    private Dimension prefSize = null;
    private RendererFactory rendererFactory1 = null;
    private RendererFactory rendererFactory2 = null;

    public RendererPropertyDisplayer(Node.Property property) {
        this.prop = property;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Node.Property getProperty() {
        return this.prop;
    }

    @Override
    public void refresh() {
        this.repaint();
    }

    @Override
    public void validate() {
        if (!this.tableUI) {
            super.validate();
        }
    }

    @Override
    public boolean isValid() {
        if (this.tableUI) {
            return true;
        }
        return super.isValid();
    }

    @Override
    public boolean isShowing() {
        if (this.tableUI) {
            return true;
        }
        return super.isShowing();
    }

    @Override
    public void setProperty(Node.Property property) {
        if (property == null) {
            throw new NullPointerException("Property cannot be null");
        }
        if (property != this.prop) {
            this.prop = property;
            this.prefSize = null;
            if (this.isShowing()) {
                this.firePropertyChange("preferredSize", null, null);
            }
            this.repaint();
        }
    }

    @Override
    public final boolean isShowCustomEditorButton() {
        Boolean bl;
        boolean bl2 = this.showCustomEditorButton;
        if (this.getProperty() != null && (bl = (Boolean)this.getProperty().getValue("suppressCustomEditor")) != null) {
            bl2 = bl == false;
        }
        return bl2;
    }

    @Override
    public boolean isTableUI() {
        return this.tableUI;
    }

    @Override
    public boolean isUseLabels() {
        return this.useLabels;
    }

    @Override
    public void setUseLabels(boolean bl) {
        if (bl != this.useLabels) {
            JComponent jComponent;
            Dimension dimension = null;
            if (this.isShowing() && ((jComponent = RendererPropertyDisplayer.findInnermostRenderer(this.getRenderer(this))) instanceof RadioInplaceEditor || jComponent instanceof JCheckBox)) {
                dimension = this.getPreferredSize();
            }
            this.useLabels = bl;
            if (dimension != null) {
                this.firePropertyChange("preferredSize", dimension, this.getPreferredSize());
            }
        }
    }

    @Override
    public void setShowCustomEditorButton(boolean bl) {
        Serializable serializable;
        if (this.getProperty() != null && (serializable = (Boolean)this.getProperty().getValue("suppressCustomEditor")) != null) {
            bl = serializable;
        }
        if (this.showCustomEditorButton != bl) {
            this.prefSize = null;
            serializable = null;
            if (this.isShowing()) {
                serializable = this.getPreferredSize();
            }
            this.showCustomEditorButton = bl;
            if (serializable != null) {
                this.firePropertyChange("preferredSize", serializable, this.getPreferredSize());
                this.repaint();
            }
        }
    }

    @Override
    public void setTableUI(boolean bl) {
        if (bl != this.tableUI) {
            this.tableUI = bl;
            this.repaint();
        }
    }

    @Override
    public int getRadioButtonMax() {
        return this.radioButtonMax;
    }

    @Override
    public void setRadioButtonMax(int n) {
        if (n != this.radioButtonMax) {
            PropertyEditor propertyEditor;
            String[] stringArray;
            Dimension dimension = null;
            if (this.isShowing()) {
                dimension = this.getPreferredSize();
            }
            int n2 = this.radioButtonMax;
            this.radioButtonMax = n;
            if (dimension != null && (stringArray = (propertyEditor = PropUtils.getPropertyEditor(this.prop)).getTags()) != null && stringArray.length >= n != stringArray.length >= n2) {
                this.firePropertyChange("preferredSize", dimension, this.getPreferredSize());
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Inline editor for property ");
        stringBuffer.append(this.getProperty().getDisplayName());
        stringBuffer.append(" = ");
        stringBuffer.append(this.getProperty());
        stringBuffer.append(" inplace editor=");
        if (!this.inGetRenderer) {
            try {
                stringBuffer.append(this.getRenderer(this));
            }
            catch (Exception exception) {
                stringBuffer.append(exception);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.reusableEnv.setNode(EditorPropertyDisplayer.findBeans(this));
        JComponent jComponent = this.getRenderer(this);
        this.prepareRenderer(jComponent);
        jComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
        if (jComponent instanceof InplaceEditor) {
            JComponent jComponent2 = RendererPropertyDisplayer.findInnermostRenderer(jComponent);
            SwingUtilities.paintComponent(graphics, jComponent, this, 0, 0, this.getWidth(), this.getHeight());
            return;
        }
        jComponent.paint(graphics);
    }

    protected void superPaintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    JComponent getRenderer(PropertyDisplayer_Inline propertyDisplayer_Inline) {
        this.inGetRenderer = true;
        JComponent jComponent = this.rfactory(propertyDisplayer_Inline).getRenderer(propertyDisplayer_Inline.getProperty());
        if (propertyDisplayer_Inline.isTableUI() && null == jComponent.getBorder()) {
            jComponent.setBorder(BorderFactory.createEmptyBorder());
        }
        this.inGetRenderer = false;
        return jComponent;
    }

    protected void prepareRenderer(JComponent jComponent) {
        jComponent.setBackground(this.getBackground());
        jComponent.setForeground(this.getForeground());
        jComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
        JComponent jComponent2 = RendererPropertyDisplayer.findInnermostRenderer(jComponent);
        if (jComponent2 instanceof JComboBox && jComponent.getLayout() != null) {
            jComponent.getLayout().layoutContainer(jComponent);
        }
        if (!this.isTableUI() && ((InplaceEditor)((Object)jComponent)).supportsTextEntry()) {
            jComponent2.setBackground(PropUtils.getTextFieldBackground());
            jComponent2.setForeground(PropUtils.getTextFieldForeground());
        }
    }

    @Override
    public boolean isTitleDisplayed() {
        if (!this.useLabels) {
            return false;
        }
        JComponent jComponent = this.getRenderer(this);
        if (jComponent instanceof InplaceEditor) {
            InplaceEditor inplaceEditor = PropUtils.findInnermostInplaceEditor((InplaceEditor)((Object)jComponent));
            return inplaceEditor instanceof CheckboxInplaceEditor || inplaceEditor instanceof RadioInplaceEditor;
        }
        return false;
    }

    static JComponent findInnermostRenderer(JComponent jComponent) {
        if (jComponent instanceof InplaceEditor) {
            InplaceEditor inplaceEditor = (InplaceEditor)((Object)jComponent);
            return PropUtils.findInnermostInplaceEditor(inplaceEditor).getComponent();
        }
        return jComponent;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            JComponent jComponent = this.getRenderer(this);
            this.prefSize = jComponent.getPreferredSize();
        }
        return this.prefSize;
    }

    RendererFactory rfactory(PropertyDisplayer_Inline propertyDisplayer_Inline) {
        RendererFactory rendererFactory;
        if (propertyDisplayer_Inline.isTableUI()) {
            if (this.rendererFactory1 == null) {
                this.rendererFactory1 = new RendererFactory(propertyDisplayer_Inline.isTableUI(), propertyDisplayer_Inline.getReusablePropertyEnv(), propertyDisplayer_Inline.getReusablePropertyEnv().getReusablePropertyModel());
            }
            rendererFactory = this.rendererFactory1;
        } else {
            if (this.rendererFactory2 == null) {
                this.rendererFactory2 = new RendererFactory(propertyDisplayer_Inline.isTableUI(), propertyDisplayer_Inline.getReusablePropertyEnv(), propertyDisplayer_Inline.getReusablePropertyEnv().getReusablePropertyModel());
            }
            rendererFactory = this.rendererFactory2;
        }
        rendererFactory.setUseRadioBoolean(propertyDisplayer_Inline.isRadioBoolean());
        rendererFactory.setUseLabels(propertyDisplayer_Inline.isUseLabels());
        rendererFactory.setRadioButtonMax(propertyDisplayer_Inline.getRadioButtonMax());
        return rendererFactory;
    }

    @Override
    public boolean isRadioBoolean() {
        return this.radioBoolean;
    }

    @Override
    public void setRadioBoolean(boolean bl) {
        this.radioBoolean = bl;
    }

    @Override
    public ReusablePropertyEnv getReusablePropertyEnv() {
        return this.reusableEnv;
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
    }
}

