/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.netbeans.modules.options.keymap.Popupable;
import org.netbeans.modules.options.keymap.ShortcutTextField;
import org.netbeans.modules.options.keymap.SpecialkeyPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ShortcutCellPanel
extends JPanel
implements Comparable,
Popupable {
    private Popup popup;
    private final SpecialkeyPanel specialkeyList;
    PopupFactory factory = PopupFactory.getSharedInstance();
    private JButton changeButton;
    private JTextField scField;

    public ShortcutCellPanel() {
        this.initComponents();
        this.specialkeyList = new SpecialkeyPanel(this, this.scField);
        this.changeButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ShortcutCellPanel.this.hidePopup();
            }
        });
        this.changeButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    JTable jTable = (JTable)ShortcutCellPanel.this.scField.getParent().getParent();
                    int n = jTable.getEditingRow();
                    jTable.editCellAt(n, 1);
                    jTable.setRowSelectionInterval(n, n);
                    ShortcutCellPanel.this.scField.requestFocus();
                }
            }
        });
        this.scField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ShortcutCellPanel.this.changeButton.setText("");
                ShortcutCellPanel.this.changeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/options/keymap/more.png")));
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ShortcutCellPanel.this.changeButton.setIcon(null);
                ShortcutCellPanel.this.changeButton.setText("...");
            }
        });
    }

    ShortcutCellPanel(String string) {
        this();
        this.setText(string);
    }

    public void setText(String string) {
        this.scField.setText(string);
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public String toString() {
        return this.scField.getText();
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        int n = this.changeButton.getPreferredSize().width;
        this.scField.setPreferredSize(new Dimension(dimension.width - n, dimension.height));
        this.changeButton.setPreferredSize(new Dimension(n, dimension.height));
    }

    void setBgColor(Color color) {
        this.scField.setBackground(color);
        this.changeButton.setBackground(new Color(204, 204, 204));
    }

    void setFgCOlor(Color color) {
        this.scField.setForeground(color);
    }

    public JButton getButton() {
        return this.changeButton;
    }

    public JTextField getTextField() {
        return this.scField;
    }

    private void initComponents() {
        this.scField = new ShortcutTextField();
        this.changeButton = new JButton();
        this.setBackground(new Color(204, 204, 204));
        this.setPreferredSize(new Dimension(134, 15));
        this.scField.setText(NbBundle.getMessage(ShortcutCellPanel.class, (String)"ShortcutCellPanel.scField.text"));
        this.scField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.changeButton.setBackground(new Color(204, 204, 204));
        Mnemonics.setLocalizedText((AbstractButton)this.changeButton, (String)NbBundle.getMessage(ShortcutCellPanel.class, (String)"ShortcutCellPanel.changeButton.text"));
        this.changeButton.setMaximumSize(new Dimension(20, 15));
        this.changeButton.setMinimumSize(new Dimension(20, 15));
        this.changeButton.setPreferredSize(new Dimension(20, 15));
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutCellPanel.this.changeButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scField, -1, 119, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.changeButton, -2, 15, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scField, -2, 15, -2).addComponent(this.changeButton, -2, 15, -2));
    }

    private void changeButtonActionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        Point point = new Point(jComponent.getX(), jComponent.getY());
        SwingUtilities.convertPointToScreen(point, this);
        if (this.popup == null) {
            this.popup = Utilities.isUnix() ? PopupFactory.getSharedInstance().getPopup(null, this.specialkeyList, point.x, point.y) : this.factory.getPopup(this, this.specialkeyList, point.x, point.y);
        }
        this.popup.show();
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    @Override
    public Popup getPopup() {
        return this.popup;
    }

    void setButtontext(String string) {
        this.changeButton.setText(string);
    }
}

