/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class ClassInfoStorage {
    public static final String PROP_CLASS_INFO_CHANGED = "Class2Paths.PROP_CLASS_MAPPING_CHANGED";
    public static final String PROP_CLASS_INFO_ADDED = "Class2Paths.PROP_CLASS_MAPPING_ADDED";
    public static final String PROP_CLASS_INFO_REMOVED = "Class2Paths.PROP_CLASS_MAPPING_REMOVED";
    private static Logger LOG = Logger.getLogger(ClassInfoStorage.class.getName());
    private static ClassInfoStorage instance = null;
    private Lookup.Result<Class2LayerFolder> mappers = null;
    private L mappersListener = null;
    private final String LOCK = new String("Class2Paths.LOCK");
    private Map<String, Info> mapping = new HashMap<String, Info>();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static synchronized ClassInfoStorage getInstance() {
        if (instance == null) {
            instance = new ClassInfoStorage();
        }
        return instance;
    }

    private ClassInfoStorage() {
        this.mappers = Lookup.getDefault().lookupResult(Class2LayerFolder.class);
        this.mappersListener = new L();
        this.mappers.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this.mappersListener), this.mappers));
        this.rebuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo(String string) {
        String string2 = this.LOCK;
        synchronized (string2) {
            if (this.mapping.containsKey(string)) {
                return this.mapping.get(string);
            }
            return new Info(this, string, null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyChangeEvent> rebuild() {
        String string = this.LOCK;
        synchronized (string) {
            ArrayList<PropertyChangeEvent> arrayList;
            Object object;
            Object object22;
            HashMap<String, Info> hashMap = new HashMap<String, Info>();
            for (Object object22 : this.mappers.allInstances()) {
                object = object22.getClazz().getName();
                arrayList = object22.getLayerFolderName();
                Object object3 = object22.getInstanceProvider();
                if (arrayList != null) {
                    arrayList = ((String)((Object)arrayList)).trim();
                }
                if ((arrayList == null || ((String)((Object)arrayList)).length() == 0) && object3 == null) continue;
                if (!hashMap.containsKey(object)) {
                    hashMap.put((String)object, new Info(this, (String)object, (String)((Object)arrayList), (InstanceProvider)object3));
                    continue;
                }
                LOG.warning("The mapping for class '" + (String)object + "' to folder '" + (String)((Object)arrayList) + "' and InstanceProvider '" + object3 + "' has already been " + "defined by another mapper. Ignoring mapper " + object22);
            }
            HashSet<String> hashSet = new HashSet<String>(this.mapping.keySet());
            hashSet.removeAll(hashMap.keySet());
            object22 = new HashSet(hashMap.keySet());
            object22.removeAll(this.mapping.keySet());
            object = new HashSet();
            for (Object object3 : hashMap.keySet()) {
                if (!this.mapping.containsKey(object3) || Utilities.compareObjects(hashMap.get(object3), (Object)this.mapping.get(object3))) continue;
                object.add(object3);
            }
            this.mapping.clear();
            this.mapping.putAll(hashMap);
            arrayList = new ArrayList<PropertyChangeEvent>(3);
            if (!hashSet.isEmpty()) {
                arrayList.add(new PropertyChangeEvent(this, PROP_CLASS_INFO_REMOVED, null, hashSet));
            }
            if (!object22.isEmpty()) {
                arrayList.add(new PropertyChangeEvent(this, PROP_CLASS_INFO_ADDED, null, object22));
            }
            if (!object.isEmpty()) {
                arrayList.add(new PropertyChangeEvent(this, PROP_CLASS_INFO_CHANGED, null, object));
            }
            return arrayList;
        }
    }

    public static final class Info {
        private ClassInfoStorage storage;
        private String className;
        private String extraPath;
        private String instanceProviderClass;
        private Reference<InstanceProvider<?>> ref;

        private Info(ClassInfoStorage classInfoStorage, String string, String string2, InstanceProvider<?> instanceProvider) {
            this.storage = classInfoStorage;
            this.className = string;
            String string3 = this.extraPath = string2 == null ? "" : string2;
            if (instanceProvider != null) {
                this.instanceProviderClass = instanceProvider.getClass().getName();
                this.ref = new WeakReference(instanceProvider);
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String getExtraPath() {
            return this.extraPath;
        }

        public String getInstanceProviderClass() {
            return this.instanceProviderClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InstanceProvider<?> getInstanceProvider() {
            String string = this.storage.LOCK;
            synchronized (string) {
                if (this.ref == null) {
                    return null;
                }
                InstanceProvider instanceProvider = this.ref.get();
                if (instanceProvider == null) {
                    for (Class2LayerFolder class2LayerFolder : this.storage.mappers.allInstances()) {
                        String string2 = class2LayerFolder.getClazz().getName();
                        if (!this.className.equals(string2)) continue;
                        instanceProvider = class2LayerFolder.getInstanceProvider();
                        break;
                    }
                    if (instanceProvider != null) {
                        this.ref = new WeakReference(instanceProvider);
                    }
                }
                return instanceProvider;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Info) {
                Info info = (Info)object;
                return this.className.equals(info.className) && Utilities.compareObjects((Object)this.extraPath, (Object)info.extraPath) && Utilities.compareObjects((Object)this.instanceProviderClass, (Object)info.instanceProviderClass);
            }
            return false;
        }

        public int hashCode() {
            int n = this.className.hashCode();
            if (this.extraPath != null) {
                n += 7 * this.extraPath.hashCode();
            }
            if (this.instanceProviderClass != null) {
                n += 13 * this.instanceProviderClass.hashCode();
            }
            return n;
        }

        public String toString() {
            return "ClassInfoStorage.Info[className=" + this.className + ",extraPath=" + this.extraPath + ",instanceProviderClass=" + this.instanceProviderClass + "]";
        }
    }

    private class L
    implements LookupListener {
        private L() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            for (PropertyChangeEvent propertyChangeEvent : ClassInfoStorage.this.rebuild()) {
                ClassInfoStorage.this.pcs.firePropertyChange(propertyChangeEvent);
            }
        }
    }
}

