/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class FileSystemRefreshAction
extends CookieAction {
    protected Class<?>[] cookieClasses() {
        return new Class[]{DataFolder.class};
    }

    protected void performAction(Node[] nodeArray) {
        for (Node node : nodeArray) {
            DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
            if (dataFolder == null) continue;
            FileObject fileObject = dataFolder.getPrimaryFile();
            fileObject.refresh();
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected int mode() {
        return 4;
    }

    public String getName() {
        return NbBundle.getBundle(DataObject.class).getString("LAB_Refresh");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FileSystemRefreshAction.class);
    }
}

