/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sampler;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.netbeans.core.ui.sampler.SamplesOutputStream;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class SelfSamplerAction
extends AbstractAction
implements AWTEventListener {
    private static final String ACTION_NAME_START = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStart");
    private static final String ACTION_NAME_STOP = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ActionNameStop");
    private static final String THREAD_NAME = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_ThreadName");
    private static final String NOT_SUPPORTED = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_NotSupported");
    private static final String SAVE_MSG = NbBundle.getMessage(SelfSamplerAction.class, (String)"SelfSamplerAction_SavedFile");
    private static final String DEBUG_ARG = "-Xdebug";
    private static final Logger LOGGER = Logger.getLogger(SelfSamplerAction.class.getName());
    private static final int SAMPLER_RATE = 10;
    private static final double MAX_AVERAGE = 30.0;
    private static final double MAX_STDDEVIATION = 40.0;
    private static final int MAX_SAMPLING_TIME = 300;
    private static final int MAX_SAMPLES = 30000;
    private final AtomicReference<Controller> RUNNING = new AtomicReference();
    private Boolean debugMode;
    private String lastReason;

    private SelfSamplerAction() {
        this.putValue("Name", ACTION_NAME_START);
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/sampler/selfSampler.png", (boolean)false));
        if (System.getProperty(SelfSamplerAction.class.getName() + ".sniff") != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
    }

    public static SelfSamplerAction getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (SamplesOutputStream.isSupported()) {
            Controller controller = new Controller(THREAD_NAME);
            if (this.RUNNING.compareAndSet(null, controller)) {
                this.putValue("Name", ACTION_NAME_STOP);
                this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/sampler/selfSamplerRunning.png", (boolean)false));
                controller.run();
            } else {
                controller = this.RUNNING.getAndSet(null);
                if (controller != null) {
                    final Controller controller2 = controller;
                    this.setEnabled(false);
                    SwingWorker swingWorker = new SwingWorker(){

                        protected Object doInBackground() throws Exception {
                            controller2.actionPerformed(new ActionEvent(this, 0, "show"));
                            return null;
                        }

                        @Override
                        protected void done() {
                            SelfSamplerAction.this.putValue("Name", ACTION_NAME_START);
                            SelfSamplerAction.this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/sampler/selfSampler.png", (boolean)false));
                            SelfSamplerAction.this.setEnabled(true);
                        }
                    };
                    swingWorker.execute();
                }
            }
        } else {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NOT_SUPPORTED, 1);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 65406) {
            this.actionPerformed(new ActionEvent(this, aWTEvent.getID(), "shortcut"));
            keyEvent.consume();
        }
    }

    @Override
    public Object getValue(String string) {
        Object object = super.getValue(string);
        if (object == null && string.startsWith("logger-") && SamplesOutputStream.isSupported() && this.isRunMode()) {
            return new Controller(string);
        }
        return object;
    }

    private boolean isProfileMe(Controller controller) {
        return controller == this.RUNNING.get();
    }

    private synchronized boolean isDebugged() {
        if (this.debugMode == null) {
            this.debugMode = Boolean.FALSE;
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> list = runtimeMXBean.getInputArguments();
            if (list.contains(DEBUG_ARG)) {
                this.debugMode = Boolean.TRUE;
            }
        }
        return this.debugMode;
    }

    private boolean isRunMode() {
        boolean bl = true;
        String string = null;
        if (this.isDebugged()) {
            string = "running in debug mode";
            bl = false;
        }
        if (bl) {
            try {
                Class.forName("org.netbeans.lib.profiler.server.ProfilerServer", false, ClassLoader.getSystemClassLoader());
                string = "running under profiler";
                bl = false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!bl && string != this.lastReason) {
            LOGGER.log(Level.INFO, "Slowness detector disabled - " + string);
        }
        this.lastReason = string;
        return bl;
    }

    private static final class Controller
    implements Runnable,
    ActionListener {
        private static Class defaultDataObject;
        private final String name;
        private Timer timer;
        private ByteArrayOutputStream out;
        private SamplesOutputStream samplesStream;
        private long startTime;
        private long samples;
        private long laststamp;
        private double max;
        private double min = 9.223372036854776E18;
        private double sum;
        private double devSquaresSum;
        private volatile boolean stopped;
        private volatile boolean running;

        Controller(String string) {
            this.name = string;
        }

        private void updateStats(long l) {
            if (this.laststamp != 0L) {
                double d = (double)(l - this.laststamp) / 1000000.0;
                ++this.samples;
                this.sum += d;
                this.devSquaresSum += (d - 10.0) * (d - 10.0);
                if (d > this.max) {
                    this.max = d;
                } else if (d < this.min) {
                    this.min = d;
                }
            }
            this.laststamp = l;
        }

        @Override
        public synchronized void run() {
            assert (!this.running);
            this.running = true;
            final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            this.out = new ByteArrayOutputStream(65536);
            try {
                this.samplesStream = new SamplesOutputStream(this.out);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
            this.startTime = System.currentTimeMillis();
            this.timer = new Timer(this.name);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Controller controller = Controller.this;
                    synchronized (controller) {
                        if (Controller.this.stopped) {
                            return;
                        }
                        if (Controller.this.samples >= 30000L) {
                            Controller.this.cancelTimer();
                            return;
                        }
                        try {
                            ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(false, false);
                            long l = System.nanoTime();
                            Controller.this.samplesStream.writeSample(threadInfoArray, l, Thread.currentThread().getId());
                            Controller.this.updateStats(l);
                        }
                        catch (Throwable throwable) {
                            Exceptions.printStackTrace((Throwable)throwable);
                        }
                    }
                }
            }, 10L, 10L);
        }

        private void cancelTimer() {
            this.timer.cancel();
            if (SelfSamplerAction.getInstance().isProfileMe(this)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelfSamplerAction.getInstance().actionPerformed(null);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void actionPerformed(ActionEvent actionEvent) {
            try {
                Object[] objectArray;
                assert (this.running);
                assert (!this.stopped);
                this.stopped = true;
                this.timer.cancel();
                if ("cancel".equals(actionEvent.getActionCommand()) || this.samples < 1L) {
                    return;
                }
                double d = this.sum / (double)this.samples;
                double d2 = Math.sqrt(this.devSquaresSum / (double)this.samples);
                boolean bl = "write".equals(actionEvent.getActionCommand());
                if (bl) {
                    objectArray = new Object[]{this.startTime, "Samples", this.samples, "Average", d, "Minimum", this.min, "Maximum", this.max, "Std. deviation", d2};
                    Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Snapshot statistics", objectArray);
                    if (d > 30.0 || d2 > 40.0) {
                        return;
                    }
                }
                this.samplesStream.close();
                this.samplesStream = null;
                if (bl) {
                    objectArray = (DataOutputStream)actionEvent.getSource();
                    objectArray.write(this.out.toByteArray());
                    objectArray.close();
                    return;
                }
                objectArray = File.createTempFile("selfsampler", ".npss");
                objectArray = FileUtil.normalizeFile((File)objectArray);
                this.writeToFile((File)objectArray);
                FileObject fileObject = FileUtil.toFileObject((File)objectArray);
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (defaultDataObject.isAssignableFrom(dataObject.getClass())) {
                    String string = MessageFormat.format(SAVE_MSG, objectArray.getAbsolutePath());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
                } else {
                    ((OpenCookie)dataObject.getCookie(OpenCookie.class)).open();
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            finally {
                this.out = null;
                this.samplesStream = null;
            }
        }

        private void writeToFile(File file) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(this.out.toByteArray());
                this.out = null;
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        static {
            try {
                defaultDataObject = Class.forName("org.openide.loaders.DefaultDataObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
    }

    private static final class Singleton {
        static final SelfSamplerAction INSTANCE = new SelfSamplerAction();

        private Singleton() {
        }
    }
}

