/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.OperationValidator;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;

public final class OperationContainerImpl<Support> {
    private OperationContainer<Support> container;
    private boolean upToDate = false;
    private static final Logger LOGGER = Logger.getLogger(OperationContainerImpl.class.getName());
    private List<OperationContainer.OperationInfo<Support>> operations = new ArrayList<OperationContainer.OperationInfo<Support>>();
    private Collection<OperationContainer.OperationInfo<Support>> affectedEagers = new HashSet<OperationContainer.OperationInfo<Support>>();
    private OperationType type;

    private OperationContainerImpl() {
    }

    public static OperationContainerImpl<InstallSupport> createForInstall() {
        return new OperationContainerImpl<InstallSupport>(OperationType.INSTALL);
    }

    public static OperationContainerImpl<InstallSupport> createForInternalUpdate() {
        return new OperationContainerImpl<InstallSupport>(OperationType.INTERNAL_UPDATE);
    }

    public static OperationContainerImpl<InstallSupport> createForUpdate() {
        return new OperationContainerImpl<InstallSupport>(OperationType.UPDATE);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectInstall() {
        return new OperationContainerImpl<OperationSupport>(OperationType.INSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectUpdate() {
        return new OperationContainerImpl<OperationSupport>(OperationType.UPDATE);
    }

    public static OperationContainerImpl<OperationSupport> createForUninstall() {
        return new OperationContainerImpl<OperationSupport>(OperationType.UNINSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectUninstall() {
        return new OperationContainerImpl<OperationSupport>(OperationType.DIRECT_UNINSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForEnable() {
        return new OperationContainerImpl<OperationSupport>(OperationType.ENABLE);
    }

    public static OperationContainerImpl<OperationSupport> createForDisable() {
        return new OperationContainerImpl<OperationSupport>(OperationType.DISABLE);
    }

    public static OperationContainerImpl<OperationSupport> createForDirectDisable() {
        return new OperationContainerImpl<OperationSupport>(OperationType.DIRECT_DISABLE);
    }

    public static OperationContainerImpl<OperationSupport> createForInstallNativeComponent() {
        return new OperationContainerImpl<OperationSupport>(OperationType.CUSTOM_INSTALL);
    }

    public static OperationContainerImpl<OperationSupport> createForUninstallNativeComponent() {
        return new OperationContainerImpl<OperationSupport>(OperationType.CUSTOM_UNINSTALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationContainer.OperationInfo<Support> add(UpdateUnit updateUnit, UpdateElement updateElement) throws IllegalArgumentException {
        OperationContainer.OperationInfo operationInfo = null;
        boolean bl = this.isValid(updateUnit, updateElement);
        if (!bl) {
            throw new IllegalArgumentException("Invalid " + updateElement.getCodeName() + " for operation " + (Object)((Object)this.type));
        }
        if (UpdateUnitFactory.getDefault().isScheduledForRestart(updateElement)) {
            LOGGER.log(Level.INFO, updateElement + " is scheduled for restart IDE.");
            throw new IllegalArgumentException(updateElement + " is scheduled for restart IDE.");
        }
        if (bl) {
            switch (this.type) {
                case UNINSTALL: 
                case DIRECT_UNINSTALL: 
                case CUSTOM_UNINSTALL: 
                case ENABLE: 
                case DISABLE: 
                case DIRECT_DISABLE: {
                    if (updateUnit.getInstalled() == updateElement) break;
                    throw new IllegalArgumentException(updateUnit.getInstalled() + " and " + updateElement + " must be same for operation " + (Object)((Object)this.type));
                }
                case INSTALL: 
                case UPDATE: 
                case CUSTOM_INSTALL: {
                    if (updateUnit.getInstalled() != updateElement) break;
                    throw new IllegalArgumentException(updateUnit.getInstalled() + " and " + updateElement + " cannot be same for operation " + (Object)((Object)this.type));
                }
                case INTERNAL_UPDATE: {
                    break;
                }
                default: {
                    assert (false) : "Unknown type of operation " + (Object)((Object)this.type);
                    break;
                }
            }
        }
        OperationContainerImpl operationContainerImpl = this;
        synchronized (operationContainerImpl) {
            if (!this.contains(updateUnit, updateElement)) {
                operationInfo = Trampoline.API.createOperationInfo(new OperationInfoImpl(updateUnit, updateElement));
                this.changeState(this.operations.add(operationInfo));
            }
        }
        return operationInfo;
    }

    public boolean remove(UpdateElement updateElement) {
        OperationContainer.OperationInfo<Support> operationInfo = this.find(updateElement);
        if (operationInfo != null) {
            this.remove(operationInfo);
        }
        return operationInfo != null;
    }

    public boolean contains(UpdateElement updateElement) {
        return this.find(updateElement) != null;
    }

    public void setOperationContainer(OperationContainer<Support> operationContainer) {
        this.container = operationContainer;
    }

    private OperationContainer.OperationInfo<Support> find(UpdateElement updateElement) {
        OperationContainer.OperationInfo<Support> operationInfo = null;
        for (OperationContainer.OperationInfo<Support> operationInfo2 : this.listAll()) {
            if (!operationInfo2.getUpdateElement().equals(updateElement)) continue;
            operationInfo = operationInfo2;
            break;
        }
        return operationInfo;
    }

    private boolean contains(UpdateUnit updateUnit, UpdateElement updateElement) {
        List<OperationContainer.OperationInfo<Support>> list = this.operations;
        for (OperationContainer.OperationInfo<Support> operationInfo : list) {
            if (!operationInfo.getUpdateElement().equals(updateElement) && !operationInfo.getUpdateUnit().equals(updateUnit)) continue;
            return true;
        }
        return false;
    }

    private List<OperationContainer.OperationInfo<Support>> listAll() {
        return new ArrayList<OperationContainer.OperationInfo<Support>>(this.operations);
    }

    public synchronized List<OperationContainer.OperationInfo<Support>> listAllWithPossibleEager() {
        if (this.upToDate) {
            return this.listAll();
        }
        this.clearCache();
        boolean bl = false;
        for (OperationContainer.OperationInfo<Support> operationInfo : this.operations) {
            if (Utilities.isFirstClassModule(operationInfo.getUpdateUnit())) continue;
            bl = true;
            break;
        }
        if ((this.type == OperationType.INSTALL || this.type == OperationType.UPDATE || this.type == OperationType.INTERNAL_UPDATE) && bl) {
            UpdateElementImpl updateElementImpl;
            OperationContainer.OperationInfo<Support> operationInfo;
            Iterator<OperationContainer.OperationInfo<Support>> iterator = new HashSet(this.operations.size());
            operationInfo = new HashSet(this.operations.size());
            for (OperationContainer.OperationInfo<Support> object : this.operations) {
                iterator.add((OperationContainer.OperationInfo<Support>)((Object)object.getUpdateElement()));
                iterator.addAll(object.getRequiredElements());
                updateElementImpl = Trampoline.API.impl(object.getUpdateElement());
                if (!(updateElementImpl instanceof ModuleUpdateElementImpl)) continue;
                operationInfo.add((ModuleInfo)((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
            }
            for (UpdateElement updateElement : UpdateManagerImpl.getInstance().getAvailableEagers()) {
                Object object;
                if (updateElement.getUpdateUnit().isPending() || updateElement.getUpdateUnit().getAvailableUpdates().isEmpty()) continue;
                updateElementImpl = Trampoline.API.impl(updateElement);
                ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
                if (updateElementImpl instanceof ModuleUpdateElementImpl) {
                    object = (ModuleUpdateElementImpl)updateElementImpl;
                    arrayList.add(((ModuleUpdateElementImpl)object).getModuleInfo());
                } else if (updateElementImpl instanceof FeatureUpdateElementImpl) {
                    object = (FeatureUpdateElementImpl)updateElementImpl;
                    arrayList.addAll(((FeatureUpdateElementImpl)object).getModuleInfos());
                } else assert (false) : updateElement + " must instanceof ModuleUpdateElementImpl or FeatureUpdateElementImpl";
                for (ModuleInfo moduleInfo : arrayList) {
                    HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
                    for (Dependency dependency : moduleInfo.getDependencies()) {
                        UpdateElement updateElement2 = Utilities.handleDependency(updateElement, dependency, Collections.singleton(moduleInfo), new HashSet<Dependency>(), this.type == OperationType.UPDATE || this.type == OperationType.INTERNAL_UPDATE);
                        if (updateElement2 == null) continue;
                        hashSet.add(updateElement2);
                    }
                    if ((hashSet.isEmpty() || !iterator.containsAll(hashSet) || iterator.contains(updateElement)) && (!hashSet.isEmpty() || updateElementImpl.getUpdateUnit().getInstalled() == null || this.type != OperationType.UPDATE || this.operations.size() <= 0)) continue;
                    Object object2 = null;
                    try {
                        object2 = this.add(updateElement.getUpdateUnit(), updateElement);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        boolean bl2 = !hashSet.isEmpty() && iterator.containsAll(hashSet) && !iterator.contains(updateElement);
                        boolean bl3 = hashSet.isEmpty() && updateElementImpl.getUpdateUnit().getInstalled() != null && this.type == OperationType.UPDATE && this.operations.size() > 0;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("\nIAE while adding eager element to the " + (Object)((Object)this.type) + " container\n");
                        stringBuilder.append("\nEager: " + updateElement);
                        stringBuilder.append("\nFirst condition : " + bl2);
                        stringBuilder.append("\nSecond condition : " + bl3);
                        stringBuilder.append("\nInstalled: " + updateElementImpl.getUpdateUnit().getInstalled());
                        stringBuilder.append("\nPending: " + updateElementImpl.getUpdateUnit().isPending());
                        stringBuilder.append("\nreqs: " + hashSet + " (total : " + hashSet.size() + ")");
                        stringBuilder.append("\nall: " + iterator + " (total : " + iterator.size() + ")");
                        stringBuilder.append("\noperation: " + this.operations + " (total: " + this.operations.size() + ")\n");
                        stringBuilder.append("\neager available updates: " + updateElement.getUpdateUnit().getAvailableUpdates() + "\n");
                        stringBuilder.append("\nUpdateElements in operations:");
                        for (OperationContainer.OperationInfo<Support> operationInfo2 : this.operations) {
                            stringBuilder.append("\n  " + operationInfo2.getUpdateElement());
                        }
                        stringBuilder.append("\nUpdateElements in all:");
                        Iterator<OperationContainer.OperationInfo<Object>> iterator2 = iterator.iterator();
                        while (iterator2.hasNext()) {
                            UpdateElement updateElement3 = (UpdateElement)((Object)iterator2.next());
                            stringBuilder.append("\n  " + updateElement3);
                        }
                        stringBuilder.append("\n");
                        LOGGER.log(Level.INFO, stringBuilder.toString(), illegalArgumentException);
                        throw illegalArgumentException;
                    }
                    if (object2 == null) continue;
                    this.affectedEagers.add((OperationContainer.OperationInfo<Support>)object2);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "== do listAllWithPossibleEager for " + (Object)((Object)this.type) + " operation ==");
            for (OperationContainer.OperationInfo<Support> operationInfo : this.operations) {
                LOGGER.log(Level.FINE, "--> " + operationInfo.getUpdateElement());
            }
            if (this.affectedEagers != null) {
                LOGGER.log(Level.FINE, "   == includes affected eagers for " + (Object)((Object)this.type) + " operation ==");
                for (OperationContainer.OperationInfo<Support> operationInfo : this.affectedEagers) {
                    LOGGER.log(Level.FINE, "   --> " + operationInfo.getUpdateElement());
                }
                LOGGER.log(Level.FINE, "   == done eagers. ==");
            }
            LOGGER.log(Level.FINE, "== done. ==");
        }
        this.upToDate = true;
        return this.listAll();
    }

    public List<OperationContainer.OperationInfo<Support>> listInvalid() {
        ArrayList<OperationContainer.OperationInfo<Support>> arrayList = new ArrayList<OperationContainer.OperationInfo<Support>>();
        List<OperationContainer.OperationInfo<Support>> list = this.listAll();
        for (OperationContainer.OperationInfo<Support> operationInfo : list) {
            if (this.isValid(operationInfo.getUpdateUnit(), operationInfo.getUpdateElement())) continue;
            arrayList.add(operationInfo);
        }
        return arrayList;
    }

    public boolean isValid(UpdateUnit updateUnit, UpdateElement updateElement) {
        if (updateElement == null) {
            throw new IllegalArgumentException("UpdateElement cannot be null for UpdateUnit " + updateUnit);
        }
        if (updateUnit == null) {
            throw new IllegalArgumentException("UpdateUnit cannot be null for UpdateElement " + updateElement);
        }
        boolean bl = false;
        switch (this.type) {
            case INSTALL: {
                bl = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
                if (bl || this.operations.size() <= 0) break;
                bl = OperationValidator.isValidOperation(OperationType.UPDATE, updateUnit, updateElement);
                break;
            }
            case UPDATE: {
                bl = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
                if (bl || this.operations.size() <= 0) break;
                bl = OperationValidator.isValidOperation(OperationType.INSTALL, updateUnit, updateElement);
                break;
            }
            case INTERNAL_UPDATE: {
                bl = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
                if (!bl && this.operations.size() > 0) {
                    bl = OperationValidator.isValidOperation(OperationType.UPDATE, updateUnit, updateElement);
                }
                if (bl || this.operations.size() <= 0) break;
                bl = OperationValidator.isValidOperation(OperationType.INSTALL, updateUnit, updateElement);
                break;
            }
            default: {
                bl = OperationValidator.isValidOperation(this.type, updateUnit, updateElement);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(OperationContainer.OperationInfo operationInfo) {
        OperationContainerImpl operationContainerImpl = this;
        synchronized (operationContainerImpl) {
            this.changeState(this.operations.remove(operationInfo));
            this.changeState(this.operations.removeAll(this.affectedEagers));
            this.affectedEagers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAll() {
        OperationContainerImpl operationContainerImpl = this;
        synchronized (operationContainerImpl) {
            this.changeState(true);
            this.operations.clear();
            this.affectedEagers.clear();
        }
    }

    private void clearCache() {
        OperationValidator.clearMaps();
    }

    private void changeState(boolean bl) {
        if (bl) {
            this.clearCache();
        }
        this.upToDate = this.upToDate && !bl;
    }

    private OperationContainerImpl(OperationType operationType) {
        this.type = operationType;
    }

    public OperationType getType() {
        return this.type;
    }

    public static enum OperationType {
        INSTALL,
        UNINSTALL,
        INTERNAL_UPDATE,
        DIRECT_UNINSTALL,
        UPDATE,
        REVERT,
        ENABLE,
        DIRECT_DISABLE,
        DISABLE,
        CUSTOM_INSTALL,
        CUSTOM_UNINSTALL;

    }

    public class OperationInfoImpl<Support> {
        private final UpdateElement updateElement;
        private final UpdateUnit uUnit;
        private Set<String> brokenDeps = null;

        private OperationInfoImpl(UpdateUnit updateUnit, UpdateElement updateElement) {
            this.updateElement = updateElement;
            this.uUnit = updateUnit;
        }

        public UpdateElement getUpdateElement() {
            return this.updateElement;
        }

        public UpdateUnit getUpdateUnit() {
            return this.uUnit;
        }

        public List<UpdateElement> getRequiredElements() {
            ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
            for (OperationContainer.OperationInfo operationInfo : OperationContainerImpl.this.listAll()) {
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(operationInfo.getUpdateElement());
                List<ModuleInfo> list = updateElementImpl.getModuleInfos();
                assert (list != null) : "ModuleInfo for UpdateElement " + operationInfo.getUpdateElement() + " found.";
                arrayList.addAll(list);
            }
            this.brokenDeps = new HashSet<String>();
            return OperationValidator.getRequiredElements(OperationContainerImpl.this.type, this.getUpdateElement(), arrayList, this.brokenDeps);
        }

        public Set<String> getBrokenDependencies() {
            if (!OperationContainerImpl.this.upToDate) {
                this.brokenDeps = null;
            }
            if (this.brokenDeps != null) {
                return this.brokenDeps;
            }
            ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
            for (OperationContainer.OperationInfo operationInfo : OperationContainerImpl.this.listAll()) {
                UpdateElementImpl updateElementImpl = Trampoline.API.impl(operationInfo.getUpdateElement());
                List<ModuleInfo> list = updateElementImpl.getModuleInfos();
                assert (list != null) : "ModuleInfo for UpdateElement " + operationInfo.getUpdateElement() + " found.";
                arrayList.addAll(list);
            }
            return OperationValidator.getBrokenDependencies(OperationContainerImpl.this.type, this.getUpdateElement(), arrayList);
        }
    }
}

