/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.LogFilter;
import com.noelios.restlet.application.ApplicationContext;
import com.noelios.restlet.application.ApplicationStatusFilter;
import com.noelios.restlet.application.Decoder;
import com.noelios.restlet.application.TunnelFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Filter;
import org.restlet.Restlet;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.service.LogService;
import org.restlet.util.Helper;

public class ApplicationHelper
extends Helper {
    private Application application;
    private Restlet first;
    private Filter last;
    private Context parentContext;

    public ApplicationHelper(Application application, Context parentContext) {
        this.application = application;
        this.parentContext = parentContext;
        this.first = null;
    }

    public Context createContext(String loggerName) {
        return new ApplicationContext(this.getApplication(), this.getParentContext(), Logger.getLogger(loggerName));
    }

    public void handle(Request request, Response response) {
        request.getAttributes().put("org.restlet.application", this.application);
        response.getAttributes().put("org.restlet.application", this.application);
        if (this.getFirst() != null) {
            this.getFirst().handle(request, response);
        } else {
            response.setStatus(Status.SERVER_ERROR_INTERNAL);
            this.getApplication().getLogger().log(Level.SEVERE, "The application wasn't properly started, it can't handle calls.");
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public Context getParentContext() {
        return this.parentContext;
    }

    public void start() throws Exception {
        if (this.getApplication().getTunnelService().isEnabled()) {
            this.addFilter(this.createTunnelFilter(this.getApplication()));
        }
        if (this.getApplication().getStatusService().isEnabled()) {
            this.addFilter(this.createStatusFilter(this.getApplication()));
        }
        if (this.getApplication().getDecoderService().isEnabled()) {
            this.addFilter(this.createDecoderFilter(this.getApplication()));
        }
        if (this.getFirst() == null) {
            this.setFirst(this.getApplication().getRoot());
        } else {
            this.getLast().setNext(this.getApplication().getRoot());
        }
    }

    private void addFilter(Filter filter) {
        if (this.getLast() != null) {
            this.getLast().setNext(filter);
            this.setLast(filter);
        } else {
            this.setFirst(filter);
            this.setLast(filter);
        }
    }

    protected Filter createLogFilter(Context context, LogService logService) {
        return new LogFilter(context, logService);
    }

    protected Filter createDecoderFilter(Application application) {
        return new Decoder(application.getContext(), true, false);
    }

    protected Filter createStatusFilter(Application application) {
        return new ApplicationStatusFilter(application);
    }

    protected Filter createTunnelFilter(Application application) {
        return new TunnelFilter(application);
    }

    public void stop() throws Exception {
    }

    private Restlet getFirst() {
        return this.first;
    }

    private void setFirst(Restlet first) {
        this.first = first;
    }

    private Filter getLast() {
        return this.last;
    }

    private void setLast(Filter last) {
        this.last = last;
    }
}

