/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.GeometryTransformation;
import org.geotools.filter.function.StaticGeometry;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_buffer
extends FunctionExpressionImpl
implements GeometryTransformation {
    public static FunctionName NAME = new FunctionNameImpl("buffer", FunctionNameImpl.parameter("buffer", Geometry.class), FunctionNameImpl.parameter("geometry", Geometry.class), FunctionNameImpl.parameter("distance", Number.class));

    public FilterFunction_buffer() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        double arg1;
        Geometry arg0;
        try {
            arg0 = (Geometry)this.getExpression(0).evaluate(feature, Geometry.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function buffer argument #0 - expected type Geometry");
        }
        try {
            arg1 = (Double)this.getExpression(1).evaluate(feature, Double.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function buffer argument #1 - expected type double");
        }
        return StaticGeometry.buffer(arg0, arg1);
    }

    @Override
    public ReferencedEnvelope invert(ReferencedEnvelope renderingEnvelope) {
        Double buffer = (Double)this.getExpression(1).evaluate(null, Double.class);
        if (buffer == null || buffer <= 0.0) {
            return null;
        }
        Envelope bufferedEnvelope = JTS.toGeometry((Envelope)renderingEnvelope).buffer(buffer).getEnvelopeInternal();
        return new ReferencedEnvelope(bufferedEnvelope, renderingEnvelope.getCoordinateReferenceSystem());
    }
}

