/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.CollectionFeatureMemberFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.ExpressionVisitor;

public class Collection_MaxFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.function");
    SimpleFeatureCollection previousFeatureCollection = null;
    Object max = null;
    public static FunctionName NAME = new FunctionNameImpl("Collection_Max", FunctionNameImpl.parameter("max", Comparable.class), FunctionNameImpl.parameter("expression", Comparable.class));

    public Collection_MaxFunction() {
        super(NAME);
    }

    @Override
    public int getArgCount() {
        return 1;
    }

    static CalcResult calculateMax(SimpleFeatureCollection collection, Expression expression) throws IllegalFilterException, IOException {
        MaxVisitor maxVisitor = new MaxVisitor(expression);
        collection.accepts(maxVisitor, null);
        return maxVisitor.getResult();
    }

    @Override
    public void setParameters(List args) {
        org.opengis.filter.expression.Expression expr = (org.opengis.filter.expression.Expression)args.get(0);
        expr = (org.opengis.filter.expression.Expression)expr.accept((ExpressionVisitor)new CollectionFeatureMemberFilterVisitor(), null);
        args.set(0, expr);
        super.setParameters(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        SimpleFeatureCollection featureCollection;
        if (feature == null) {
            return new Integer(0);
        }
        Expression expr = (Expression)this.getExpression(0);
        SimpleFeatureCollection simpleFeatureCollection = featureCollection = (SimpleFeatureCollection)feature;
        synchronized (simpleFeatureCollection) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.max = null;
                try {
                    CalcResult result = Collection_MaxFunction.calculateMax(featureCollection, expr);
                    if (result != null) {
                        this.max = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.max;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }
}

