/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.util.Converters;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.PropertyIsBetween;

public class IsBetweenImpl
extends CompareFilterImpl
implements BetweenFilter {
    private org.opengis.filter.expression.Expression expression;
    protected MultiValuedFilter.MatchAction matchAction;

    protected IsBetweenImpl(FilterFactory factory, org.opengis.filter.expression.Expression lower, org.opengis.filter.expression.Expression expression, org.opengis.filter.expression.Expression upper, MultiValuedFilter.MatchAction matchAction) {
        super(factory, lower, upper);
        this.expression = expression;
        this.matchAction = matchAction;
        this.filterType = (short)19;
    }

    protected IsBetweenImpl(FilterFactory factory, org.opengis.filter.expression.Expression lower, org.opengis.filter.expression.Expression expression, org.opengis.filter.expression.Expression upper) {
        this(factory, lower, expression, upper, MultiValuedFilter.MatchAction.ANY);
    }

    public org.opengis.filter.expression.Expression getExpression() {
        return this.expression;
    }

    public void setExpression(org.opengis.filter.expression.Expression expression) {
        this.expression = expression;
    }

    @Override
    public MultiValuedFilter.MatchAction getMatchAction() {
        return this.matchAction;
    }

    public boolean evaluate(Object feature) {
        Object object0 = this.eval(this.expression, feature);
        Object object1 = this.eval(this.expression1, feature);
        Object object2 = this.eval(this.expression2, feature);
        if (!(object0 instanceof Collection || object1 instanceof Collection || object2 instanceof Collection)) {
            return this.evaluateInternal(object0, object1, object2);
        }
        List<Object> oValues = object0 instanceof Collection ? (List<Object>)object0 : Collections.singletonList(object0);
        List<Object> leftValues = object1 instanceof Collection ? (List<Object>)object1 : Collections.singletonList(object1);
        List<Object> rightValues = object2 instanceof Collection ? (List<Object>)object2 : Collections.singletonList(object2);
        int count = 0;
        for (Object e : leftValues) {
            for (Object e2 : rightValues) {
                for (Object e3 : oValues) {
                    boolean temp = this.evaluateInternal(e3, e, e2);
                    if (temp) {
                        ++count;
                    }
                    switch (this.matchAction) {
                        case ONE: {
                            if (count <= 1) break;
                            return false;
                        }
                        case ALL: {
                            if (temp) break;
                            return false;
                        }
                        case ANY: {
                            if (!temp) break;
                            return true;
                        }
                    }
                }
            }
        }
        switch (this.matchAction) {
            case ONE: {
                return count == 1;
            }
            case ALL: {
                return true;
            }
            case ANY: {
                return false;
            }
        }
        return false;
    }

    public boolean evaluateInternal(Object value, Object lower, Object upper) {
        Object o = value;
        Object l = Converters.convert(lower, o.getClass());
        Object u = Converters.convert(upper, o.getClass());
        if (l == null || u == null) {
            l = lower;
            o = Converters.convert(value, l.getClass());
            u = Converters.convert(upper, l.getClass());
            if (o == null || u == null) {
                u = upper;
                o = Converters.convert(value, u.getClass());
                l = Converters.convert(lower, u.getClass());
                if (o == null || l == null) {
                    return false;
                }
            }
        }
        Comparable lc = this.comparable(l);
        Comparable uc = this.comparable(u);
        return lc.compareTo(o) <= 0 && uc.compareTo(o) >= 0;
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsBetween)this, extraData);
    }

    public org.opengis.filter.expression.Expression getLowerBoundary() {
        return this.getExpression1();
    }

    public void setLowerBoundary(org.opengis.filter.expression.Expression lowerBoundary) {
        this.setExpression1(lowerBoundary);
    }

    public org.opengis.filter.expression.Expression getUpperBoundary() {
        return this.getExpression2();
    }

    public void setUpperBoundary(org.opengis.filter.expression.Expression upperBoundary) {
        this.setExpression2(upperBoundary);
    }

    @Override
    public final Expression getMiddleValue() {
        return (Expression)this.getExpression();
    }

    @Override
    public void addMiddleValue(Expression middleValue) {
        this.setExpression(middleValue);
    }

    @Override
    public String toString() {
        return "[ " + this.expression + " BETWEEN " + this.expression1 + " AND " + this.expression2 + " ]";
    }
}

