/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

public abstract class AbstractLazyAttributeTypeImpl
implements AttributeType {
    private final Name name;
    private final Class<?> binding;
    private final boolean identified;
    private final boolean isAbstract;
    private final List<Filter> restrictions;
    private final InternationalString description;
    private final Map<Object, Object> userData;
    private AttributeType superType;

    public AbstractLazyAttributeTypeImpl(Name name, Class<?> binding, boolean identified, boolean isAbstract, List<Filter> restrictions, InternationalString description) {
        if (name == null) {
            throw new NullPointerException("Type has no name");
        }
        if (binding == null) {
            throw new NullPointerException("Type has no binding");
        }
        this.name = name;
        this.binding = binding;
        this.identified = identified;
        this.isAbstract = isAbstract;
        this.restrictions = restrictions == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Filter>(restrictions));
        this.description = description;
        this.userData = new HashMap<Object, Object>();
    }

    public abstract AttributeType buildSuper();

    public boolean isIdentified() {
        return this.identified;
    }

    public AttributeType getSuper() {
        if (this.superType == null) {
            this.superType = this.buildSuper();
        }
        return this.superType;
    }

    public Name getName() {
        return this.name;
    }

    public Class<?> getBinding() {
        return this.binding;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List<Filter> getRestrictions() {
        return this.restrictions;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public Map<Object, Object> getUserData() {
        return this.userData;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AttributeType)) {
            return false;
        }
        return this.name.equals(((AttributeType)other).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "LazyAttributeType: " + this.getName();
    }
}

