/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

class SimpleFeatureCollectionBridge
implements SimpleFeatureCollection {
    private FeatureCollection<SimpleFeatureType, SimpleFeature> collection;

    public SimpleFeatureCollectionBridge(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        if (featureCollection == null) {
            throw new NullPointerException("FeatureCollection required");
        }
        if (featureCollection instanceof SimpleFeatureCollection) {
            throw new IllegalArgumentException("Already a SimpleFeatureCollection");
        }
        if (featureCollection == null) {
            throw new NullPointerException("FeatureCollection required");
        }
        this.collection = featureCollection;
    }

    @Override
    public SimpleFeatureIterator features() {
        final FeatureIterator<SimpleFeature> features = this.collection.features();
        return new SimpleFeatureIterator(){

            @Override
            public SimpleFeature next() throws NoSuchElementException {
                return (SimpleFeature)features.next();
            }

            @Override
            public boolean hasNext() {
                return features.hasNext();
            }

            @Override
            public void close() {
                features.close();
            }
        };
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        return new SimpleFeatureCollectionBridge(this.collection.sort(order));
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        return new SimpleFeatureCollectionBridge(this.collection.subCollection(filter));
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.collection.accepts(visitor, progress);
    }

    @Override
    public boolean add(SimpleFeature feature) {
        return this.collection.add(feature);
    }

    @Override
    public boolean addAll(Collection<? extends SimpleFeature> toAdd) {
        return this.collection.addAll(toAdd);
    }

    @Override
    public boolean addAll(FeatureCollection<? extends SimpleFeatureType, ? extends SimpleFeature> resource) {
        return this.collection.addAll(resource);
    }

    @Override
    public void addListener(CollectionListener listener) throws NullPointerException {
        this.collection.addListener(listener);
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public void close(FeatureIterator<SimpleFeature> close) {
        this.collection.close(close);
    }

    @Override
    public void close(Iterator<SimpleFeature> close) {
        this.collection.close(close);
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> o) {
        return this.collection.containsAll(o);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.collection.getBounds();
    }

    @Override
    public String getID() {
        return this.collection.getID();
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.collection.getSchema();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        return this.collection.iterator();
    }

    @Override
    public void purge() {
        this.collection.purge();
    }

    @Override
    public boolean remove(Object o) {
        return this.collection.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.collection.removeAll(c);
    }

    @Override
    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.collection.removeListener(listener);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.collection.retainAll(c);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <O> O[] toArray(O[] a) {
        return this.collection.toArray(a);
    }
}

