/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateValidator
extends AbstractValidator<Date> {
    private static final long serialVersionUID = 1L;

    public static DateValidator range(Date minimum, Date maximum) {
        return new RangeValidator(minimum, maximum, null);
    }

    public static DateValidator range(Date minimum, Date maximum, String format) {
        return new RangeValidator(minimum, maximum, format);
    }

    public static DateValidator minimum(Date minimum) {
        return new MinimumValidator(minimum, null);
    }

    public static DateValidator minimum(Date minimum, String format) {
        return new MinimumValidator(minimum, format);
    }

    public static DateValidator maximum(Date maximum) {
        return new MaximumValidator(maximum, null);
    }

    public static DateValidator maximum(Date maximum, String format) {
        return new MaximumValidator(maximum, format);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaximumValidator
    extends DateValidator {
        private static final long serialVersionUID = 1L;
        private final Date maximum;
        private final String format;

        private MaximumValidator(Date maximum, String format) {
            this.maximum = maximum;
            this.format = format;
        }

        @Override
        protected Map<String, Object> variablesMap(IValidatable<Date> validatable) {
            Map<String, Object> map = super.variablesMap(validatable);
            if (this.format == null) {
                map.put("maximum", this.maximum);
                map.put("inputdate", validatable.getValue());
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(this.format);
                map.put("maximum", sdf.format(this.maximum));
                map.put("inputdate", sdf.format(validatable.getValue()));
            }
            return map;
        }

        @Override
        protected String resourceKey() {
            return "DateValidator.maximum";
        }

        @Override
        protected void onValidate(IValidatable<Date> validatable) {
            Date value = validatable.getValue();
            if (value.after(this.maximum)) {
                this.error(validatable);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MinimumValidator
    extends DateValidator {
        private static final long serialVersionUID = 1L;
        private final Date minimum;
        private final String format;

        private MinimumValidator(Date minimum, String format) {
            this.minimum = minimum;
            this.format = format;
        }

        @Override
        protected Map<String, Object> variablesMap(IValidatable<Date> validatable) {
            Map<String, Object> map = super.variablesMap(validatable);
            if (this.format == null) {
                map.put("minimum", this.minimum);
                map.put("inputdate", validatable.getValue());
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(this.format);
                map.put("minimum", sdf.format(this.minimum));
                map.put("inputdate", sdf.format(validatable.getValue()));
            }
            return map;
        }

        @Override
        protected String resourceKey() {
            return "DateValidator.minimum";
        }

        @Override
        protected void onValidate(IValidatable<Date> validatable) {
            Date value = validatable.getValue();
            if (value.before(this.minimum)) {
                this.error(validatable);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RangeValidator
    extends DateValidator {
        private static final long serialVersionUID = 1L;
        private final Date minimum;
        private final Date maximum;
        private final String format;

        private RangeValidator(Date minimum, Date maximum, String format) {
            this.minimum = minimum;
            this.maximum = maximum;
            this.format = format;
        }

        @Override
        protected Map<String, Object> variablesMap(IValidatable<Date> validatable) {
            Map<String, Object> map = super.variablesMap(validatable);
            if (this.format == null) {
                map.put("minimum", this.minimum);
                map.put("maximum", this.maximum);
                map.put("inputdate", validatable.getValue());
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(this.format);
                map.put("minimum", sdf.format(this.minimum));
                map.put("maximum", sdf.format(this.maximum));
                map.put("inputdate", sdf.format(validatable.getValue()));
            }
            return map;
        }

        @Override
        protected String resourceKey() {
            return "DateValidator.range";
        }

        @Override
        protected void onValidate(IValidatable<Date> validatable) {
            Date value = validatable.getValue();
            if (value.before(this.minimum) || value.after(this.maximum)) {
                this.error(validatable);
            }
        }
    }
}

