/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.string.Strings;

public class Files {
    private static String FORBIDDEN_IN_NAME = new String("\"*/:<>?\\|,");

    public static String basePath(String path, String extension) {
        if (extension != null) {
            return path.substring(0, path.length() - extension.length() - 1);
        }
        return path;
    }

    public static String extension(String path) {
        if (path.indexOf(46) != -1) {
            return Strings.lastPathComponent(path, '.');
        }
        return null;
    }

    public static String filename(String path) {
        return Strings.lastPathComponent(path.replace('/', File.separatorChar), File.separatorChar);
    }

    public static boolean remove(File file) {
        if (!file.delete()) {
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return file.delete();
        }
        return true;
    }

    public static final int writeTo(File file, InputStream input) throws IOException {
        return Files.writeTo(file, input, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int writeTo(File file, InputStream input, int bufSize) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            int n = Streams.copy(input, out, bufSize);
            return n;
        }
        finally {
            out.close();
        }
    }

    public static final String cleanupFilename(String filename) {
        String name = filename;
        for (int i = 0; i < FORBIDDEN_IN_NAME.length(); ++i) {
            name = name.replace(FORBIDDEN_IN_NAME.charAt(i), '_');
        }
        return name;
    }

    private Files() {
    }
}

