/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.component.listener;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.IEventProcessor;
import org.apache.wicket.request.target.component.PageRequestTarget;
import org.apache.wicket.request.target.component.listener.IListenerInterfaceRequestTarget;
import org.apache.wicket.settings.IRequestCycleSettings;

public abstract class AbstractListenerInterfaceRequestTarget
extends PageRequestTarget
implements IListenerInterfaceRequestTarget,
IEventProcessor {
    private final RequestParameters requestParameters;
    private final Component component;
    private final RequestListenerInterface listener;

    public AbstractListenerInterfaceRequestTarget(Page page, Component component, RequestListenerInterface listener) {
        this(page, component, listener, null);
    }

    public AbstractListenerInterfaceRequestTarget(Page page, Component component, RequestListenerInterface listener, RequestParameters requestParameters) {
        super(page);
        if (component == null) {
            throw new IllegalArgumentException("Argument component must be not null");
        }
        this.component = component;
        if (listener == null) {
            throw new IllegalArgumentException("Argument listenerMethod must be not null");
        }
        this.listener = listener;
        this.requestParameters = requestParameters;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (obj != null && obj.getClass().equals(this.getClass())) {
            AbstractListenerInterfaceRequestTarget that = (AbstractListenerInterfaceRequestTarget)obj;
            if (this.component.equals(that.component) && this.listener.equals(that.listener)) {
                if (this.requestParameters != null) {
                    return this.requestParameters.equals(that.requestParameters);
                }
                return that.requestParameters == null;
            }
        }
        return equal;
    }

    public final RequestListenerInterface getRequestListenerInterface() {
        return this.listener;
    }

    public final RequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public final Component getTarget() {
        return this.component;
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        result += this.component.hashCode();
        result += this.listener.hashCode();
        return 17 * (result += this.requestParameters != null ? this.requestParameters.hashCode() : 0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName()).append("@").append(this.hashCode()).append(this.getPage().toString()).append("->").append(this.getTarget().getId()).append("->").append(this.getRequestListenerInterface().getMethod().getDeclaringClass()).append(".").append(this.getRequestListenerInterface().getName());
        if (this.requestParameters != null) {
            buf.append(" (request paramaters: ").append(this.requestParameters.toString()).append(")");
        }
        return buf.toString();
    }

    protected void onProcessEvents(RequestCycle requestCycle) {
        this.getPage().startComponentRender(this.getTarget());
        Application application = requestCycle.getApplication();
        IRequestCycleSettings.RenderStrategy strategy = application.getRequestCycleSettings().getRenderStrategy();
        boolean issueRedirect = strategy == IRequestCycleSettings.REDIRECT_TO_RENDER || strategy == IRequestCycleSettings.REDIRECT_TO_BUFFER;
        requestCycle.setRedirect(issueRedirect);
    }
}

