/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageParameters;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.AbstractRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.PackageName;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageRequestTargetUrlCodingStrategy
extends AbstractRequestTargetUrlCodingStrategy {
    private static final Logger log = LoggerFactory.getLogger(PackageRequestTargetUrlCodingStrategy.class);
    private final PackageName packageName;

    public PackageRequestTargetUrlCodingStrategy(String path, PackageName packageName) {
        super(path);
        this.packageName = packageName;
    }

    public IRequestTarget decode(RequestParameters requestParameters) {
        Class<?> bookmarkablePageClass;
        String parametersFragment;
        String remainder = requestParameters.getPath().substring(this.getMountPath().length());
        int ix = remainder.indexOf(47, 1);
        if (ix == -1) {
            ix = remainder.length();
            parametersFragment = "";
        } else {
            parametersFragment = remainder.substring(ix);
        }
        if (!remainder.startsWith("/")) {
            return null;
        }
        remainder = remainder.substring(1);
        String bookmarkablePageClassName = this.packageName + "." + remainder.substring(0, --ix);
        try {
            bookmarkablePageClass = Session.get().getClassResolver().resolveClass(bookmarkablePageClassName);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            return null;
        }
        PageParameters parameters = new PageParameters(this.decodeParameters(parametersFragment, requestParameters.getParameters()));
        String pageMapName = (String)parameters.remove("wicket:pageMapName");
        pageMapName = WebRequestCodingStrategy.decodePageMapName(pageMapName);
        requestParameters.setPageMapName(pageMapName);
        String interfaceParameter = (String)parameters.remove("wicket:interface");
        if (interfaceParameter != null) {
            WebRequestCodingStrategy.addInterfaceParameters(interfaceParameter, requestParameters);
            return new BookmarkableListenerInterfaceRequestTarget(pageMapName, bookmarkablePageClass, parameters, requestParameters.getComponentPath(), requestParameters.getInterfaceName(), requestParameters.getVersionNumber());
        }
        return new BookmarkablePageRequestTarget(pageMapName, bookmarkablePageClass, parameters);
    }

    public final CharSequence encode(IRequestTarget requestTarget) {
        if (!(requestTarget instanceof IBookmarkablePageRequestTarget)) {
            throw new IllegalArgumentException("this encoder can only be used with instances of " + IBookmarkablePageRequestTarget.class.getName());
        }
        AppendingStringBuffer url = new AppendingStringBuffer(40);
        url.append(this.getMountPath());
        IBookmarkablePageRequestTarget target = (IBookmarkablePageRequestTarget)requestTarget;
        url.append("/").append(Classes.simpleName(target.getPageClass()));
        PageParameters pageParameters = target.getPageParameters();
        if (target.getPageMapName() != null) {
            pageParameters.put("wicket:pageMapName", (Object)WebRequestCodingStrategy.encodePageMapName(target.getPageMapName()));
        }
        this.appendParameters(url, pageParameters);
        return url;
    }

    public boolean matches(IRequestTarget requestTarget) {
        IBookmarkablePageRequestTarget target;
        return requestTarget instanceof IBookmarkablePageRequestTarget && this.packageName.equals(PackageName.forClass((target = (IBookmarkablePageRequestTarget)requestTarget).getPageClass()));
    }

    public String toString() {
        return "PackageEncoder[package=" + this.packageName + "]";
    }
}

