/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.lang.ref.WeakReference;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.AbstractRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkablePageRequestTargetUrlCodingStrategy
extends AbstractRequestTargetUrlCodingStrategy {
    protected final WeakReference<Class<? extends Page>> bookmarkablePageClassRef;
    private final String pageMapName;

    public <C extends Page> BookmarkablePageRequestTargetUrlCodingStrategy(String mountPath, Class<C> bookmarkablePageClass, String pageMapName) {
        super(mountPath);
        if (bookmarkablePageClass == null) {
            throw new IllegalArgumentException("Argument bookmarkablePageClass must be not null");
        }
        this.bookmarkablePageClassRef = new WeakReference<Class<C>>(bookmarkablePageClass);
        this.pageMapName = pageMapName;
    }

    @Override
    public IRequestTarget decode(RequestParameters requestParameters) {
        String parametersFragment = requestParameters.getPath().substring(this.getMountPath().length());
        PageParameters parameters = new PageParameters(this.decodeParameters(parametersFragment, requestParameters.getParameters()));
        String pageMapNameEncoded = (String)parameters.remove("wicket:pageMapName");
        if (requestParameters.getPageMapName() == null) {
            requestParameters.setPageMapName(pageMapNameEncoded);
        }
        String interfaceParameter = (String)parameters.remove("wicket:interface");
        if (requestParameters.getInterfaceName() == null) {
            WebRequestCodingStrategy.addInterfaceParameters(interfaceParameter, requestParameters);
        }
        if (requestParameters.getInterfaceName() != null) {
            return new BookmarkableListenerInterfaceRequestTarget(requestParameters.getPageMapName(), (Class)this.bookmarkablePageClassRef.get(), parameters, requestParameters.getComponentPath(), requestParameters.getInterfaceName(), requestParameters.getVersionNumber());
        }
        return new BookmarkablePageRequestTarget(requestParameters.getPageMapName(), (Class)this.bookmarkablePageClassRef.get(), parameters);
    }

    @Override
    public CharSequence encode(IRequestTarget requestTarget) {
        String pagemap;
        if (!(requestTarget instanceof IBookmarkablePageRequestTarget)) {
            throw new IllegalArgumentException("This encoder can only be used with instances of " + IBookmarkablePageRequestTarget.class.getName());
        }
        AppendingStringBuffer url = new AppendingStringBuffer(40);
        url.append(this.getMountPath());
        IBookmarkablePageRequestTarget target = (IBookmarkablePageRequestTarget)requestTarget;
        PageParameters pageParameters = target.getPageParameters();
        String string = pagemap = this.pageMapName != null ? this.pageMapName : target.getPageMapName();
        if (pagemap != null) {
            if (pageParameters == null) {
                pageParameters = new PageParameters();
            }
            pageParameters.put("wicket:pageMapName", (Object)WebRequestCodingStrategy.encodePageMapName(pagemap));
        }
        this.appendParameters(url, pageParameters);
        return url;
    }

    @Override
    public boolean matches(IRequestTarget requestTarget) {
        if (requestTarget instanceof IBookmarkablePageRequestTarget) {
            IBookmarkablePageRequestTarget target = (IBookmarkablePageRequestTarget)requestTarget;
            if (((Class)this.bookmarkablePageClassRef.get()).equals(target.getPageClass())) {
                if (this.pageMapName == null) {
                    return true;
                }
                return this.pageMapName.equals(target.getPageMapName());
            }
        }
        return false;
    }

    public String toString() {
        return "BookmarkablePageEncoder[page=" + this.bookmarkablePageClassRef.get() + "]";
    }
}

