/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.util.Map;
import org.apache.wicket.IClusterable;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParameters
implements IClusterable {
    private static final int MAX_URL_DEPTH = 75;
    private static final long serialVersionUID = 1L;
    private String componentPath;
    private String pageMapName;
    private int versionNumber;
    private boolean onlyProcessIfPathActive = false;
    private String interfaceName;
    private String behaviorId;
    private String componentId;
    private String bookmarkablePageClass;
    private Map<String, ?> parameters;
    private String resourceKey;
    private String path;
    private int urlDepth = -1;
    private String queryString;
    private boolean stateless = true;

    public String getBehaviorId() {
        return this.behaviorId;
    }

    public String getBookmarkablePageClass() {
        return this.bookmarkablePageClass;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public RequestListenerInterface getInterface() {
        return RequestListenerInterface.forName(this.getInterfaceName());
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getPageMapName() {
        return this.pageMapName;
    }

    public Map<String, ?> getParameters() {
        return this.parameters;
    }

    public String getPath() {
        return this.path;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public boolean isOnlyProcessIfPathActive() {
        return this.onlyProcessIfPathActive;
    }

    public void setBehaviorId(String behaviorId) {
        this.behaviorId = behaviorId;
    }

    public void setBookmarkablePageClass(String bookmarkablePageClass) {
        this.bookmarkablePageClass = bookmarkablePageClass;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public void setComponentPath(String componentPath) {
        this.componentPath = componentPath;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void setOnlyProcessIfPathActive(boolean onlyProcessIfPathActive) {
        this.onlyProcessIfPathActive = onlyProcessIfPathActive;
    }

    public void setPageMapName(String pageMapName) {
        this.pageMapName = WebRequestCodingStrategy.decodePageMapName(pageMapName);
    }

    public void setParameters(Map<String, ?> parameters) {
        this.parameters = parameters;
    }

    public void setPath(String pathInfo) {
        this.path = pathInfo;
    }

    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public int getUrlDepth() {
        return this.urlDepth;
    }

    public void setUrlDepth(int urlDepth) {
        if (urlDepth > 75 || urlDepth < -1) {
            throw new RuntimeException("Url depth has an illegal value: " + urlDepth);
        }
        this.urlDepth = urlDepth;
    }

    public boolean isStateless() {
        return this.stateless;
    }

    public void setStateless(boolean stateless) {
        this.stateless = stateless;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("[RequestParameters ");
        if (this.getComponentPath() != null) {
            b.append(" componentPath=").append(this.getComponentPath());
            b.append(" pageMapName=").append(this.getPageMapName());
            b.append(" versionNumber=").append(this.getVersionNumber());
            b.append(" interfaceName=").append(this.getInterfaceName());
            b.append(" componentId=").append(this.getComponentId());
            b.append(" behaviorId=").append(this.getBehaviorId());
            b.append(" urlDepth=").append(this.getUrlDepth());
        }
        if (this.getBookmarkablePageClass() != null) {
            b.append(" bookmarkablePageClass=").append(this.getBookmarkablePageClass());
        }
        if (this.getParameters() != null) {
            b.append(" parameters={");
            boolean first = true;
            for (Map.Entry<String, ?> entry : this.getParameters().entrySet()) {
                if (!first) {
                    b.append(",");
                }
                first = false;
                Object value = entry.getValue();
                b.append(entry.getKey()).append("=");
                if (value != null && value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    if (values.length > 1) {
                        b.append("{");
                        for (int j = 0; j < values.length; ++j) {
                            b.append(values[j]);
                            if (j >= values.length) continue;
                            b.append(",");
                        }
                        b.append("}");
                        continue;
                    }
                    b.append(values.length == 1 ? values[0] : "");
                    continue;
                }
                b.append(value);
            }
            b.append("}");
        }
        if (this.getResourceKey() != null) {
            b.append(" resourceKey=").append(this.getResourceKey());
        }
        b.append(" onlyProcessIfPathActive=").append(this.isOnlyProcessIfPathActive());
        b.append("]");
        return b.toString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }
}

