/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BorderBodyResolver
implements IComponentResolver {
    private static final Logger log = LoggerFactory.getLogger(BorderBodyResolver.class);
    private static final long serialVersionUID = 1L;

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        WicketTag wtag;
        if (tag instanceof WicketTag && (wtag = (WicketTag)tag).isBodyTag()) {
            for (MarkupContainer parent = container.getParent(); parent != null && !(parent instanceof Border.BorderBodyContainer); parent = parent.getParent()) {
                if (!(parent instanceof Border)) continue;
                Component component = parent.get(tag.getId());
                if (component != null) {
                    component.render(markupStream);
                    log.warn("Please consider to change your java code to something like: " + container.getId() + ".add(getBodyContainer()); for the component hierarchy to " + "better reflect the markup hierarchy. For example, say that " + "you have a border class in which you do: " + "'WebMarkupContainer div = new " + "WebMarkupContainer(\"roundDiv\"); add(div);' you should " + "now do 'add(div); div.add(getBodyContainer());'. " + "Please fix this before Wicket 1.4");
                }
                return true;
            }
        }
        return false;
    }
}

