/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.link;

import org.apache.wicket.Application;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLink
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private String beforeDisabledLink;
    private String afterDisabledLink;

    public AbstractLink(String id, IModel<?> model) {
        super(id, model);
    }

    public AbstractLink(String id) {
        super(id);
    }

    public AbstractLink setAfterDisabledLink(String afterDisabledLink) {
        if (afterDisabledLink == null) {
            throw new IllegalArgumentException("Value cannot be null.  For no text, specify an empty String instead.");
        }
        this.afterDisabledLink = afterDisabledLink;
        return this;
    }

    public String getAfterDisabledLink() {
        return this.afterDisabledLink;
    }

    public AbstractLink setBeforeDisabledLink(String beforeDisabledLink) {
        if (beforeDisabledLink == null) {
            throw new IllegalArgumentException("Value cannot be null.  For no text, specify an empty String instead.");
        }
        this.beforeDisabledLink = beforeDisabledLink;
        return this;
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        if (this.beforeDisabledLink == null) {
            Application app = this.getApplication();
            this.beforeDisabledLink = app.getMarkupSettings().getDefaultBeforeDisabledLink();
            this.afterDisabledLink = app.getMarkupSettings().getDefaultAfterDisabledLink();
        }
    }

    public String getBeforeDisabledLink() {
        return this.beforeDisabledLink;
    }

    protected final boolean isLinkEnabled() {
        return this.isEnabledInHierarchy();
    }

    @Override
    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (!this.isLinkEnabled() && this.getBeforeDisabledLink() != null) {
            this.getResponse().write(this.getBeforeDisabledLink());
        }
        this.renderComponentTagBody(markupStream, openTag);
        if (!this.isLinkEnabled() && this.getAfterDisabledLink() != null) {
            this.getResponse().write(this.getAfterDisabledLink());
        }
    }

    protected void disableLink(ComponentTag tag) {
        if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
            tag.setName("span");
            tag.remove("href");
            tag.remove("onclick");
        } else if ("button".equalsIgnoreCase(tag.getName()) || "input".equalsIgnoreCase(tag.getName())) {
            tag.put("disabled", "disabled");
        }
    }
}

