/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumChoiceRenderer<T extends Enum<T>>
implements IChoiceRenderer<T> {
    private static final long serialVersionUID = 1L;
    private final Component resourceSource;

    public EnumChoiceRenderer() {
        this.resourceSource = null;
    }

    public EnumChoiceRenderer(Component resourceSource) {
        this.resourceSource = resourceSource;
    }

    @Override
    public final Object getDisplayValue(T object) {
        String key = this.resourceKey(object);
        String value = this.resourceSource != null ? this.resourceSource.getString(key) : Application.get().getResourceSettings().getLocalizer().getString(key, null);
        return this.postprocess(value);
    }

    protected String resourceKey(T object) {
        return ((Enum)object).getDeclaringClass().getSimpleName() + "." + ((Enum)object).name();
    }

    protected CharSequence postprocess(String value) {
        return Strings.escapeMarkup(value);
    }

    @Override
    public String getIdValue(T object, int index) {
        return ((Enum)object).name();
    }
}

