/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Iterator;
import org.apache.wicket.IClusterable;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.Session;
import org.apache.wicket.session.pagemap.IPageMapEntry;
import org.apache.wicket.util.collections.ArrayListStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessStackPageMap
extends PageMap
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AccessStackPageMap.class);
    private final ArrayListStack<Access> accessStack = new ArrayListStack(8);

    public AccessStackPageMap(String name) {
        super(name);
    }

    @Override
    public void clear() {
        super.clear();
        this.accessStack.clear();
        this.dirty();
    }

    public final ArrayListStack<Access> getAccessStack() {
        return this.accessStack;
    }

    public final int getVersions() {
        return this.accessStack.size();
    }

    public final IPageMapEntry lastAccessedEntry() {
        return this.getEntry(this.peekAccess().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(IPageMapEntry entry) {
        Session session;
        if (entry == null) {
            log.warn("PageMap.removeEntry called with an null entry");
            return;
        }
        Session session2 = session = this.getSession();
        synchronized (session2) {
            session.removeAttribute(this.attributeForId(entry.getNumericId()));
            Iterator stack = this.accessStack.iterator();
            while (stack.hasNext()) {
                Access access = (Access)stack.next();
                if (access.id != entry.getNumericId()) continue;
                stack.remove();
            }
            this.dirty();
        }
    }

    @Override
    public Page get(int id, int versionNumber) {
        IPageMapEntry entry = (IPageMapEntry)this.getSession().getAttribute(this.attributeForId(id));
        if (entry != null) {
            Page page = entry.getPage();
            page.dirty();
            this.access(entry, versionNumber);
            Page version = page.getVersion(versionNumber);
            if (version != null) {
                if (version != page) {
                    page = version;
                    page.getPageMap().put(page);
                }
            } else {
                if (log.isInfoEnabled()) {
                    log.info("Unable to get version " + versionNumber + " of page " + page);
                }
                return null;
            }
            return page;
        }
        return null;
    }

    @Override
    public void put(Page page) {
        if (!page.isPageStateless()) {
            Session session = this.getSession();
            IPageMapEntry entry = page.getPageMapEntry();
            this.pushAccess(entry);
            String attribute = this.attributeForId(entry.getNumericId());
            if (session.getAttribute(attribute) == null) {
                session.setAttribute(attribute, entry);
            } else {
                session.dirtyPage(page);
            }
            session.getApplication().getSessionSettings().getPageMapEvictionStrategy().evict(this);
        }
    }

    private final void access(IPageMapEntry entry, int version) {
        boolean add = true;
        int id = entry.getNumericId();
        for (int i = this.accessStack.size() - 1; i >= 0; --i) {
            Access access = (Access)this.accessStack.get(i);
            if (access.id != id || access.version != version) continue;
            add = false;
            while (i < this.accessStack.size() - 1) {
                Access topAccess = this.popAccess();
                IPageMapEntry top = this.getEntry(topAccess.getId());
                if (top instanceof Page) {
                    Page topPage = (Page)top;
                    if (topPage.getVersions() > 1) {
                        topPage.getVersion(topAccess.getVersion() - 1);
                        continue;
                    }
                    if (topPage.getNumericId() == access.id || topPage.getCurrentVersionNumber() == access.version) continue;
                    this.remove(topPage);
                    continue;
                }
                if (top == null) continue;
                this.removeEntry(top);
            }
            break;
        }
        if (add) {
            this.pushAccess(entry);
        }
    }

    private final Access peekAccess() {
        return this.accessStack.peek();
    }

    private final Access popAccess() {
        this.dirty();
        return this.accessStack.pop();
    }

    private final void pushAccess(IPageMapEntry entry) {
        Access access = new Access();
        access.id = entry.getNumericId();
        access.version = this.versionOf(entry);
        if (this.accessStack.size() > 0) {
            if (this.peekAccess().equals(access)) {
                return;
            }
            int index = this.accessStack.indexOf(access);
            if (index >= 0) {
                this.accessStack.remove(index);
            }
        }
        this.accessStack.push(access);
        this.dirty();
    }

    @Override
    public boolean containsPage(int id, int versionNumber) {
        for (Access access : this.accessStack) {
            if (access.id != id || access.version != versionNumber) continue;
            return true;
        }
        return false;
    }

    private final int versionOf(IPageMapEntry entry) {
        if (entry instanceof Page) {
            return ((Page)entry).getCurrentVersionNumber();
        }
        return 0;
    }

    public static class Access
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        int id;
        int version;

        public boolean equals(Object obj) {
            if (obj instanceof Access) {
                Access tmp = (Access)obj;
                return tmp.id == this.id && tmp.version == this.version;
            }
            return false;
        }

        public final int getId() {
            return this.id;
        }

        public final int getVersion() {
            return this.version;
        }

        public int hashCode() {
            return this.id + (this.version << 16);
        }

        public String toString() {
            return "[Access id=" + this.id + ", version=" + this.version + "]";
        }
    }
}

