/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.impl.LayerIdentifier;

public class LayerIdentifierFormField
extends FormComponentPanel<LayerIdentifierInfo> {
    private static final long serialVersionUID = 1L;
    private TextField<String> authority;
    private TextField<String> identifier;

    public LayerIdentifierFormField(String id, IModel<List<LayerIdentifierInfo>> identifierModel) {
        super(id);
        Component[] componentArray = new Component[1];
        this.authority = new TextField("authority", (IModel)new PropertyModel(identifierModel, "authority"));
        componentArray[0] = this.authority;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.identifier = new TextField("identifier", (IModel)new PropertyModel(identifierModel, "identifier"));
        componentArray2[0] = this.identifier;
        this.add(componentArray2);
        this.add((IValidator)new IValidator<LayerIdentifierInfo>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<LayerIdentifierInfo> arg) {
                LayerIdentifierInfo value = (LayerIdentifierInfo)arg.getValue();
                if (value == null) {
                    return;
                }
                if (value.getAuthority() == null || value.getIdentifier() == null) {
                    ValidationError error = new ValidationError();
                    error.setMessage(new ResourceModel("LayerIdentifierFormField.validationError").getObject());
                    arg.error((IValidationError)error);
                }
            }
        });
    }

    protected void convertInput() {
        LayerIdentifierInfo info = (LayerIdentifierInfo)this.getModelObject();
        String auth = (String)this.authority.getConvertedInput();
        String id = (String)this.identifier.getConvertedInput();
        if (id == null && auth == null) {
            this.setConvertedInput(null);
            return;
        }
        if (info == null) {
            info = new LayerIdentifier();
            this.setModelObject(info);
        }
        info.setAuthority(auth);
        info.setIdentifier(id);
        this.setConvertedInput(info);
    }

    protected void onBeforeRender() {
        LayerIdentifierInfo info = (LayerIdentifierInfo)this.getModelObject();
        if (info != null) {
            this.authority.setModelObject((Object)info.getAuthority());
            this.identifier.setModelObject((Object)info.getIdentifier());
        }
        super.onBeforeRender();
    }
}

