/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.StylePage;
import org.geotools.util.Version;

public class StyleNewPage
extends AbstractStylePage {
    public StyleNewPage() {
        this.initUI(null);
    }

    @Override
    protected void initUI(StyleInfo style) {
        super.initUI(style);
        if (!this.isAuthenticatedAsAdmin()) {
            DropDownChoice wsChoice = (DropDownChoice)this.get("form:workspace");
            List ws = this.getCatalog().getWorkspaces();
            if (!ws.isEmpty()) {
                wsChoice.setModelObject(ws.get(0));
            }
        }
    }

    @Override
    protected void onStyleFormSubmit() {
        Catalog catalog = this.getCatalog();
        StyleInfo s = (StyleInfo)this.styleForm.getModelObject();
        try {
            if (s.getFilename() == null) {
                s.setFilename(s.getName() + ".sld");
            }
            catalog.getResourcePool().writeStyle(s, (InputStream)new ByteArrayInputStream(this.rawSLD.getBytes()));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        try {
            Version version = Styles.findVersion((Object)new ByteArrayInputStream(this.rawSLD.getBytes()));
            s.setSLDVersion(version);
            this.getCatalog().add(s);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred saving the style", e);
            this.error(e);
            return;
        }
        this.doReturn(StylePage.class);
    }
}

