/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.StylePage;
import org.geotools.util.Version;

public class StyleEditPage
extends AbstractStylePage {
    public static final String NAME = "name";
    public static final String WORKSPACE = "workspace";

    public StyleEditPage(PageParameters parameters) {
        StyleInfo si;
        String name = parameters.getString(NAME);
        String workspace = parameters.getString(WORKSPACE);
        StyleInfo styleInfo = si = workspace != null ? this.getCatalog().getStyleByName(workspace, name) : this.getCatalog().getStyleByName(name);
        if (si == null) {
            this.error((Serializable)((Object)new ParamResourceModel("StyleEditPage.notFound", (Component)this, new Object[]{name}).getString()));
            this.doReturn(StylePage.class);
            return;
        }
        this.initUI(si);
        if (!this.isAuthenticatedAsAdmin()) {
            Form f = (Form)this.get("form");
            if (si.getWorkspace() == null) {
                this.styleForm.setEnabled(false);
                this.nameTextField.setEnabled(false);
                this.uploadForm.setEnabled(false);
                this.editor.add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"disabled")), " ")});
                this.get("validate").add(new IBehavior[]{new AttributeAppender("style", (IModel)new Model((Serializable)((Object)"display:none;")), " ")});
                this.add(new IBehavior[]{new AbstractBehavior(){

                    public void renderHead(IHeaderResponse response) {
                        response.renderOnLoadJavascript("document.getElementById('mainFormSubmit').style.display = 'none';");
                        response.renderOnLoadJavascript("document.getElementById('uploadFormSubmit').style.display = 'none';");
                    }
                }});
                this.info(new StringResourceModel("globalStyleReadOnly", (Component)this, null).getString());
            }
            f.get(WORKSPACE).setEnabled(false);
        }
    }

    public StyleEditPage(StyleInfo style) {
        super(style);
        this.uploadForm.setVisible(false);
    }

    @Override
    protected void onStyleFormSubmit() {
        try {
            StyleInfo style = (StyleInfo)this.styleForm.getModelObject();
            Version version = Styles.findVersion((Object)new ByteArrayInputStream(this.rawSLD.getBytes()));
            style.setSLDVersion(version);
            try {
                this.getCatalog().getResourcePool().writeStyle(style, (InputStream)new ByteArrayInputStream(this.rawSLD.getBytes()));
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            this.getCatalog().save(style);
            this.doReturn(StylePage.class);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error occurred saving the style", e);
            this.styleForm.error((Serializable)e);
        }
    }
}

