/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.lang.Bytes;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.style.StyleDetachableModel;
import org.geoserver.web.data.workspace.WorkspaceChoiceRenderer;
import org.geoserver.web.data.workspace.WorkspacesModel;
import org.geoserver.web.wicket.CodeMirrorEditor;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wms.web.data.StylePage;
import org.geoserver.wms.web.publish.StyleChoiceRenderer;
import org.geoserver.wms.web.publish.StylesModel;
import org.xml.sax.SAXParseException;

public abstract class AbstractStylePage
extends GeoServerSecuredPage {
    protected TextField nameTextField;
    protected FileUploadField fileUploadField;
    protected DropDownChoice styles;
    protected AjaxSubmitLink copyLink;
    protected Form uploadForm;
    protected Form styleForm;
    protected CodeMirrorEditor editor;
    String rawSLD;

    public AbstractStylePage() {
    }

    public AbstractStylePage(StyleInfo style) {
        this.initUI(style);
    }

    protected void initUI(StyleInfo style) {
        CompoundPropertyModel styleModel = new CompoundPropertyModel(style != null ? new StyleDetachableModel(style) : this.getCatalog().getFactory().createStyle());
        this.styleForm = new Form("form", (IModel)styleModel){

            protected void onSubmit() {
                super.onSubmit();
                AbstractStylePage.this.onStyleFormSubmit();
            }
        };
        this.styleForm.setMarkupId("mainForm");
        this.add(new Component[]{this.styleForm});
        Component[] componentArray = new Component[1];
        this.nameTextField = new TextField("name");
        componentArray[0] = this.nameTextField;
        this.styleForm.add(componentArray);
        this.nameTextField.setRequired(true);
        DropDownChoice wsChoice = new DropDownChoice("workspace", (IModel)new WorkspacesModel(), (IChoiceRenderer)new WorkspaceChoiceRenderer());
        wsChoice.setNullValid(true);
        if (!this.isAuthenticatedAsAdmin()) {
            wsChoice.setNullValid(false);
            wsChoice.setRequired(true);
        }
        this.styleForm.add(new Component[]{wsChoice});
        Component[] componentArray2 = new Component[1];
        this.editor = new CodeMirrorEditor("SLD", (IModel)new PropertyModel((Object)this, "rawSLD"));
        componentArray2[0] = this.editor;
        this.styleForm.add(componentArray2);
        this.editor.setTextAreaMarkupId("editor");
        this.editor.setOutputMarkupId(true);
        this.editor.setRequired(true);
        this.styleForm.add(new Component[]{this.editor});
        if (style != null) {
            try {
                this.setRawSLD(this.readFile(style));
            }
            catch (IOException e) {
                Session.get().error(new ParamResourceModel("sldNotFound", (Component)this, new Object[]{style.getFilename()}).getString());
            }
        }
        this.styles = new DropDownChoice("existingStyles", (IModel)new Model(), (IModel)new StylesModel(), (IChoiceRenderer)new StyleChoiceRenderer());
        this.styles.setOutputMarkupId(true);
        this.styles.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractStylePage.this.styles.validate();
                AbstractStylePage.this.copyLink.setEnabled(AbstractStylePage.this.styles.getConvertedInput() != null);
                target.addComponent((Component)AbstractStylePage.this.copyLink);
            }
        }});
        this.styleForm.add(new Component[]{this.styles});
        this.copyLink = this.copyLink();
        this.copyLink.setEnabled(false);
        this.styleForm.add(new Component[]{this.copyLink});
        this.uploadForm = this.uploadForm(this.styleForm);
        this.uploadForm.setMultiPart(true);
        this.uploadForm.setMaxSize(Bytes.megabytes((long)1L));
        this.uploadForm.setMarkupId("uploadForm");
        this.add(new Component[]{this.uploadForm});
        Component[] componentArray3 = new Component[1];
        this.fileUploadField = new FileUploadField("filename");
        componentArray3[0] = this.fileUploadField;
        this.uploadForm.add(componentArray3);
        this.add(new Component[]{this.validateLink()});
        Link cancelLink = new Link("cancel"){

            public void onClick() {
                AbstractStylePage.this.doReturn(StylePage.class);
            }
        };
        this.add(new Component[]{cancelLink});
    }

    Form uploadForm(final Form form) {
        return new Form("uploadForm"){

            protected void onSubmit() {
                FileUpload upload = AbstractStylePage.this.fileUploadField.getFileUpload();
                if (upload == null) {
                    this.warn("No file selected.");
                    return;
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)upload.getInputStream(), (OutputStream)bout);
                    AbstractStylePage.this.setRawSLD(new InputStreamReader((InputStream)new ByteArrayInputStream(bout.toByteArray()), "UTF-8"));
                    AbstractStylePage.this.editor.setModelObject((Object)AbstractStylePage.this.rawSLD);
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                StyleInfo s = (StyleInfo)form.getModelObject();
                if (s.getName() == null || "".equals(s.getName().trim())) {
                    AbstractStylePage.this.nameTextField.setModelValue(ResponseUtils.stripExtension((String)upload.getClientFileName()));
                    AbstractStylePage.this.nameTextField.modelChanged();
                }
            }
        };
    }

    Component validateLink() {
        return new GeoServerAjaxFormLink("validate", this.styleForm){

            protected void onClick(AjaxRequestTarget target, Form form) {
                AbstractStylePage.this.editor.processInput();
                List<Exception> errors = AbstractStylePage.this.validateSLD();
                if (errors.isEmpty()) {
                    form.info("No validation errors.");
                } else {
                    for (Exception e : errors) {
                        form.error((Serializable)((Object)AbstractStylePage.sldErrorWithLineNo(e)));
                    }
                }
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AbstractStylePage.this.editor.getSaveDecorator();
            }
        };
    }

    private static String sldErrorWithLineNo(Exception e) {
        if (e instanceof SAXParseException) {
            SAXParseException se = (SAXParseException)e;
            return "line " + se.getLineNumber() + ": " + e.getLocalizedMessage();
        }
        return e.getLocalizedMessage();
    }

    List<Exception> validateSLD() {
        try {
            String sld = this.editor.getInput();
            ByteArrayInputStream input = new ByteArrayInputStream(sld.getBytes());
            List validationErrors = Styles.validate((Object)input);
            return validationErrors;
        }
        catch (Exception e) {
            return Arrays.asList(e);
        }
    }

    AjaxSubmitLink copyLink() {
        return new AjaxSubmitLink("copy"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                AbstractStylePage.this.styles.processInput();
                StyleInfo style = (StyleInfo)AbstractStylePage.this.styles.getConvertedInput();
                if (style != null) {
                    try {
                        AbstractStylePage.this.editor.reset();
                        AbstractStylePage.this.setRawSLD(AbstractStylePage.this.readFile(style));
                    }
                    catch (Exception e) {
                        this.error((Serializable)((Object)("Errors occurred loading the '" + style.getName() + "' style")));
                    }
                    target.addComponent((Component)AbstractStylePage.this.styleForm);
                }
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                    public CharSequence preDecorateScript(CharSequence script) {
                        return "if(event.view.document.gsEditors." + AbstractStylePage.this.editor.getTextAreaMarkupId() + ".getCode() != '' &&" + "!confirm('" + new ParamResourceModel("confirmOverwrite", (Component)AbstractStylePage.this, new Object[0]).getString() + "')) return false;" + script;
                    }
                };
            }

            public boolean getDefaultFormProcessing() {
                return false;
            }
        };
    }

    Reader readFile(StyleInfo style) throws IOException {
        ResourcePool pool = this.getCatalog().getResourcePool();
        return pool.readStyle(style);
    }

    public void setRawSLD(Reader in) throws IOException {
        BufferedReader bin = null;
        bin = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = bin.readLine()) != null) {
            builder.append(line).append("\n");
        }
        this.rawSLD = builder.toString();
        this.editor.setModelObject((Object)this.rawSLD);
        in.close();
    }

    protected abstract void onStyleFormSubmit();

    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

