/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.AbstractValidator;
import org.apache.wicket.validation.validator.MinimumValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.FileExistsValidator;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.web.publish.LayerAuthoritiesAndIdentifiersPanel;
import org.geotools.referencing.CRS;

public class WMSAdminPage
extends BaseServiceAdminPage<WMSInfo> {
    static final List<String> SVG_RENDERERS = Arrays.asList("Batik", "Simple");
    static final List<String> KML_REFLECTOR_MODES = Arrays.asList("refresh", "superoverlay", "download");
    static final List<String> KML_SUPEROVERLAY_MODES = Arrays.asList("auto", "raster", "overview", "hybrid", "cached");

    public WMSAdminPage() {
    }

    public WMSAdminPage(PageParameters pageParams) {
        super(pageParams);
    }

    public WMSAdminPage(WMSInfo service) {
        super((ServiceInfo)service);
    }

    protected Class<WMSInfo> getServiceClass() {
        return WMSInfo.class;
    }

    protected void build(IModel info, Form form) {
        LayerAuthoritiesAndIdentifiersPanel authAndIds = new LayerAuthoritiesAndIdentifiersPanel("authoritiesAndIds", true, (IModel<? extends CatalogInfo>)info);
        form.add(new Component[]{authAndIds});
        TextArea srsList = new TextArea("srs", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)info, "sRS"))){

            public IConverter getConverter(Class type) {
                return new SRSListConverter();
            }
        };
        srsList.add((IValidator)new SRSListValidator());
        srsList.setType(List.class);
        form.add(new Component[]{srsList});
        form.add(new Component[]{new CheckBox("bBOXForEachCRS")});
        form.add(new Component[]{new AjaxLink("bBOXForEachCRSHelp"){

            public void onClick(AjaxRequestTarget target) {
                WMSAdminPage.this.dialog.showInfo(target, (IModel)new StringResourceModel("bboxForEachCRSHelp.title", (Component)WMSAdminPage.this, null), new IModel[]{new StringResourceModel("bboxForEachCRSHelp.message", (Component)WMSAdminPage.this, null)});
            }
        }});
        form.add(new Component[]{new DropDownChoice("interpolation", Arrays.asList(WMSInfo.WMSInterpolation.values()), (IChoiceRenderer)new InterpolationRenderer())});
        TextField maxMemory = new TextField("maxRequestMemory");
        maxMemory.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxMemory});
        TextField maxTime = new TextField("maxRenderingTime");
        maxTime.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxTime});
        TextField maxErrors = new TextField("maxRenderingErrors");
        maxErrors.add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{maxErrors});
        form.add(new Component[]{new CheckBox("watermark.enabled")});
        form.add(new Component[]{new TextField("watermark.uRL").add((IValidator)new FileExistsValidator(true))});
        TextField transparency = new TextField("watermark.transparency");
        transparency.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{transparency});
        form.add(new Component[]{new DropDownChoice("watermark.position", Arrays.asList(WatermarkInfo.Position.values()), (IChoiceRenderer)new WatermarkPositionRenderer())});
        PropertyModel metadataModel = new PropertyModel((Object)info, "metadata");
        form.add(new Component[]{new CheckBox("svg.antialias", (IModel)new MapModel((IModel)metadataModel, "svgAntiAlias"))});
        form.add(new Component[]{new DropDownChoice("svg.producer", (IModel)new MapModel((IModel)metadataModel, "svgRenderer"), SVG_RENDERERS, (IChoiceRenderer)new SVGMethodRenderer())});
        MapModel pngCompression = this.defaultedModel((IModel)metadataModel, "pngCompression", 25);
        TextField pngCompressionField = new TextField("png.compression", (IModel)pngCompression, Integer.class);
        pngCompressionField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{pngCompressionField});
        MapModel jpegCompression = this.defaultedModel((IModel)metadataModel, "jpegCompression", 25);
        TextField jpegCompressionField = new TextField("jpeg.compression", (IModel)jpegCompression, Integer.class);
        jpegCompressionField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{jpegCompressionField});
        MapModel maxAllowedFrames = this.defaultedModel((IModel)metadataModel, "maxAllowedFrames", Integer.MAX_VALUE);
        TextField maxAllowedFramesField = new TextField("anim.maxallowedframes", (IModel)maxAllowedFrames, Integer.class);
        maxAllowedFramesField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        form.add(new Component[]{maxAllowedFramesField});
        MapModel maxRenderingTime = this.defaultedModel((IModel)metadataModel, "maxAnimatorRenderingTime", null);
        TextField maxRenderingTimeField = new TextField("anim.maxrenderingtime", (IModel)maxRenderingTime, Integer.class);
        form.add(new Component[]{maxRenderingTimeField});
        MapModel maxRenderingSize = this.defaultedModel((IModel)metadataModel, "maxRenderingSize", null);
        TextField maxRenderingSizeField = new TextField("anim.maxrenderingsize", (IModel)maxRenderingSize, Integer.class);
        form.add(new Component[]{maxRenderingSizeField});
        MapModel framesDelay = this.defaultedModel((IModel)metadataModel, "framesDelay", 1000);
        TextField framesDelayField = new TextField("anim.framesdelay", (IModel)framesDelay, Integer.class);
        framesDelayField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)));
        form.add(new Component[]{framesDelayField});
        MapModel loopContinuously = this.defaultedModel((IModel)metadataModel, "loopContinuously", WMS.LOOP_CONTINUOUSLY_DEFAULT);
        CheckBox loopContinuouslyField = new CheckBox("anim.loopcontinuously", (IModel)loopContinuously);
        form.add(new Component[]{loopContinuouslyField});
        MapModel kmlReflectorMode = this.defaultedModel((IModel)metadataModel, WMS.KML_REFLECTOR_MODE, "refresh");
        form.add(new Component[]{new DropDownChoice("kml.defaultReflectorMode", (IModel)kmlReflectorMode, KML_REFLECTOR_MODES)});
        MapModel kmlSuperoverlayMode = this.defaultedModel((IModel)metadataModel, "kmlSuperoverlayMode", "auto");
        form.add(new Component[]{new DropDownChoice("kml.superoverlayMode", (IModel)kmlSuperoverlayMode, KML_SUPEROVERLAY_MODES)});
        form.add(new Component[]{new CheckBox("kml.kmattr", (IModel)this.defaultedModel((IModel)metadataModel, "kmlAttr", true))});
        form.add(new Component[]{new CheckBox("kml.kmlplacemark", (IModel)this.defaultedModel((IModel)metadataModel, "kmlPlacemark", false))});
        MapModel kmScore = this.defaultedModel((IModel)metadataModel, "kmlKmscore", 40);
        TextField kmScoreField = new TextField("kml.kmscore", (IModel)kmScore, Integer.class);
        kmScoreField.add((IValidator)new RangeValidator((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)));
        form.add(new Component[]{kmScoreField});
    }

    MapModel defaultedModel(IModel baseModel, String key, Object defaultValue) {
        MapModel model = new MapModel(baseModel, key);
        if (model.getObject() == null) {
            model.setObject(defaultValue);
        }
        return model;
    }

    protected String getServiceName() {
        return "WMS";
    }

    private static class SRSListValidator
    extends AbstractValidator {
        private SRSListValidator() {
        }

        protected void onValidate(IValidatable validatable) {
            List srsList = (List)validatable.getValue();
            ArrayList<String> invalid = new ArrayList<String>();
            for (String srs : srsList) {
                try {
                    CRS.decode((String)("EPSG:" + srs));
                }
                catch (Exception e) {
                    invalid.add(srs);
                }
            }
            if (invalid.size() > 0) {
                this.error(validatable, "WMSAdminPage.unknownEPSGCodes", Collections.singletonMap("codes", ((Object)invalid).toString()));
            }
        }
    }

    private static class SRSListConverter
    implements IConverter {
        static final Pattern COMMA_SEPARATED = Pattern.compile("\\s*,\\s*", 8);

        private SRSListConverter() {
        }

        public String convertToString(Object value, Locale locale) {
            List srsList = (List)value;
            if (srsList.isEmpty()) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (String srs : srsList) {
                sb.append(srs).append(", ");
            }
            sb.setLength(sb.length() - 2);
            return sb.toString();
        }

        public Object convertToObject(String value, Locale locale) {
            if (value == null || value.trim().equals("")) {
                return Collections.emptyList();
            }
            return new ArrayList<String>(Arrays.asList(COMMA_SEPARATED.split(value)));
        }
    }

    private class SVGMethodRenderer
    implements IChoiceRenderer {
        private SVGMethodRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel("svg." + object, (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return (String)object;
        }
    }

    private class InterpolationRenderer
    implements IChoiceRenderer {
        private InterpolationRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((WMSInfo.WMSInterpolation)object).name(), (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((WMSInfo.WMSInterpolation)object).name();
        }
    }

    private class WatermarkPositionRenderer
    implements IChoiceRenderer {
        private WatermarkPositionRenderer() {
        }

        public Object getDisplayValue(Object object) {
            return new StringResourceModel(((WatermarkInfo.Position)object).name(), (Component)WMSAdminPage.this, null).getString();
        }

        public String getIdValue(Object object, int index) {
            return ((WatermarkInfo.Position)object).name();
        }
    }
}

