/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.nio.channels.Channels;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.map.RawMap;
import org.geotools.util.logging.Logging;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;

public class CachingWebMapService
implements MethodInterceptor {
    private static final Logger LOGGER = Logging.getLogger(CachingWebMapService.class);
    private GWC gwc;

    public CachingWebMapService(GWC gwc) {
        this.gwc = gwc;
    }

    public WebMap invoke(MethodInvocation invocation) throws Throwable {
        RawMap map;
        TileLayer layer;
        ConveyorTile cachedTile;
        block11: {
            byte[] tileBytes;
            Resource mapContents;
            GWCConfig config = this.gwc.getConfig();
            if (!config.isDirectWMSIntegrationEnabled()) {
                return (WebMap)invocation.proceed();
            }
            GetMapRequest request = this.getRequest(invocation);
            boolean tiled = request.isTiled();
            if (!tiled) {
                return (WebMap)invocation.proceed();
            }
            StringBuilder requestMistmatchTarget = new StringBuilder();
            cachedTile = this.gwc.dispatch(request, requestMistmatchTarget);
            if (cachedTile == null) {
                WebMap dynamicResult = (WebMap)invocation.proceed();
                dynamicResult.setResponseHeader("geowebcache-cache-result", Conveyor.CacheResult.MISS.toString());
                dynamicResult.setResponseHeader("geowebcache-miss-reason", requestMistmatchTarget.toString());
                return dynamicResult;
            }
            Preconditions.checkState((cachedTile.getTileLayer() != null ? 1 : 0) != 0);
            layer = cachedTile.getTileLayer();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("GetMap request intercepted, serving cached content: " + request);
            }
            if ((mapContents = cachedTile.getBlob()) instanceof ByteArrayResource) {
                tileBytes = ((ByteArrayResource)mapContents).getContents();
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                mapContents.transferTo(Channels.newChannel(out));
                tileBytes = out.toByteArray();
            }
            String ifNoneMatch = request.getHttpRequestHeader("If-None-Match");
            byte[] hash = MessageDigest.getInstance("MD5").digest(tileBytes);
            String etag = this.toHexString(hash);
            if (etag.equals(ifNoneMatch)) {
                LOGGER.finer("ETag matches, returning 304");
                throw new HttpErrorCodeException(304);
            }
            LOGGER.finer("No matching ETag, returning cached tile");
            String mimeType = cachedTile.getMimeType().getMimeType();
            map = new RawMap(null, tileBytes, mimeType);
            map.setResponseHeader("Cache-Control", "no-cache");
            map.setResponseHeader("ETag", etag);
            map.setContentDispositionHeader(null, "." + cachedTile.getMimeType().getFileExtension(), false);
            long tileTimeStamp = cachedTile.getTSCreated();
            String ifModSinceHeader = request.getHttpRequestHeader("If-Modified-Since");
            String lastModified = DateUtil.formatDate((Date)new Date(tileTimeStamp));
            map.setResponseHeader("Last-Modified", lastModified);
            if (ifModSinceHeader != null && ifModSinceHeader.length() > 0) {
                try {
                    Date ifModifiedSince = DateUtil.parseDate((String)ifModSinceHeader);
                    long ifModSinceSeconds = 1000L * (ifModifiedSince.getTime() / 1000L);
                    long tileTimeStampSeconds = 1000L * (tileTimeStamp / 1000L);
                    if (ifModSinceSeconds >= tileTimeStampSeconds) {
                        throw new HttpErrorCodeException(304);
                    }
                }
                catch (DateParseException e) {
                    if (!LOGGER.isLoggable(Level.FINER)) break block11;
                    LOGGER.finer("Can't parse client's If-Modified-Since header: '" + ifModSinceHeader + "'");
                }
            }
        }
        long[] tileIndex = cachedTile.getTileIndex();
        Conveyor.CacheResult cacheResult = cachedTile.getCacheResult();
        GridSubset gridSubset = layer.getGridSubset(cachedTile.getGridSetId());
        BoundingBox tileBounds = gridSubset.boundsFromIndex(tileIndex);
        String cacheResultHeader = cacheResult == null ? "UNKNOWN" : cacheResult.toString();
        map.setResponseHeader("geowebcache-layer", layer.getName());
        map.setResponseHeader("geowebcache-cache-result", cacheResultHeader);
        map.setResponseHeader("geowebcache-tile-index", Arrays.toString(tileIndex));
        map.setResponseHeader("geowebcache-tile-bounds", tileBounds.toString());
        map.setResponseHeader("geowebcache-gridset", gridSubset.getName());
        map.setResponseHeader("geowebcache-crs", gridSubset.getSRS().toString());
        return map;
    }

    private GetMapRequest getRequest(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        Preconditions.checkArgument((boolean)method.getDeclaringClass().equals(WebMapService.class));
        Preconditions.checkArgument((boolean)"getMap".equals(method.getName()));
        Object[] arguments = invocation.getArguments();
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(arguments[0] instanceof GetMapRequest));
        GetMapRequest request = (GetMapRequest)arguments[0];
        return request;
    }

    private String toHexString(byte[] hash) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hash.length; i += 4) {
            int c1 = 0xFF & hash[i];
            int c2 = 0xFF & hash[i + 1];
            int c3 = 0xFF & hash[i + 2];
            int c4 = 0xFF & hash[i + 3];
            int integer = (c1 << 24) + (c2 << 16) + (c3 << 8) + (c4 << 0);
            sb.append(Integer.toHexString(integer));
        }
        return sb.toString();
    }
}

