/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.LegacyTileLayerInfoLoader;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;

public class TileLayerInfoUtil {
    public static GeoServerTileLayerInfo loadOrCreate(CatalogInfo info, GWCConfig defaults) {
        if (info instanceof LayerInfo) {
            return TileLayerInfoUtil.loadOrCreate((LayerInfo)info, defaults);
        }
        if (info instanceof LayerGroupInfo) {
            return TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)info, defaults);
        }
        throw new IllegalArgumentException();
    }

    public static GeoServerTileLayerInfoImpl loadOrCreate(LayerGroupInfo groupInfo, GWCConfig defaults) {
        GeoServerTileLayerInfoImpl info = LegacyTileLayerInfoLoader.load(groupInfo);
        if (info == null) {
            info = TileLayerInfoUtil.create(defaults);
        }
        info.setName(GWC.tileLayerName(groupInfo));
        info.setId(groupInfo.getId());
        return info;
    }

    public static GeoServerTileLayerInfoImpl loadOrCreate(LayerInfo layerInfo, GWCConfig defaults) {
        GeoServerTileLayerInfoImpl info = LegacyTileLayerInfoLoader.load(layerInfo);
        if (info == null) {
            info = TileLayerInfoUtil.create(defaults);
            ResourceInfo resource = layerInfo.getResource();
            if (resource instanceof FeatureTypeInfo) {
                info.getMimeFormats().clear();
                info.getMimeFormats().addAll(defaults.getDefaultVectorCacheFormats());
            } else if (resource instanceof CoverageInfo) {
                info.getMimeFormats().clear();
                info.getMimeFormats().addAll(defaults.getDefaultCoverageCacheFormats());
            }
            TileLayerInfoUtil.checkStyles(layerInfo, info);
        }
        info.setName(GWC.tileLayerName(layerInfo));
        info.setId(layerInfo.getId());
        return info;
    }

    public static GeoServerTileLayerInfoImpl create(GWCConfig defaults) {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setEnabled(defaults.isCacheLayersByDefault());
        info.setAutoCacheStyles(defaults.isCacheNonDefaultStyles());
        for (String gsetId : defaults.getDefaultCachingGridSetIds()) {
            XMLGridSubset subset = new XMLGridSubset();
            subset.setGridSetName(gsetId);
            info.getGridSubsets().add(subset);
        }
        info.getMimeFormats().addAll(defaults.getDefaultOtherCacheFormats());
        info.setGutter(defaults.getGutter());
        info.setMetaTilingX(defaults.getMetaTilingX());
        info.setMetaTilingY(defaults.getMetaTilingY());
        return info;
    }

    private static void checkStyles(LayerInfo layer, GeoServerTileLayerInfo layerInfo) {
        if (layerInfo.isAutoCacheStyles() && layer.getStyles() != null && layer.getStyles().size() > 0 && null == TileLayerInfoUtil.findParameterFilter("STYLES", layerInfo.getParameterFilters())) {
            String defaultStyle = layer.getDefaultStyle() == null ? null : layer.getDefaultStyle().getName();
            HashSet<String> cachedStyles = new HashSet<String>();
            for (StyleInfo s : layer.getStyles()) {
                if (s == null) continue;
                cachedStyles.add(s.getName());
            }
            TileLayerInfoUtil.setCachedStyles(layerInfo, defaultStyle, cachedStyles);
        }
    }

    public static ParameterFilter findParameterFilter(String paramName, Set<ParameterFilter> parameterFilters) {
        if (parameterFilters == null || parameterFilters.size() == 0) {
            return null;
        }
        for (ParameterFilter pf : parameterFilters) {
            if (!paramName.equalsIgnoreCase(pf.getKey())) continue;
            return pf;
        }
        return null;
    }

    public static void setCachedStyles(GeoServerTileLayerInfo info, String defaultStyle, Set<String> cachedStyles) {
        TileLayerInfoUtil.updateStringParameterFilter(info, "STYLES", true, defaultStyle, cachedStyles);
    }

    public static void updateStringParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey, boolean createParam, String defaultValue, String ... allowedValues) {
        HashSet<String> validValues = new HashSet<String>();
        if (allowedValues != null) {
            validValues.addAll(Arrays.asList(allowedValues));
        }
        TileLayerInfoUtil.updateStringParameterFilter(tileLayerInfo, paramKey, createParam, defaultValue, validValues);
    }

    public static void updateStringParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey, boolean createParam, String defaultValue, Set<String> allowedValues) {
        TileLayerInfoUtil.removeParameterFilter(tileLayerInfo, paramKey);
        if (createParam && allowedValues != null && allowedValues.size() > 0) {
            TreeSet<String> values = new TreeSet<String>(allowedValues);
            StringParameterFilter stringListFilter = new StringParameterFilter();
            stringListFilter.setKey(paramKey);
            stringListFilter.setDefaultValue(defaultValue == null ? "" : defaultValue);
            stringListFilter.getValues().addAll(values);
            tileLayerInfo.getParameterFilters().add((ParameterFilter)stringListFilter);
        }
    }

    private static void removeParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey) {
        Set<ParameterFilter> parameterFilters = tileLayerInfo.getParameterFilters();
        Iterator<ParameterFilter> it = parameterFilters.iterator();
        while (it.hasNext()) {
            if (!paramKey.equalsIgnoreCase(it.next().getKey())) continue;
            it.remove();
            break;
        }
    }

    public static void updateAcceptAllRegExParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey, boolean createParam) {
        Set<ParameterFilter> parameterFilters = tileLayerInfo.getParameterFilters();
        Iterator<ParameterFilter> it = parameterFilters.iterator();
        while (it.hasNext()) {
            ParameterFilter parameterFilter = it.next();
            String key = parameterFilter.getKey();
            if (!paramKey.equalsIgnoreCase(key)) continue;
            it.remove();
            break;
        }
        if (createParam) {
            RegexParameterFilter filter = new RegexParameterFilter();
            filter.setKey(paramKey);
            filter.setDefaultValue("");
            filter.setRegex(".*");
            tileLayerInfo.getParameterFilters().add((ParameterFilter)filter);
        }
    }

    public static void updateAcceptAllFloatParameterFilter(GeoServerTileLayerInfo info, String paramKey, boolean createParam) {
        Set<ParameterFilter> parameterFilters = info.getParameterFilters();
        Iterator<ParameterFilter> it = parameterFilters.iterator();
        while (it.hasNext()) {
            ParameterFilter parameterFilter = it.next();
            String key = parameterFilter.getKey();
            if (!paramKey.equalsIgnoreCase(key)) continue;
            it.remove();
            break;
        }
        if (createParam) {
            FloatParameterFilter filter = new FloatParameterFilter();
            filter.setKey(paramKey);
            filter.setDefaultValue("");
            info.getParameterFilters().add((ParameterFilter)filter);
        }
    }
}

