/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.layer.ExpirationRule;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.mime.FormatModifier;

public class GeoServerTileLayerInfoImpl
implements Serializable,
GeoServerTileLayerInfo {
    public static final long serialVersionUID = -3664183627578933094L;
    private String id;
    private boolean enabled;
    private String name;
    private transient LayerMetaInformation metaInformation;
    private Set<String> mimeFormats;
    private List<FormatModifier> formatModifiers;
    private Set<XMLGridSubset> gridSubsets;
    private transient List<? extends UpdateSourceDefinition> updateSources;
    private transient List<? extends RequestFilter> requestFilters;
    private transient boolean useETags;
    private int[] metaWidthHeight;
    private transient int expireCache;
    private transient List<ExpirationRule> expireCacheList;
    private transient int expireClients;
    private transient List<ExpirationRule> expireClientsList;
    private transient Integer backendTimeout;
    private transient Boolean cacheBypassAllowed;
    private transient Boolean queryable;
    private Set<ParameterFilter> parameterFilters;
    private int gutter;
    private boolean autoCacheStyles;

    public GeoServerTileLayerInfoImpl() {
        this.readResolve();
    }

    private final GeoServerTileLayerInfo readResolve() {
        if (null == this.metaWidthHeight) {
            this.metaWidthHeight = new int[2];
        }
        this.gridSubsets = this.nonNull(this.gridSubsets);
        this.mimeFormats = this.nonNull(this.mimeFormats);
        this.parameterFilters = this.nonNull(this.parameterFilters);
        return this;
    }

    @Override
    public GeoServerTileLayerInfoImpl clone() {
        GeoServerTileLayerInfoImpl clone;
        try {
            clone = (GeoServerTileLayerInfoImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        clone.metaWidthHeight = (int[])this.metaWidthHeight.clone();
        clone.gridSubsets = this.nonNull(null);
        for (XMLGridSubset gs : this.gridSubsets) {
            clone.gridSubsets.add(gs.clone());
        }
        clone.mimeFormats = this.nonNull(null);
        clone.mimeFormats.addAll(this.mimeFormats);
        clone.parameterFilters = this.nonNull(null);
        for (ParameterFilter pf : this.parameterFilters) {
            clone.parameterFilters.add(pf.clone());
        }
        return clone;
    }

    private <T> Set<T> nonNull(Set<T> set) {
        return set == null ? new HashSet() : set;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getMetaTilingX() {
        return this.metaWidthHeight[0];
    }

    @Override
    public int getMetaTilingY() {
        return this.metaWidthHeight[1];
    }

    @Override
    public void setMetaTilingY(int metaTilingY) {
        Preconditions.checkArgument((metaTilingY > 0 ? 1 : 0) != 0);
        this.metaWidthHeight[1] = metaTilingY;
    }

    @Override
    public void setMetaTilingX(int metaTilingX) {
        Preconditions.checkArgument((metaTilingX > 0 ? 1 : 0) != 0);
        this.metaWidthHeight[0] = metaTilingX;
    }

    @Override
    public ImmutableSet<String> cachedStyles() {
        ParameterFilter styleQualifier = TileLayerInfoUtil.findParameterFilter("STYLES", this.getParameterFilters());
        if (styleQualifier != null && styleQualifier instanceof StringParameterFilter) {
            StringParameterFilter sp = (StringParameterFilter)styleQualifier;
            return ImmutableSet.copyOf((Collection)sp.getLegalValues());
        }
        return ImmutableSet.of();
    }

    @Override
    public Set<String> getMimeFormats() {
        return this.mimeFormats;
    }

    @Override
    public Set<XMLGridSubset> getGridSubsets() {
        return this.gridSubsets;
    }

    @Override
    public void setGridSubsets(Set<XMLGridSubset> gridSubsets) {
        this.gridSubsets = this.nonNull(gridSubsets);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setGutter(int gutter) {
        this.gutter = gutter;
    }

    @Override
    public int getGutter() {
        return this.gutter;
    }

    @Override
    public boolean isAutoCacheStyles() {
        return this.autoCacheStyles;
    }

    @Override
    public void setAutoCacheStyles(boolean autoCacheStyles) {
        this.autoCacheStyles = autoCacheStyles;
    }

    @Override
    public Set<ParameterFilter> getParameterFilters() {
        return this.parameterFilters;
    }

    @Override
    public void setParameterFilters(Set<ParameterFilter> parameterFilters) {
        this.parameterFilters = this.nonNull(parameterFilters);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

