/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerMetaTile;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.RenderedImageMap;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.CanonicalSet;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.request.RequestFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.GridLocObj;
import org.geowebcache.layer.LayerListenerList;
import org.geowebcache.layer.MetaTile;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerListener;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.mime.FormatModifier;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.ServletUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoServerTileLayer
extends TileLayer {
    private static final Logger LOGGER = Logging.getLogger(GeoServerTileLayer.class);
    private final GeoServerTileLayerInfo info;
    public static final String GWC_SEED_INTERCEPT_TOKEN = "GWC_SEED_INTERCEPT";
    public static final ThreadLocal<WebMap> WEB_MAP = new ThreadLocal();
    private final LayerInfo layerInfo;
    private final LayerGroupInfo layerGroupInfo;
    private String configErrorMessage;
    private Map<String, GridSubset> subSets;
    private static LayerListenerList listeners = new LayerListenerList();
    private final GridSetBroker gridSetBroker;
    private static final CanonicalSet<GridLocObj> META_GRID_LOCKS = CanonicalSet.newInstance(GridLocObj.class);

    public GeoServerTileLayer(LayerGroupInfo layerGroup, GWCConfig configDefaults, GridSetBroker gridsets) {
        Preconditions.checkNotNull((Object)layerGroup, (Object)"layerGroup");
        Preconditions.checkNotNull((Object)gridsets, (Object)"gridsets");
        Preconditions.checkNotNull((Object)configDefaults, (Object)"configDefaults");
        this.gridSetBroker = gridsets;
        this.layerInfo = null;
        this.layerGroupInfo = layerGroup;
        this.info = TileLayerInfoUtil.loadOrCreate(layerGroup, configDefaults);
    }

    public GeoServerTileLayer(LayerInfo layerInfo, GWCConfig configDefaults, GridSetBroker gridsets) {
        Preconditions.checkNotNull((Object)layerInfo, (Object)"layerInfo");
        Preconditions.checkNotNull((Object)gridsets, (Object)"gridsets");
        Preconditions.checkNotNull((Object)configDefaults, (Object)"configDefaults");
        this.gridSetBroker = gridsets;
        this.layerInfo = layerInfo;
        this.layerGroupInfo = null;
        this.info = TileLayerInfoUtil.loadOrCreate(layerInfo, configDefaults);
    }

    public GeoServerTileLayer(LayerGroupInfo layerGroup, GridSetBroker gridsets, GeoServerTileLayerInfo state) {
        Preconditions.checkNotNull((Object)layerGroup, (Object)"layerGroup");
        Preconditions.checkNotNull((Object)gridsets, (Object)"gridsets");
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.gridSetBroker = gridsets;
        this.layerInfo = null;
        this.layerGroupInfo = layerGroup;
        this.info = state;
    }

    public GeoServerTileLayer(LayerInfo layerInfo, GridSetBroker gridsets, GeoServerTileLayerInfo state) {
        Preconditions.checkNotNull((Object)layerInfo, (Object)"layerInfo");
        Preconditions.checkNotNull((Object)gridsets, (Object)"gridsets");
        Preconditions.checkNotNull((Object)state, (Object)"state");
        this.gridSetBroker = gridsets;
        this.layerInfo = layerInfo;
        this.layerGroupInfo = null;
        this.info = state;
    }

    public String getId() {
        return this.info.getId();
    }

    public String getName() {
        return this.info.getName();
    }

    void setConfigErrorMessage(String configErrorMessage) {
        this.configErrorMessage = configErrorMessage;
    }

    public String getConfigErrorMessage() {
        return this.configErrorMessage;
    }

    public List<ParameterFilter> getParameterFilters() {
        return new ArrayList<ParameterFilter>(this.info.getParameterFilters());
    }

    public void resetParameterFilters() {
        this.defaultParameterFilterValues = null;
    }

    public boolean isEnabled() {
        boolean tileLayerInfoEnabled = this.info.isEnabled();
        if (!tileLayerInfoEnabled) {
            return false;
        }
        if (this.getConfigErrorMessage() != null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Layer " + this.getName() + "is not enabled due to config error: " + this.getConfigErrorMessage());
            }
            return false;
        }
        LayerInfo layerInfo = this.getLayerInfo();
        boolean geoserverLayerEnabled = layerInfo != null ? layerInfo.enabled() : true;
        return tileLayerInfoEnabled && geoserverLayerEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.info.setEnabled(enabled);
    }

    public boolean isQueryable() {
        boolean queryable = GWC.get().isQueryable(this);
        return queryable;
    }

    private ReferencedEnvelope getLatLonBbox() throws IllegalStateException {
        ReferencedEnvelope latLongBbox;
        CoordinateReferenceSystem wgs84LonFirst;
        try {
            boolean longitudeFirst = true;
            wgs84LonFirst = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.getLayerInfo() == null) {
            LayerGroupInfo groupInfo = this.getLayerGroupInfo();
            try {
                ReferencedEnvelope bounds = groupInfo.getBounds();
                boolean lenient = true;
                latLongBbox = bounds.transform(wgs84LonFirst, lenient);
            }
            catch (Exception e) {
                String msg = "Can't get lat long bounds for layer group " + GWC.tileLayerName(groupInfo);
                LOGGER.log(Level.WARNING, msg, e);
                throw new IllegalStateException(msg, e);
            }
        } else {
            ResourceInfo resourceInfo = this.getResourceInfo();
            latLongBbox = resourceInfo.getLatLonBoundingBox();
            if (null == latLongBbox) {
                latLongBbox = new ReferencedEnvelope(wgs84LonFirst);
            }
            if (null == latLongBbox.getCoordinateReferenceSystem()) {
                ReferencedEnvelope tmp = new ReferencedEnvelope(wgs84LonFirst);
                tmp.init(latLongBbox.getMinX(), latLongBbox.getMaxX(), latLongBbox.getMinY(), latLongBbox.getMaxY());
                latLongBbox = tmp;
            }
        }
        return latLongBbox;
    }

    public LayerInfo getLayerInfo() {
        return this.layerInfo;
    }

    public LayerGroupInfo getLayerGroupInfo() {
        return this.layerGroupInfo;
    }

    private ResourceInfo getResourceInfo() {
        LayerInfo layerInfo = this.getLayerInfo();
        return layerInfo == null ? null : layerInfo.getResource();
    }

    public LayerMetaInformation getMetaInformation() {
        LayerMetaInformation meta = null;
        String title = this.getName();
        String description = "";
        List keywords = Collections.emptyList();
        List contacts = Collections.emptyList();
        ResourceInfo resourceInfo = this.getResourceInfo();
        if (resourceInfo != null) {
            title = resourceInfo.getTitle();
            description = resourceInfo.getAbstract();
            keywords = new ArrayList();
            for (KeywordInfo kw : resourceInfo.getKeywords()) {
                keywords.add(kw.getValue());
            }
        }
        meta = new LayerMetaInformation(title, description, keywords, contacts);
        return meta;
    }

    public String getStyles() {
        if (this.layerGroupInfo != null) {
            return null;
        }
        StyleInfo defaultStyle = this.layerInfo.getDefaultStyle();
        if (defaultStyle == null) {
            this.setConfigErrorMessage("Underlying GeoSever Layer has no default style");
            return null;
        }
        return defaultStyle.getName();
    }

    public Resource getFeatureInfo(ConveyorTile convTile, BoundingBox bbox, int height, int width, int x, int y) throws GeoWebCacheException {
        Resource response;
        Map<String, String> params = this.buildGetFeatureInfo(convTile, bbox, height, width, x, y);
        try {
            response = GWC.get().dispatchOwsRequest(params, null);
        }
        catch (Exception e) {
            throw new GeoWebCacheException((Throwable)e);
        }
        return response;
    }

    private Map<String, String> buildGetFeatureInfo(ConveyorTile convTile, BoundingBox bbox, int height, int width, int x, int y) {
        Map fullParameters;
        HashMap<String, String> wmsParams = new HashMap<String, String>();
        wmsParams.put("SERVICE", "WMS");
        wmsParams.put("VERSION", "1.1.1");
        wmsParams.put("REQUEST", "GetFeatureInfo");
        wmsParams.put("LAYERS", this.getName());
        wmsParams.put("STYLES", "");
        wmsParams.put("QUERY_LAYERS", this.getName());
        MimeType mimeType = convTile.getMimeType();
        if (mimeType == null) {
            mimeType = this.getMimeTypes().get(0);
        }
        wmsParams.put("FORMAT", mimeType.getFormat());
        wmsParams.put("EXCEPTIONS", "SE_XML");
        wmsParams.put("INFO_FORMAT", convTile.getMimeType().getFormat());
        GridSubset gridSubset = convTile.getGridSubset();
        wmsParams.put("SRS", gridSubset.getSRS().toString());
        wmsParams.put("HEIGHT", String.valueOf(height));
        wmsParams.put("WIDTH", String.valueOf(width));
        wmsParams.put("BBOX", bbox.toString());
        wmsParams.put("X", String.valueOf(x));
        wmsParams.put("Y", String.valueOf(y));
        Map values = ServletUtils.selectedStringsFromMap((Map)convTile.servletReq.getParameterMap(), (String)convTile.servletReq.getCharacterEncoding(), (String[])new String[]{"feature_count"});
        String featureCount = (String)values.get("feature_count");
        if (featureCount != null) {
            wmsParams.put("FEATURE_COUNT", featureCount);
        }
        if ((fullParameters = convTile.getFullParameters()).isEmpty()) {
            fullParameters = this.getDefaultParameterFilters();
        }
        wmsParams.putAll(fullParameters);
        return wmsParams;
    }

    public ConveyorTile getTile(ConveyorTile tile) throws GeoWebCacheException, IOException, OutsideCoverageException {
        int metaY;
        int metaX;
        MimeType mime = tile.getMimeType();
        List<MimeType> formats = this.getMimeTypes();
        if (mime == null) {
            mime = formats.get(0);
        } else if (!formats.contains(mime)) {
            throw new IllegalArgumentException(mime.getFormat() + " is not a supported format for " + this.getName());
        }
        String tileGridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(tileGridSetId);
        if (gridSubset == null) {
            throw new IllegalArgumentException("Requested gridset not found: " + tileGridSetId);
        }
        long[] gridLoc = tile.getTileIndex();
        Preconditions.checkNotNull((Object)gridLoc);
        gridSubset.checkCoverage(gridLoc);
        if (mime.supportsTiling()) {
            metaX = this.info.getMetaTilingX();
            metaY = this.info.getMetaTilingY();
        } else {
            metaY = 1;
            metaX = 1;
        }
        ConveyorTile returnTile = this.getMetatilingReponse(tile, true, metaX, metaY);
        this.sendTileRequestedEvent(returnTile);
        return returnTile;
    }

    public void addLayerListener(TileLayerListener listener) {
        listeners.addListener(listener);
    }

    public boolean removeLayerListener(TileLayerListener listener) {
        listeners.removeListener(listener);
        return true;
    }

    protected final void sendTileRequestedEvent(ConveyorTile tile) {
        if (listeners != null) {
            listeners.sendTileRequested((TileLayer)this, tile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConveyorTile getMetatilingReponse(ConveyorTile tile, boolean tryCache, int metaX, int metaY) throws GeoWebCacheException, IOException {
        GridLocObj metaGridLoc;
        int zLevel;
        GridSubset gridSubset = this.getGridSubset(tile.getGridSetId());
        tile.setMetaTileCacheOnly(!gridSubset.shouldCacheAtZoom((long)(zLevel = (int)tile.getTileIndex()[2])));
        if (tryCache && this.tryCacheFetch(tile)) {
            return this.finalizeTile(tile);
        }
        GeoServerMetaTile metaTile = this.createMetaTile(tile, metaX, metaY);
        GridLocObj gridLocObj = metaGridLoc = (GridLocObj)META_GRID_LOCKS.unique((Object)new GridLocObj(metaTile.getMetaGridPos(), 32));
        synchronized (gridLocObj) {
            if (tryCache && this.tryCacheFetch(tile)) {
                LOGGER.finest("--> " + Thread.currentThread().getName() + " returns cache hit for " + Arrays.toString(metaTile.getMetaGridPos()));
            } else {
                LOGGER.finer("--> " + Thread.currentThread().getName() + " submitting getMap request for meta grid location " + Arrays.toString(metaTile.getMetaGridPos()) + " on " + (Object)((Object)metaTile));
                try {
                    RenderedImageMap map = this.dispatchGetMap(tile, metaTile);
                    Preconditions.checkNotNull((Object)map, (Object)"Did not obtain a WebMap from GeoServer's Dispatcher");
                    metaTile.setWebMap(map);
                    this.saveTiles(metaTile, tile);
                }
                catch (Exception e) {
                    throw new GeoWebCacheException("Problem communicating with GeoServer", (Throwable)e);
                }
                finally {
                    META_GRID_LOCKS.remove((Object)metaGridLoc);
                    metaTile.dispose();
                }
            }
        }
        return this.finalizeTile(tile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RenderedImageMap dispatchGetMap(ConveyorTile tile, MetaTile metaTile) throws Exception {
        WebMap map;
        Map<String, String> params = this.buildGetMap(tile, metaTile);
        try {
            HttpServletRequest actualRequest = tile.servletReq;
            Cookie[] cookies = actualRequest == null ? null : actualRequest.getCookies();
            GWC.get().dispatchOwsRequest(params, cookies);
            map = WEB_MAP.get();
            if (!(map instanceof RenderedImageMap)) {
                throw new IllegalStateException("Expected: RenderedImageMap, got " + map);
            }
        }
        finally {
            WEB_MAP.remove();
        }
        return (RenderedImageMap)map;
    }

    private GeoServerMetaTile createMetaTile(ConveyorTile tile, int metaX, int metaY) {
        String tileGridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(tileGridSetId);
        MimeType responseFormat = tile.getMimeType();
        FormatModifier formatModifier = null;
        long[] tileGridPosition = tile.getTileIndex();
        int gutter = this.info.getGutter();
        GeoServerMetaTile metaTile = new GeoServerMetaTile(gridSubset, responseFormat, formatModifier, tileGridPosition, metaX, metaY, gutter);
        return metaTile;
    }

    private Map<String, String> buildGetMap(ConveyorTile tile, MetaTile metaTile) throws ParameterException {
        HashMap<String, String> params = new HashMap<String, String>();
        MimeType mimeType = tile.getMimeType();
        String gridSetId = tile.getGridSetId();
        GridSubset gridSubset = this.getGridSubset(gridSetId);
        int width = metaTile.getMetaTileWidth();
        int height = metaTile.getMetaTileHeight();
        String srs = gridSubset.getSRS().toString();
        String format = mimeType.getFormat();
        BoundingBox bbox = metaTile.getMetaTileBounds();
        params.put("SERVICE", "WMS");
        params.put("VERSION", "1.1.1");
        params.put("REQUEST", "GetMap");
        params.put("LAYERS", this.getName());
        params.put("SRS", srs);
        params.put("FORMAT", format);
        params.put("WIDTH", String.valueOf(width));
        params.put("HEIGHT", String.valueOf(height));
        params.put("BBOX", bbox.toString());
        params.put("EXCEPTIONS", "SE_XML");
        params.put("STYLES", "");
        params.put("TRANSPARENT", "true");
        params.put(GWC_SEED_INTERCEPT_TOKEN, "true");
        Map filteredParams = tile.getFullParameters();
        if (filteredParams.isEmpty()) {
            filteredParams = this.getDefaultParameterFilters();
        }
        params.putAll(filteredParams);
        return params;
    }

    private boolean tryCacheFetch(ConveyorTile tile) {
        int expireCache = this.getExpireCache((int)tile.getTileIndex()[2]);
        if (expireCache != -1) {
            try {
                return tile.retrieve((long)expireCache * 1000L);
            }
            catch (GeoWebCacheException gwce) {
                LOGGER.info(gwce.getMessage());
                tile.setErrorMsg(gwce.getMessage());
                return false;
            }
        }
        return false;
    }

    private ConveyorTile finalizeTile(ConveyorTile tile) {
        if (tile.getStatus() == 0 && !tile.getError()) {
            tile.setStatus(200);
        }
        if (tile.servletResp != null) {
            this.setExpirationHeader(tile.servletResp, (int)tile.getTileIndex()[2]);
            this.setTileIndexHeader(tile);
        }
        tile.setTileLayer((TileLayer)this);
        return tile;
    }

    private void setTileIndexHeader(ConveyorTile tile) {
        tile.servletResp.addHeader("geowebcache-tile-index", Arrays.toString(tile.getTileIndex()));
    }

    public ConveyorTile getNoncachedTile(ConveyorTile tile) throws GeoWebCacheException {
        try {
            return this.getMetatilingReponse(tile, false, 1, 1);
        }
        catch (IOException e) {
            throw new GeoWebCacheException((Throwable)e);
        }
    }

    public ConveyorTile doNonMetatilingRequest(ConveyorTile tile) throws GeoWebCacheException {
        try {
            return this.getMetatilingReponse(tile, true, 1, 1);
        }
        catch (IOException e) {
            throw new GeoWebCacheException((Throwable)e);
        }
    }

    public void seedTile(ConveyorTile tile, boolean tryCache) throws GeoWebCacheException, IOException {
        int zLevel;
        GridSubset gridSubset = this.getGridSubset(tile.getGridSetId());
        if (!gridSubset.shouldCacheAtZoom((long)(zLevel = (int)tile.getTileIndex()[2]))) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Ignoring seed call on tile " + tile + " as it's outside the cacheable zoom level range");
            }
            return;
        }
        int metaX = this.info.getMetaTilingX();
        int metaY = this.info.getMetaTilingY();
        if (!tile.getMimeType().supportsTiling()) {
            metaY = 1;
            metaX = 1;
        }
        this.getMetatilingReponse(tile, tryCache, metaX, metaY);
    }

    public void acquireLayerLock() {
    }

    public void releaseLayerLock() {
    }

    public synchronized Set<String> getGridSubsets() {
        this.checkGridSubsets();
        return new HashSet<String>(this.subSets.keySet());
    }

    public GridSubset getGridSubset(String gridSetId) {
        this.checkGridSubsets();
        return this.subSets.get(gridSetId);
    }

    private synchronized void checkGridSubsets() {
        if (this.subSets == null) {
            ReferencedEnvelope latLongBbox = this.getLatLonBbox();
            try {
                this.subSets = this.getGrids(latLongBbox, this.gridSetBroker);
            }
            catch (ConfigurationException e) {
                String msg = "Can't create grids for '" + this.getName() + "': " + e.getMessage();
                LOGGER.log(Level.WARNING, msg, e);
                this.setConfigErrorMessage(msg);
            }
        }
    }

    public synchronized GridSubset removeGridSubset(String gridSetId) {
        this.checkGridSubsets();
        GridSubset oldValue = this.subSets.remove(gridSetId);
        HashSet<XMLGridSubset> gridSubsets = new HashSet<XMLGridSubset>(this.info.getGridSubsets());
        Iterator it = gridSubsets.iterator();
        while (it.hasNext()) {
            if (!((XMLGridSubset)it.next()).getGridSetName().equals(gridSetId)) continue;
            it.remove();
            break;
        }
        this.info.setGridSubsets(gridSubsets);
        return oldValue;
    }

    public void addGridSubset(GridSubset gridSubset) {
        XMLGridSubset gridSubsetInfo = new XMLGridSubset(gridSubset);
        HashSet<XMLGridSubset> gridSubsets = new HashSet<XMLGridSubset>(this.info.getGridSubsets());
        gridSubsets.add(gridSubsetInfo);
        this.info.setGridSubsets(gridSubsets);
        this.subSets = null;
    }

    private Map<String, GridSubset> getGrids(ReferencedEnvelope latLonBbox, GridSetBroker gridSetBroker) throws ConfigurationException {
        Set<XMLGridSubset> cachedGridSets = this.info.getGridSubsets();
        if (cachedGridSets.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, GridSubset> grids = new HashMap<String, GridSubset>(2);
        for (XMLGridSubset gridSubset : cachedGridSets) {
            String gridSetId = gridSubset.getGridSetName();
            GridSet gridSet = gridSetBroker.get(gridSetId);
            if (gridSet == null) {
                LOGGER.info("No GWC GridSet named '" + gridSetId + "' exists.");
                continue;
            }
            BoundingBox extent = gridSubset.getExtent();
            if (null == extent) {
                try {
                    BoundingBox intersection;
                    SRS srs = gridSet.getSrs();
                    try {
                        extent = this.getBounds(srs);
                    }
                    catch (RuntimeException cantComputeBounds) {
                        String msg = "Can't compute bounds for tile layer " + this.getName() + " in CRS " + srs + ". Assuming full GridSet bounds. (" + cantComputeBounds.getMessage() + ")";
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, msg, cantComputeBounds);
                        } else {
                            LOGGER.warning(msg);
                        }
                        extent = gridSet.getBounds();
                    }
                    BoundingBox maxBounds = gridSet.getBounds();
                    extent = intersection = maxBounds.intersection(extent);
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Error computing layer bounds, assuming whole GridSet bounds", e);
                    extent = gridSet.getOriginalExtent();
                }
            }
            gridSubset.setExtent(extent);
            GridSubset gridSubSet = gridSubset.getGridSubSet(gridSetBroker);
            grids.put(gridSetId, gridSubSet);
        }
        return grids;
    }

    private BoundingBox getBounds(SRS srs) {
        ReferencedEnvelope transformedBounds;
        CoordinateReferenceSystem targetCrs;
        try {
            String epsgCode = srs.toString();
            boolean longitudeFirst = true;
            targetCrs = CRS.decode((String)epsgCode, (boolean)true);
            Preconditions.checkNotNull((Object)targetCrs);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        ReferencedEnvelope nativeBounds = this.getLayerInfo() != null ? this.getLayerInfo().getResource().getNativeBoundingBox() : this.getLayerGroupInfo().getBounds();
        Preconditions.checkState((nativeBounds != null ? 1 : 0) != 0, (String)this.getName(), (Object[])new Object[]{" has no native bounds set"});
        try {
            transformedBounds = nativeBounds.transform(targetCrs, true, 10000);
        }
        catch (Exception e) {
            Geometry targetAov = GWC.getAreaOfValidityAsGeometry(targetCrs, this.gridSetBroker);
            if (null == targetAov) {
                String msg = "Can't compute tile layer bouds out of resource native bounds for CRS " + srs;
                LOGGER.log(Level.WARNING, msg, e);
                throw new IllegalArgumentException(msg, e);
            }
            LOGGER.log(Level.FINE, "Can't compute tile layer bouds out of resource native bounds for CRS " + srs, e);
            CoordinateReferenceSystem nativeCrs = nativeBounds.getCoordinateReferenceSystem();
            try {
                ReferencedEnvelope targetAovBounds = new ReferencedEnvelope(targetAov.getEnvelopeInternal(), targetCrs);
                ReferencedEnvelope targetAovInNativeCrs = targetAovBounds.transform(nativeCrs, true, 10000);
                Envelope intersection = targetAovInNativeCrs.intersection((Envelope)nativeBounds);
                ReferencedEnvelope clipped = new ReferencedEnvelope(intersection, nativeCrs);
                transformedBounds = clipped.transform(targetCrs, true, 10000);
            }
            catch (Exception e1) {
                throw Throwables.propagate((Throwable)e1);
            }
        }
        BoundingBox targetBbox = new BoundingBox(transformedBounds.getMinX(), transformedBounds.getMinY(), transformedBounds.getMaxX(), transformedBounds.getMaxY());
        return targetBbox;
    }

    public GeoServerTileLayerInfo getInfo() {
        return this.info;
    }

    public List<UpdateSourceDefinition> getUpdateSources() {
        return Collections.emptyList();
    }

    public boolean useETags() {
        return false;
    }

    public List<FormatModifier> getFormatModifiers() {
        return Collections.emptyList();
    }

    public void setFormatModifiers(List<FormatModifier> formatModifiers) {
        throw new UnsupportedOperationException();
    }

    public int[] getMetaTilingFactors() {
        return new int[]{this.info.getMetaTilingX(), this.info.getMetaTilingY()};
    }

    public Boolean isCacheBypassAllowed() {
        return true;
    }

    public void setCacheBypassAllowed(boolean allowed) {
        throw new UnsupportedOperationException();
    }

    public Integer getBackendTimeout() {
        return 0;
    }

    public void setBackendTimeout(int seconds) {
        throw new UnsupportedOperationException();
    }

    public List<MimeType> getMimeTypes() {
        Set<String> mimeFormats = this.info.getMimeFormats();
        ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>(mimeFormats.size());
        for (String format : mimeFormats) {
            try {
                mimeTypes.add(MimeType.createFromFormat((String)format));
            }
            catch (MimeException e) {
                LOGGER.log(Level.WARNING, "Can't create MimeType from format " + format, e);
            }
        }
        return mimeTypes;
    }

    public int getExpireClients(int zoomLevel) {
        return 0;
    }

    public int getExpireCache(int zoomLevel) {
        return 0;
    }

    public List<RequestFilter> getRequestFilters() {
        return null;
    }

    public boolean initialize(GridSetBroker gridSetBroker) {
        return true;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.info + "]";
    }
}

