/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geowebcache.config.XMLConfigurationProvider;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.service.HttpErrorCodeException;

public class GWCGeoServerRESTConfigurationProvider
implements XMLConfigurationProvider {
    private final Catalog catalog;

    public GWCGeoServerRESTConfigurationProvider(Catalog catalog) {
        this.catalog = catalog;
    }

    public XStream getConfiguredXStream(XStream xs) {
        xs.alias("GeoServerLayer", GeoServerTileLayer.class);
        xs.registerConverter((Converter)new RESTConverterHelper());
        return xs;
    }

    private final class RESTConverterHelper
    implements Converter {
        private RESTConverterHelper() {
        }

        public boolean canConvert(Class type) {
            return GeoServerTileLayer.class.equals((Object)type);
        }

        public GeoServerTileLayer unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String actualName;
            GeoServerTileLayerInfoImpl current = new GeoServerTileLayerInfoImpl();
            Class<GeoServerTileLayerInfo> type = GeoServerTileLayerInfo.class;
            GeoServerTileLayerInfo info = (GeoServerTileLayerInfo)context.convertAnother((Object)current, type);
            String id = info.getId();
            String name = info.getName();
            if (id != null && id.length() == 0) {
                id = null;
            }
            if (name != null && name.length() == 0) {
                name = null;
            }
            if (name == null) {
                throw new HttpErrorCodeException(400, "Layer name not provided");
            }
            LayerInfo layer = null;
            LayerGroupInfo layerGroup = null;
            if (id != null) {
                layer = GWCGeoServerRESTConfigurationProvider.this.catalog.getLayer(id);
                if (layer == null && (layerGroup = GWCGeoServerRESTConfigurationProvider.this.catalog.getLayerGroup(id)) == null) {
                    throw new HttpErrorCodeException(400, "No GeoServer Layer or LayerGroup exists with id '" + id + "'");
                }
            } else {
                layer = GWCGeoServerRESTConfigurationProvider.this.catalog.getLayerByName(name);
                if (layer == null && (layerGroup = GWCGeoServerRESTConfigurationProvider.this.catalog.getLayerGroupByName(name)) == null) {
                    throw new HttpErrorCodeException(404, "GeoServer Layer or LayerGroup '" + name + "' not found");
                }
            }
            String actualId = layer != null ? layer.getId() : layerGroup.getId();
            String string = actualName = layer != null ? GWC.tileLayerName(layer) : GWC.tileLayerName(layerGroup);
            if (id != null && !name.equals(actualName)) {
                throw new HttpErrorCodeException(400, "Layer with id '" + id + "' found but name does not match: '" + name + "'/'" + actualName + "'");
            }
            info.setId(actualId);
            info.setName(actualName);
            GridSetBroker gridsets = GWC.get().getGridSetBroker();
            GeoServerTileLayer tileLayer = layer != null ? new GeoServerTileLayer(layer, gridsets, info) : new GeoServerTileLayer(layerGroup, gridsets, info);
            return tileLayer;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            GeoServerTileLayer tileLayer = (GeoServerTileLayer)((Object)source);
            GeoServerTileLayerInfo info = tileLayer.getInfo();
            context.convertAnother((Object)info);
        }
    }
}

