/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geotools.util.logging.Logging;

public class CatalogStyleChangeListener
implements CatalogListener {
    private static Logger log = Logging.getLogger(CatalogStyleChangeListener.class);
    private final GWC mediator;

    public CatalogStyleChangeListener(GWC mediator) {
        this.mediator = mediator;
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
    }

    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        String newStyleName;
        CatalogInfo source = event.getSource();
        if (!(source instanceof StyleInfo)) {
            return;
        }
        List propertyNames = event.getPropertyNames();
        if (!propertyNames.contains("name")) {
            return;
        }
        int index = propertyNames.indexOf("name");
        String oldStyleName = (String)event.getOldValues().get(index);
        if (oldStyleName.equals(newStyleName = (String)event.getNewValues().get(index))) {
            return;
        }
        List<GeoServerTileLayer> affectedLayers = this.mediator.getTileLayersForStyle(oldStyleName);
        for (GeoServerTileLayer tl : affectedLayers) {
            GeoServerTileLayerInfo info;
            ImmutableSet<String> styleNames;
            LayerInfo layerInfo = tl.getLayerInfo();
            if (layerInfo == null || !(styleNames = (info = tl.getInfo()).cachedStyles()).contains((Object)oldStyleName)) continue;
            tl.resetParameterFilters();
            this.mediator.truncateByLayerAndStyle(tl.getName(), oldStyleName);
            HashSet<String> newStyles = new HashSet<String>((Collection<String>)styleNames);
            newStyles.remove(oldStyleName);
            newStyles.add(newStyleName);
            String defaultStyle = layerInfo.getDefaultStyle() == null ? null : layerInfo.getDefaultStyle().getName();
            TileLayerInfoUtil.setCachedStyles(info, defaultStyle, newStyles);
            this.mediator.save(tl);
        }
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        if (obj instanceof StyleInfo) {
            StyleInfo si = (StyleInfo)obj;
            this.handleStyleChange(si);
        }
    }

    private void handleStyleChange(StyleInfo modifiedStyle) {
        String styleName = modifiedStyle.getName();
        log.finer("Handling style modification: " + styleName);
        for (LayerInfo affectedLayer : this.mediator.getLayerInfosFor(modifiedStyle)) {
            String prefixedName = GWC.tileLayerName(affectedLayer);
            log.info("Truncating layer '" + prefixedName + "' due to a change in style '" + styleName + "'");
            this.mediator.truncateByLayerAndStyle(prefixedName, styleName);
        }
        for (LayerGroupInfo layerGroup : this.mediator.getLayerGroupsFor(modifiedStyle)) {
            String layerGroupName = GWC.tileLayerName(layerGroup);
            log.info("Truncating layer group '" + layerGroupName + "' due to a change in style '" + styleName + "'");
            this.mediator.truncate(layerGroupName);
        }
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
    }

    public void reloaded() {
    }
}

