/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerCatalog;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;

public class CatalogConfiguration
implements Configuration {
    private static final Logger LOGGER = Logging.getLogger(CatalogConfiguration.class);
    private TileLayerCatalog tileLayerCatalog;
    private Catalog geoServerCatalog;
    private GridSetBroker gridSetBroker;
    private final Map<String, GeoServerTileLayerInfo> pendingModications = Maps.newConcurrentMap();
    private final LoadingCache<String, GeoServerTileLayer> layerCache;
    private final Set<String> pendingDeletes = new CopyOnWriteArraySet<String>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public CatalogConfiguration(Catalog catalog, TileLayerCatalog tileLayerCatalog, GridSetBroker gridSetBroker) {
        Preconditions.checkNotNull((Object)catalog);
        Preconditions.checkNotNull((Object)tileLayerCatalog);
        Preconditions.checkNotNull((Object)gridSetBroker);
        this.tileLayerCatalog = tileLayerCatalog;
        this.geoServerCatalog = catalog;
        this.gridSetBroker = gridSetBroker;
        this.layerCache = CacheBuilder.newBuilder().concurrencyLevel(10).expireAfterAccess(10L, TimeUnit.MINUTES).initialCapacity(10).maximumSize(100L).build((CacheLoader)new TileLayerLoader(tileLayerCatalog));
    }

    public String getIdentifier() {
        return "GeoServer Catalog Configuration";
    }

    public ServiceInformation getServiceInformation() {
        return null;
    }

    public boolean isRuntimeStatsEnabled() {
        return true;
    }

    public List<GeoServerTileLayer> getTileLayers() {
        Iterable<GeoServerTileLayer> layers = this.getLayers();
        return Lists.newArrayList(layers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<GeoServerTileLayer> getLayers() {
        this.lock.readLock().lock();
        try {
            Set<String> layerIds = this.tileLayerCatalog.getLayerIds();
            Function<String, GeoServerTileLayer> lazyLayerFetch = new Function<String, GeoServerTileLayer>(){

                public GeoServerTileLayer apply(String layerId) {
                    return CatalogConfiguration.this.getTileLayerById(layerId);
                }
            };
            Iterable iterable = Iterables.transform(layerIds, (Function)lazyLayerFetch);
            return iterable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getTileLayerNames() {
        this.lock.readLock().lock();
        try {
            GeoServerTileLayerInfo old;
            Set<String> storedNames = this.tileLayerCatalog.getLayerNames();
            HashSet<String> names = null;
            if (!this.pendingDeletes.isEmpty()) {
                names = new HashSet<String>(storedNames);
                for (String string : this.pendingDeletes) {
                    old = this.tileLayerCatalog.getLayerById(string);
                    names.remove(old.getName());
                }
            }
            if (!this.pendingModications.isEmpty()) {
                for (Map.Entry entry : this.pendingModications.entrySet()) {
                    String newName;
                    String oldName;
                    old = this.tileLayerCatalog.getLayerById((String)entry.getKey());
                    if (old == null || Objects.equal((Object)(oldName = old.getName()), (Object)(newName = ((GeoServerTileLayerInfo)entry.getValue()).getName()))) continue;
                    if (names == null) {
                        names = new HashSet<String>(storedNames);
                    }
                    names.remove(oldName);
                    names.add(newName);
                }
            }
            Set<String> set = names == null ? storedNames : Collections.unmodifiableSet(names);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsLayer(String layerId) {
        Preconditions.checkNotNull((Object)layerId, (Object)"layer id is null");
        this.lock.readLock().lock();
        try {
            boolean hasLayer;
            if (this.pendingDeletes.contains(layerId)) {
                boolean bl = false;
                return bl;
            }
            Set<String> layerIds = this.tileLayerCatalog.getLayerIds();
            boolean bl = hasLayer = layerIds.contains(layerId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public GeoServerTileLayer getTileLayerById(String layerId) {
        GeoServerTileLayer layer;
        Preconditions.checkNotNull((Object)layerId, (Object)"layer id is null");
        try {
            layer = (GeoServerTileLayer)((Object)this.layerCache.get((Object)layerId));
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoServerTileLayer getTileLayer(String layerName) {
        String layerId;
        Preconditions.checkNotNull((Object)layerName, (Object)"layer name is null");
        this.lock.readLock().lock();
        try {
            layerId = this.getLayerId(layerName);
            if (layerId == null) {
                GeoServerTileLayer geoServerTileLayer = null;
                return geoServerTileLayer;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return this.getTileLayerById(layerId);
    }

    private String getLayerId(String layerName) {
        String layerId;
        String storedName = layerName;
        if (!this.pendingModications.isEmpty()) {
            for (GeoServerTileLayerInfo info : this.pendingModications.values()) {
                String name = info.getName();
                if (!name.equals(layerName)) continue;
                storedName = info.getName();
                break;
            }
        }
        if ((layerId = this.tileLayerCatalog.getLayerId(storedName)) == null || this.pendingDeletes.contains(layerId)) {
            return null;
        }
        GeoServerTileLayerInfo modifiedState = this.pendingModications.get(layerId);
        if (modifiedState != null && !layerName.equals(modifiedState.getName())) {
            return null;
        }
        return layerId;
    }

    private GeoServerTileLayerInfo getTileLayerInfoByName(String layerName) {
        GeoServerTileLayerInfo tileLayerInfo = null;
        if (!this.pendingModications.isEmpty()) {
            for (GeoServerTileLayerInfo info : this.pendingModications.values()) {
                String name = info.getName();
                if (!name.equals(layerName)) continue;
                tileLayerInfo = info;
                break;
            }
        }
        if (null == tileLayerInfo) {
            tileLayerInfo = this.tileLayerCatalog.getLayerByName(layerName);
            if (null == tileLayerInfo) {
                return null;
            }
            if (this.pendingDeletes.contains(tileLayerInfo.getId())) {
                return null;
            }
            if (this.pendingModications.containsKey(tileLayerInfo.getId())) {
                return null;
            }
        }
        return tileLayerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTileLayerCount() {
        int count = 0;
        this.lock.readLock().lock();
        try {
            Set<String> layerIds = this.tileLayerCatalog.getLayerIds();
            if (this.pendingDeletes.isEmpty()) {
                count = layerIds.size();
            } else {
                for (String layerId : layerIds) {
                    if (this.pendingDeletes.contains(layerId)) continue;
                    ++count;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initialize(GridSetBroker gridSetBroker) {
        this.lock.writeLock().lock();
        try {
            LOGGER.info("Initializing GWC configuration based on GeoServer's Catalog");
            this.gridSetBroker = gridSetBroker;
            this.layerCache.invalidateAll();
            this.tileLayerCatalog.initialize();
            for (String layerId : this.tileLayerCatalog.getLayerIds()) {
                String layerName = this.tileLayerCatalog.getLayerName(layerId);
                try {
                    this.getTileLayerById(layerId);
                }
                catch (Exception e) {
                    String msg = "GeoServer TileLayer named '" + layerName + "' with id '" + layerId + "' can't be loaded. " + "It will be removed from the configuration but you'll need" + " to delete its cache manually (if any). Original error message: " + e.getMessage();
                    LOGGER.log(Level.SEVERE, msg, e);
                    this.tileLayerCatalog.delete(layerId);
                }
            }
            LOGGER.info("GWC configuration based on GeoServer's Catalog loaded successfuly");
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return this.getTileLayerCount();
    }

    public boolean canSave(TileLayer tl) {
        return tl instanceof GeoServerTileLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addLayer(TileLayer tl) {
        Preconditions.checkNotNull((Object)tl);
        Preconditions.checkArgument((boolean)this.canSave(tl), (String)"Can't save TileLayer of type ", (Object[])new Object[]{tl.getClass()});
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)tl;
        Preconditions.checkNotNull((Object)tileLayer.getInfo(), (Object)"GeoServerTileLayerInfo is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getId(), (Object)"id is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getName(), (Object)"name is null");
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        this.lock.writeLock().lock();
        try {
            boolean pending = this.pendingModications.containsKey(info.getId());
            boolean exists = null != this.tileLayerCatalog.getLayerById(info.getId());
            boolean notExists = !pending && !exists;
            Preconditions.checkArgument((boolean)notExists, (Object)("A GeoServerTileLayer named '" + info.getName() + "' already exists"));
            if (this.pendingDeletes.remove(info.getId())) {
                LOGGER.finer("Adding a new layer " + info.getName() + " before saving the deleted one with the same name");
            }
            this.pendingModications.put(info.getId(), info);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void modifyLayer(TileLayer tl) throws NoSuchElementException {
        Preconditions.checkNotNull((Object)tl, (Object)"TileLayer is null");
        Preconditions.checkArgument((boolean)this.canSave(tl), (String)"Can't save TileLayer of type ", (Object[])new Object[]{tl.getClass()});
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)tl;
        Preconditions.checkNotNull((Object)tileLayer.getInfo(), (Object)"GeoServerTileLayerInfo is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getId(), (Object)"id is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getName(), (Object)"name is null");
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        this.lock.writeLock().lock();
        try {
            String layerId = info.getId();
            boolean exists = this.pendingModications.containsKey(layerId) || this.tileLayerCatalog.exists(layerId);
            Preconditions.checkArgument((boolean)exists, (Object)("No GeoServerTileLayer named '" + info.getName() + "' exists"));
            this.pendingModications.put(layerId, info);
            this.layerCache.invalidate((Object)layerId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLayer(String layerName) {
        Preconditions.checkNotNull((Object)layerName);
        this.lock.writeLock().lock();
        try {
            GeoServerTileLayerInfo tileLayerInfo = this.getTileLayerInfoByName(layerName);
            if (tileLayerInfo != null) {
                String layerId = tileLayerInfo.getId();
                this.pendingModications.remove(layerId);
                this.pendingDeletes.add(layerId);
                this.layerCache.invalidate((Object)layerId);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        GeoServerTileLayerInfo old;
        GWC mediator = GWC.get();
        HashSet deletedNames = Sets.newHashSet();
        LinkedList modifications = Lists.newLinkedList();
        this.lock.writeLock().lock();
        try {
            for (String deletedId : this.pendingDeletes) {
                try {
                    GeoServerTileLayerInfo info = this.tileLayerCatalog.delete(deletedId);
                    if (info == null) continue;
                    deletedNames.add(info.getName());
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.SEVERE, "Error deleting tile layer '" + deletedId + "'", e);
                }
            }
            for (GeoServerTileLayerInfo modified : this.pendingModications.values()) {
                try {
                    old = this.tileLayerCatalog.save(modified);
                    modifications.add(new GeoServerTileLayerInfo[]{old, modified});
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.SEVERE, "Error saving tile layer '" + modified.getName() + "'", e);
                }
            }
            this.pendingModications.clear();
            this.pendingDeletes.clear();
        }
        finally {
            this.lock.readLock().lock();
            this.lock.writeLock().unlock();
            try {
                for (String deletedLayerName : deletedNames) {
                    try {
                        mediator.layerRemoved(deletedLayerName);
                    }
                    catch (RuntimeException e) {
                        LOGGER.log(Level.SEVERE, "Error deleting tile layer '" + deletedLayerName + "'", e);
                    }
                }
                for (GeoServerTileLayerInfo[] oldNew : modifications) {
                    old = oldNew[0];
                    GeoServerTileLayerInfo modified = oldNew[1];
                    try {
                        if (old == null) {
                            String layerName = modified.getName();
                            mediator.layerAdded(layerName);
                            continue;
                        }
                        this.issueTileLayerInfoChangeNotifications(old, modified);
                    }
                    catch (RuntimeException e) {
                        LOGGER.log(Level.SEVERE, "Error issuing chanve events for tile layer " + modified, e);
                    }
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    private void issueTileLayerInfoChangeNotifications(GeoServerTileLayerInfo oldInfo, GeoServerTileLayerInfo newInfo) {
        HashSet<String> newFormats;
        boolean isRename;
        Preconditions.checkNotNull((Object)oldInfo);
        Preconditions.checkNotNull((Object)newInfo);
        Preconditions.checkNotNull((Object)oldInfo.getName());
        Preconditions.checkNotNull((Object)newInfo.getName());
        Preconditions.checkNotNull((Object)oldInfo.getId());
        Preconditions.checkNotNull((Object)newInfo.getId());
        Preconditions.checkArgument((boolean)Objects.equal((Object)oldInfo.getId(), (Object)newInfo.getId()));
        GWC mediator = GWC.get();
        String oldLayerName = oldInfo.getName();
        String layerName = newInfo.getName();
        boolean bl = isRename = !Objects.equal((Object)oldLayerName, (Object)layerName);
        if (isRename) {
            mediator.layerRenamed(oldLayerName, layerName);
        }
        Set<XMLGridSubset> oldGridSubsets = oldInfo.getGridSubsets();
        Set<XMLGridSubset> newGridSubsets = newInfo.getGridSubsets();
        Set<String> oldGridSubsetNames = this.gridsetNames(oldGridSubsets);
        Set<String> newGridSubsetNames = this.gridsetNames(newGridSubsets);
        HashSet<String> removedGridSets = new HashSet<String>(oldGridSubsetNames);
        removedGridSets.removeAll(newGridSubsetNames);
        for (String removedGridset : removedGridSets) {
            mediator.deleteCacheByGridSetId(layerName, removedGridset);
        }
        HashSet<String> oldFormats = new HashSet<String>(oldInfo.getMimeFormats());
        if (!((Object)oldFormats).equals(newFormats = new HashSet<String>(newInfo.getMimeFormats()))) {
            oldFormats.removeAll(newFormats);
            for (String removedFormat : oldFormats) {
                String styleName = null;
                String gridSetName = null;
                BoundingBox bounds = null;
                mediator.truncate(layerName, styleName, gridSetName, bounds, removedFormat);
            }
        }
        if (!newInfo.cachedStyles().equals(oldInfo.cachedStyles())) {
            HashSet<String> oldStyles = new HashSet<String>((Collection<String>)oldInfo.cachedStyles());
            HashSet<String> newStyles = new HashSet<String>((Collection<String>)newInfo.cachedStyles());
            oldStyles.removeAll(newStyles);
            for (String removedStyle : oldStyles) {
                mediator.truncateByLayerAndStyle(layerName, removedStyle);
            }
        }
    }

    private Set<String> gridsetNames(Set<XMLGridSubset> gridSubsets) {
        HashSet<String> names = new HashSet<String>();
        for (XMLGridSubset gridSubset : gridSubsets) {
            names.add(gridSubset.getGridSetName());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.writeLock().lock();
        try {
            this.layerCache.invalidateAll();
            this.tileLayerCatalog.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private final class TileLayerLoader
    extends CacheLoader<String, GeoServerTileLayer> {
        private final TileLayerCatalog tileLayerCatalog;

        private TileLayerLoader(TileLayerCatalog tileLayerCatalog) {
            this.tileLayerCatalog = tileLayerCatalog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GeoServerTileLayer load(String layerId) throws Exception {
            GeoServerTileLayer tileLayer = null;
            GridSetBroker gridSetBroker = CatalogConfiguration.this.gridSetBroker;
            CatalogConfiguration.this.lock.readLock().lock();
            try {
                if (CatalogConfiguration.this.pendingDeletes.contains(layerId)) {
                    throw new IllegalArgumentException("Tile layer '" + layerId + "' was deleted.");
                }
                GeoServerTileLayerInfo tileLayerInfo = (GeoServerTileLayerInfo)CatalogConfiguration.this.pendingModications.get(layerId);
                if (tileLayerInfo == null) {
                    tileLayerInfo = this.tileLayerCatalog.getLayerById(layerId);
                }
                if (tileLayerInfo == null) {
                    throw new IllegalArgumentException("GeoServerTileLayerInfo '" + layerId + "' does not exist.");
                }
                LayerInfo layerInfo = CatalogConfiguration.this.geoServerCatalog.getLayer(layerId);
                if (layerInfo != null) {
                    tileLayer = new GeoServerTileLayer(layerInfo, gridSetBroker, tileLayerInfo);
                } else {
                    LayerGroupInfo lgi = CatalogConfiguration.this.geoServerCatalog.getLayerGroup(layerId);
                    if (lgi != null) {
                        tileLayer = new GeoServerTileLayer(lgi, gridSetBroker, tileLayerInfo);
                    }
                }
            }
            finally {
                CatalogConfiguration.this.lock.readLock().unlock();
            }
            if (null == tileLayer) {
                throw new IllegalArgumentException("GeoServer layer or layer group '" + layerId + "' does not exist");
            }
            return tileLayer;
        }
    }
}

