/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.storage;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class GeometryRasterMaskBuilder {
    private static final double TILE_BUFFER_RATIO = 1.5;
    private static final double ENVELOPE_BUFFER_RATIO = 1.0;
    private static final Log logger = LogFactory.getLog(GeometryRasterMaskBuilder.class);
    private static final AffineTransform IDENTITY = new AffineTransform();
    private final BufferedImage[] byLevelMasks;
    private Graphics2D[] graphics;
    private Envelope aggregatedGeomBounds;
    private final MathTransform[] transformCache;
    private final GridSubset gridSubset;
    private final int maxMaskLevel;
    private int[] metaTilingFactors;

    public GeometryRasterMaskBuilder(GridSubset gridSubset, int[] metaTilingFactors, int maxMaskLevel) {
        this.gridSubset = gridSubset;
        this.metaTilingFactors = metaTilingFactors;
        this.maxMaskLevel = maxMaskLevel;
        int startLevel = this.getStartLevel();
        int numLevels = gridSubset.getCoverages().length;
        int endLevel = numLevels - 1;
        this.byLevelMasks = new BufferedImage[numLevels];
        this.transformCache = new MathTransform[numLevels];
        for (int level = startLevel; level <= endLevel; ++level) {
            BufferedImage mask;
            if (level > maxMaskLevel) {
                this.byLevelMasks[level] = null;
                continue;
            }
            long[] levelBounds = this.getGridCoverage(level);
            long tilesX = levelBounds[2] + 1L - levelBounds[0];
            long tilesY = levelBounds[3] + 1L - levelBounds[1];
            long numTiles = tilesX * tilesY;
            if (tilesX >= Integer.MAX_VALUE || tilesY >= Integer.MAX_VALUE || numTiles >= Integer.MAX_VALUE) {
                throw new IllegalStateException("Masking level " + level + " would produce a backing image of too many tiles!" + " Consider setting a lower maxMaskLevel ");
            }
            this.byLevelMasks[level] = mask = new BufferedImage((int)tilesX, (int)tilesY, 12);
        }
        this.createGraphics();
    }

    private long[] getGridCoverage(int level) {
        long[][] coveredBounds = this.gridSubset.getCoverages();
        coveredBounds = this.gridSubset.expandToMetaFactors(coveredBounds, this.metaTilingFactors);
        return coveredBounds[level];
    }

    public boolean hasTilesSet() {
        long[][] coveredBounds = this.getCoveredBounds();
        for (int i = 0; i < coveredBounds.length; ++i) {
            if (coveredBounds[i] == null) continue;
            return true;
        }
        return false;
    }

    public void setMasksForGeometry(Geometry geom) {
        if (geom == null || geom.isEmpty()) {
            return;
        }
        int startLevel = this.getStartLevel();
        int maxLevel = startLevel + this.getNumLevels() - 1;
        int endLevel = Math.min(maxLevel, this.maxMaskLevel);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Geom: " + geom));
        }
        if (this.aggregatedGeomBounds == null) {
            this.aggregatedGeomBounds = new Envelope(geom.getEnvelopeInternal());
        } else {
            this.aggregatedGeomBounds.expandToInclude(geom.getEnvelopeInternal());
        }
        for (int level = startLevel; level <= endLevel; ++level) {
            Geometry geometryInGridCrs = this.transformToGridCrs(geom, level);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Geom in grid CRS: " + geometryInGridCrs));
            }
            Geometry bufferedGeomInGridCrs = geometryInGridCrs.buffer(1.5);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Buffered Geom in grid CRS: " + bufferedGeomInGridCrs));
            }
            boolean generalize = false;
            LiteShape shape = new LiteShape(bufferedGeomInGridCrs, IDENTITY, generalize);
            Graphics2D graphics = this.getGraphics(level);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(Color.WHITE);
            graphics.fill((Shape)shape);
        }
    }

    private Geometry transformToGridCrs(Geometry geometryInLayerCrs, int zoomLevel) {
        Geometry geomInGridCrs;
        MathTransform worldToGrid;
        if (this.transformCache[zoomLevel] == null) {
            long[] coverage = this.getGridCoverage(zoomLevel);
            BoundingBox coverageBounds = this.gridSubset.boundsFromRectangle(coverage);
            this.transformCache[zoomLevel] = worldToGrid = this.getWorldToGridTransform(coverageBounds, coverage);
        } else {
            worldToGrid = this.transformCache[zoomLevel];
        }
        try {
            geomInGridCrs = JTS.transform((Geometry)geometryInLayerCrs, (MathTransform)worldToGrid);
        }
        catch (MismatchedDimensionException e) {
            throw new IllegalArgumentException(e);
        }
        catch (TransformException e) {
            throw new IllegalArgumentException(e);
        }
        return geomInGridCrs;
    }

    private MathTransform getWorldToGridTransform(BoundingBox coverageBounds, long[] coverage) {
        MathTransform worldToScreen;
        Envelope2D genvelope = new Envelope2D();
        double x = coverageBounds.getMinX();
        double y = coverageBounds.getMinY();
        double width = coverageBounds.getWidth();
        double height = coverageBounds.getHeight();
        genvelope.setFrame(x, y, width, height);
        Rectangle paintArea = new Rectangle();
        int x2 = (int)coverage[0];
        int y2 = (int)coverage[1];
        int width2 = (int)(1L + coverage[2] - (long)x2);
        int height2 = (int)(1L + coverage[3] - (long)y2);
        paintArea.setBounds(x2, y2, width2, height2);
        GridToEnvelopeMapper mapper = new GridToEnvelopeMapper();
        mapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        mapper.setGridRange((GridEnvelope)new GridEnvelope2D(paintArea));
        mapper.setEnvelope((org.opengis.geometry.Envelope)genvelope);
        mapper.setSwapXY(false);
        try {
            worldToScreen = mapper.createTransform().inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
        return worldToScreen;
    }

    private Graphics2D getGraphics(int level) {
        return this.graphics[level];
    }

    public void disposeGraphics() {
        if (this.graphics == null) {
            return;
        }
        int numLevels = this.getNumLevels();
        for (int level = 0; level < numLevels; ++level) {
            if (this.graphics[level] == null) continue;
            this.graphics[level].dispose();
        }
        this.graphics = null;
    }

    public void createGraphics() {
        int numLevels = this.getNumLevels();
        this.graphics = new Graphics2D[numLevels];
        for (int level = 0; level < numLevels; ++level) {
            BufferedImage bufferedImage = this.byLevelMasks[level];
            if (bufferedImage == null) continue;
            this.graphics[level] = bufferedImage.createGraphics();
        }
    }

    public int getStartLevel() {
        return 0;
    }

    public int getNumLevels() {
        return this.byLevelMasks.length;
    }

    public synchronized long[][] getCoveredBounds() {
        long[][] coveredBounds = new long[this.getNumLevels()][4];
        for (int i = 0; i < coveredBounds.length; ++i) {
            coveredBounds[i] = this.getCoveredBounds(i);
        }
        return coveredBounds;
    }

    public synchronized long[] getCoveredBounds(int level) {
        BoundingBox expandedBounds;
        if (this.aggregatedGeomBounds == null) {
            return null;
        }
        long[] coverage = this.getGridCoverage(level);
        BoundingBox coverageBounds = this.gridSubset.boundsFromRectangle(coverage);
        MathTransform worldToGrid = this.getWorldToGridTransform(coverageBounds, coverage);
        try {
            Envelope coveredLevelEnvelope = JTS.transform((Envelope)this.aggregatedGeomBounds, (MathTransform)worldToGrid);
            Geometry bufferedEnvelopeInGridCrs = JTS.toGeometry((Envelope)coveredLevelEnvelope).buffer(1.0);
            coveredLevelEnvelope = bufferedEnvelopeInGridCrs.getEnvelopeInternal();
            MathTransform gridToWorld = worldToGrid.inverse();
            Envelope bufferedEnvelope = JTS.transform((Envelope)coveredLevelEnvelope, (MathTransform)gridToWorld);
            expandedBounds = new BoundingBox(bufferedEnvelope.getMinX(), bufferedEnvelope.getMinY(), bufferedEnvelope.getMaxX(), bufferedEnvelope.getMaxY());
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        long[] coveredBounds = this.gridSubset.getCoverageIntersection(level, expandedBounds);
        return coveredBounds;
    }

    public BufferedImage[] getByLevelMasks() {
        int numMaskedLevels = Math.min(this.getNumLevels(), this.maxMaskLevel + 1);
        BufferedImage[] maskedLevels = new BufferedImage[numMaskedLevels];
        for (int level = 0; level < numMaskedLevels; ++level) {
            maskedLevels[level] = this.byLevelMasks[level];
        }
        return maskedLevels;
    }
}

