/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.georss.GeoRSSReader;
import org.geowebcache.georss.StaxGeoRSSReader;
import org.geowebcache.util.HttpClientBuilder;

class GeoRSSReaderFactory {
    private static final Log log = LogFactory.getLog(GeoRSSReaderFactory.class);

    GeoRSSReaderFactory() {
    }

    public GeoRSSReader createReader(URL url, String username, String password) throws IOException {
        String contentEncoding;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating GeoRSS reader for URL " + url.toExternalForm() + " with user " + username));
        }
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setHttpCredentials(username, password, url);
        builder.setBackendTimeout(120);
        HttpClient httpClient = builder.buildClient();
        GetMethod getMethod = new GetMethod(url.toString());
        if (builder.isDoAuthentication()) {
            getMethod.setDoAuthentication(true);
            httpClient.getParams().setAuthenticationPreemptive(true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing HTTP GET requesr for feed URL " + url.toExternalForm()));
        }
        httpClient.executeMethod((HttpMethod)getMethod);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Building GeoRSS reader out of URL response");
        }
        if ((contentEncoding = getMethod.getResponseCharSet()) == null) {
            contentEncoding = "UTF-8";
        }
        InputStream in = getMethod.getResponseBodyAsStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, contentEncoding));
        if (log.isDebugEnabled()) {
            log.debug((Object)"GeoRSS reader created, returning.");
        }
        return this.createReader(reader);
    }

    public GeoRSSReader createReader(Reader feed) throws IOException {
        StaxGeoRSSReader reader;
        try {
            reader = new StaxGeoRSSReader(feed);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
        return reader;
    }
}

