/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class GeoTIFFCoverageResponseDelegate
implements CoverageResponseDelegate {
    private static final Set<String> FORMATS = new HashSet<String>(Arrays.asList("image/tiff", "image/tiff;subtype=\"geotiff\"", "image/geotiff"));
    private GridCoverage2D sourceCoverage;
    private static final GeoTiffFormat format = new GeoTiffFormat();
    public static final String GEOTIFF_CONTENT_TYPE = "image/tiff;subtype=\"geotiff\"";

    @Override
    public boolean canProduce(String outputFormat) {
        return outputFormat != null && (outputFormat.equalsIgnoreCase("geotiff") || FORMATS.contains(outputFormat.toLowerCase()));
    }

    @Override
    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.sourceCoverage = coverage;
    }

    @Override
    public String getMimeFormatFor(String outputFormat) {
        if (this.canProduce(outputFormat)) {
            return GEOTIFF_CONTENT_TYPE;
        }
        return null;
    }

    @Override
    public String getContentType() {
        return GEOTIFF_CONTENT_TYPE;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public String getContentDisposition() {
        return "attachment;filename=" + this.sourceCoverage.getName() + ".tif";
    }

    @Override
    public String getFileExtension() {
        return "tif";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(OutputStream output) throws ServiceException, IOException {
        if (this.sourceCoverage == null) {
            throw new IllegalStateException("It seems prepare() has not been called or has not succeed");
        }
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        wp.setCompressionMode(2);
        wp.setCompressionType("LZW");
        wp.setCompressionQuality(0.75f);
        wp.setTilingMode(2);
        wp.setTiling(256, 256);
        ParameterValueGroup writerParams = format.getWriteParameters();
        writerParams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
        GeoTiffWriter writer = (GeoTiffWriter)format.getWriter((Object)output);
        try {
            if (writer != null) {
                writer.write((GridCoverage)this.sourceCoverage, writerParams.values().toArray(new GeneralParameterValue[1]));
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.dispose();
                }
            }
            catch (Throwable e) {}
            this.sourceCoverage.dispose(false);
            this.sourceCoverage = null;
        }
    }
}

