/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.util.ArrayList;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WCSInfoImpl;
import org.geotools.util.Version;

public class WCSXStreamLoader
extends XStreamServiceLoader<WCSInfo> {
    public WCSXStreamLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader, "wcs");
    }

    public Class<WCSInfo> getServiceClass() {
        return WCSInfo.class;
    }

    protected WCSInfo createServiceFromScratch(GeoServer gs) {
        WCSInfoImpl wcs = new WCSInfoImpl();
        wcs.setId("wcs");
        wcs.setName("WCS");
        return wcs;
    }

    protected void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        super.initXStreamPersister(xp, gs);
        xp.getXStream().alias("wcs", WCSInfo.class, WCSInfoImpl.class);
    }

    protected WCSInfo initialize(WCSInfo service) {
        super.initialize((ServiceInfo)service);
        if (service.getExceptionFormats() == null) {
            ((WCSInfoImpl)service).setExceptionFormats(new ArrayList());
        }
        if (service.getVersions().isEmpty()) {
            service.getVersions().add(new Version("1.0.0"));
            service.getVersions().add(new Version("1.1.1"));
        }
        return service;
    }
}

