/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.TimeConsistencyPolicy;
import com.sleepycat.je.rep.utilint.BinaryProtocolStatDefinition;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.StatGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepUtils {
    public static final boolean DEBUG_PRINT_THREAD = true;
    public static final boolean DEBUG_PRINT_TIME = true;
    private static final Map<String, ConsistencyPolicyFormat<?>> consistencyPolicyFormats = new HashMap();
    public static final SocketChannel CHANNEL_EOF_MARKER;

    public static void addConsistencyPolicyFormat(String name, ConsistencyPolicyFormat<?> format) {
        consistencyPolicyFormats.put(name.toUpperCase(Locale.ENGLISH), format);
    }

    public static String getPropertyString(ReplicaConsistencyPolicy policy) throws IllegalArgumentException {
        ConsistencyPolicyFormat<?> format = consistencyPolicyFormats.get(policy.getName().toUpperCase());
        if (format == null) {
            throw new IllegalArgumentException("Policy: " + policy + " cannot be used as a property");
        }
        return format.policyToString(policy);
    }

    public static ReplicaConsistencyPolicy getReplicaConsistencyPolicy(String propertyValue) throws IllegalArgumentException {
        String upperCasePropertyValue = propertyValue.toUpperCase(Locale.ENGLISH);
        for (Map.Entry<String, ConsistencyPolicyFormat<?>> entry : consistencyPolicyFormats.entrySet()) {
            String name = entry.getKey();
            if (!upperCasePropertyValue.equals(name) && (!upperCasePropertyValue.startsWith(name) || upperCasePropertyValue.length() <= name.length() || Character.isLetter(upperCasePropertyValue.charAt(name.length())))) continue;
            ConsistencyPolicyFormat<?> format = entry.getValue();
            return format.stringToPolicy(propertyValue);
        }
        throw new IllegalArgumentException("Invalid consistency policy: " + propertyValue);
    }

    public static void shutdownChannel(NamedChannel namedChannel) {
        if (namedChannel == null) {
            return;
        }
        SocketChannel channel = namedChannel.getChannel();
        if (channel == null) {
            return;
        }
        try {
            channel.socket().shutdownInput();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            channel.socket().shutdownOutput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SocketChannel openBlockingChannel(InetSocketAddress addr, boolean tcpNoDelay, int timeout) throws IOException {
        SocketChannel channel = SocketChannel.open();
        Socket socket = channel.socket();
        channel.configureBlocking(true);
        socket.setTcpNoDelay(tcpNoDelay);
        socket.setSoTimeout(timeout);
        socket.connect(addr);
        return channel;
    }

    public static Throwable chainExceptionCause(Throwable newt, Throwable oldt) {
        Throwable tail = newt;
        while (true) {
            if (tail.getCause() == null) break;
            tail = newt.getCause();
        }
        tail.initCause(oldt);
        return newt;
    }

    public static String writeTimesString(StatGroup stats) {
        long nMessagesWritten = stats.getLong(BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN);
        long nWriteNanos = stats.getLong(BinaryProtocolStatDefinition.N_WRITE_NANOS);
        long avgWriteNanos = nMessagesWritten <= 0L ? 0L : nWriteNanos / nMessagesWritten;
        return String.format(" write time: %, dms Avg write time: %,dus", nWriteNanos / 1000000L, avgWriteNanos / 1000L);
    }

    static {
        RepUtils.addConsistencyPolicyFormat("TimeConsistencyPolicy", new TimeConsistencyPolicyFormat());
        RepUtils.addConsistencyPolicyFormat("NoConsistencyRequiredPolicy", new NoConsistencyRequiredPolicyFormat());
        try {
            CHANNEL_EOF_MARKER = SocketChannel.open();
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MapOver<R, E> {
        final Collection<E> c;

        MapOver(Collection<E> c) {
            this.c = c;
        }

        List<R> run() {
            LinkedList<R> l = new LinkedList<R>();
            for (E e : this.c) {
                l.add(this.fun(e));
            }
            return l;
        }

        abstract R fun(E var1);
    }

    public static class ExceptionAwareCountDownLatch
    extends CountDownLatch {
        final EnvironmentImpl envImpl;
        private final AtomicReference<Exception> terminatingException = new AtomicReference();

        public ExceptionAwareCountDownLatch(EnvironmentImpl envImpl, int count) {
            super(count);
            this.envImpl = envImpl;
        }

        public void releaseAwait(Exception exception) {
            this.terminatingException.compareAndSet(null, exception);
            this.countDown();
            assert (this.getCount() == 0L);
        }

        public boolean awaitOrException(long timeout, TimeUnit unit) throws InterruptedException, DatabaseException {
            boolean done = super.await(timeout, unit);
            if (!done) {
                return done;
            }
            Exception exception = this.terminatingException.get();
            if (exception != null) {
                if (exception instanceof DatabaseException) {
                    throw (DatabaseException)exception;
                }
                throw EnvironmentFailureException.unexpectedException(this.envImpl, exception);
            }
            return done;
        }

        public void awaitOrException() throws InterruptedException, DatabaseException {
            this.awaitOrException(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }

        @Deprecated
        public boolean await(long timeout, TimeUnit unit) {
            throw EnvironmentFailureException.unexpectedState("Use awaitOrException() instead of await");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoConsistencyRequiredPolicyFormat
    implements ConsistencyPolicyFormat<NoConsistencyRequiredPolicy> {
        private NoConsistencyRequiredPolicyFormat() {
        }

        @Override
        public String policyToString(NoConsistencyRequiredPolicy policy) {
            return "NoConsistencyRequiredPolicy";
        }

        @Override
        public NoConsistencyRequiredPolicy stringToPolicy(String string) {
            return NoConsistencyRequiredPolicy.NO_CONSISTENCY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeConsistencyPolicyFormat
    implements ConsistencyPolicyFormat<TimeConsistencyPolicy> {
        private TimeConsistencyPolicyFormat() {
        }

        @Override
        public String policyToString(TimeConsistencyPolicy policy) {
            return policy.getName() + "(" + policy.getPermissibleLag(TimeUnit.MILLISECONDS) + " ms," + policy.getTimeout(TimeUnit.MILLISECONDS) + " ms)";
        }

        @Override
        public TimeConsistencyPolicy stringToPolicy(String string) {
            String args = string.substring("TimeConsistencyPolicy".length());
            if (args.charAt(0) != '(' || args.charAt(args.length() - 1) != ')') {
                throw new IllegalArgumentException("Incorrect property value syntax: " + string);
            }
            int arg1 = args.indexOf(44);
            if (arg1 == -1) {
                throw new IllegalArgumentException("Incorrect property value syntax: " + string);
            }
            int lag = PropUtil.parseDuration(args.substring(1, arg1));
            int arg2 = args.indexOf(41);
            if (arg2 == -1) {
                throw new IllegalArgumentException("Incorrect property value syntax: " + string);
            }
            int timeout = PropUtil.parseDuration(args.substring(arg1 + 1, arg2));
            return new TimeConsistencyPolicy(lag, TimeUnit.MILLISECONDS, timeout, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConsistencyPolicyFormat<T extends ReplicaConsistencyPolicy> {
        public String policyToString(T var1);

        public T stringToPolicy(String var1);
    }
}

