/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.property;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class PropertyEditorFormComponent
extends FormComponentPanel<Properties> {
    ListView<Tuple> listView;

    public PropertyEditorFormComponent(String id) {
        super(id);
        this.init();
    }

    public PropertyEditorFormComponent(String id, IModel<Properties> model) {
        super(id, model);
        this.init();
    }

    void init() {
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.listView = new ListView<Tuple>("list"){

            protected void populateItem(ListItem<Tuple> item) {
                item.setModel((IModel)new CompoundPropertyModel(item.getModelObject()));
                item.add(new Component[]{new TextField("key").add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){

                    protected void onUpdate(AjaxRequestTarget target) {
                    }
                }})});
                item.add(new Component[]{new TextField("value").add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){

                    protected void onUpdate(AjaxRequestTarget target) {
                    }
                }})});
                item.add(new Component[]{new AjaxLink<Tuple>("remove", item.getModel()){

                    public void onClick(AjaxRequestTarget target) {
                        List l = (List)PropertyEditorFormComponent.this.listView.getDefaultModelObject();
                        l.remove(this.getModelObject());
                        target.addComponent((Component)container);
                    }
                }});
            }
        };
        container.add(new Component[]{this.listView});
        this.add(new Component[]{new AjaxLink("add"){

            public void onClick(AjaxRequestTarget target) {
                ((List)PropertyEditorFormComponent.this.listView.getDefaultModelObject()).add(new Tuple());
                target.addComponent((Component)container);
            }
        }});
    }

    List<Tuple> tuples() {
        Properties props = (Properties)this.getModelObject();
        if (props == null) {
            props = new Properties();
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            tuples.add(new Tuple((String)e.getKey(), (String)e.getValue()));
        }
        Collections.sort(tuples);
        return tuples;
    }

    protected void onBeforeRender() {
        this.listView.setModel((IModel)new ListModel(this.tuples()));
        super.onBeforeRender();
    }

    protected void convertInput() {
        for (ListItem item : this.listView) {
            ((FormComponent)item.get("key")).updateModel();
            ((FormComponent)item.get("value")).updateModel();
        }
        Properties props = (Properties)this.getModelObject();
        if (props == null) {
            props = new Properties();
        }
        props.clear();
        for (Tuple t : this.listView.getModelObject()) {
            props.put(t.getKey(), t.getValue());
        }
        this.setConvertedInput(props);
    }

    static class Tuple
    implements Serializable,
    Comparable<Tuple> {
        private static final long serialVersionUID = 1L;
        private String key;
        private String value;

        public Tuple() {
        }

        public Tuple(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public int compareTo(Tuple o) {
            return this.key != null ? this.key.compareTo(o.key) : (o.key == null ? 0 : -1);
        }
    }
}

