/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.model.IModel;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WKTToCRSModel
implements IModel {
    private static final Logger LOGGER = Logging.getLogger(WKTToCRSModel.class);
    IModel srsModel;

    public WKTToCRSModel(IModel srsModel) {
        this.srsModel = srsModel;
    }

    public Object getObject() {
        String wkt = (String)this.srsModel.getObject();
        try {
            return CRS.parseWKT((String)wkt);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setObject(Object object) {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)object;
        try {
            this.srsModel.setObject((Object)crs.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to lookup the SRS code for " + crs);
            this.srsModel.setObject(null);
        }
    }

    public void detach() {
        this.srsModel.detach();
    }
}

