/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.wicket.DecimalTextField;

public class PointPanel
extends FormComponentPanel<Point> {
    private static final long serialVersionUID = -1046819530873258172L;
    GeometryFactory gf = new GeometryFactory();
    protected Label xLabel;
    protected Label yLabel;
    protected Double x;
    protected Double y;
    protected DecimalTextField xInput;
    protected DecimalTextField yInput;

    public PointPanel(String id) {
        super(id, (IModel)new Model(null));
        this.initComponents();
    }

    public PointPanel(String id, Point p) {
        this(id, (IModel<Point>)new Model((Serializable)p));
    }

    public PointPanel(String id, IModel<Point> model) {
        super(id, model);
        this.initComponents();
    }

    public void setLabelsVisibility(boolean visible) {
        this.xLabel.setVisible(visible);
        this.yLabel.setVisible(visible);
    }

    void initComponents() {
        this.updateFields();
        Component[] componentArray = new Component[1];
        this.xLabel = new Label("xL", (IModel)new ResourceModel("x"));
        componentArray[0] = this.xLabel;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.yLabel = new Label("yL", (IModel)new ResourceModel("y"));
        componentArray2[0] = this.yLabel;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.xInput = new DecimalTextField("x", (IModel<Double>)new PropertyModel((Object)this, "x"));
        componentArray3[0] = this.xInput;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.yInput = new DecimalTextField("y", (IModel<Double>)new PropertyModel((Object)this, "y"));
        componentArray4[0] = this.yInput;
        this.add(componentArray4);
    }

    protected void onBeforeRender() {
        this.updateFields();
        super.onBeforeRender();
    }

    private void updateFields() {
        Point p = (Point)this.getModelObject();
        if (p != null) {
            this.x = p.getX();
            this.y = p.getY();
        }
    }

    public PointPanel setReadOnly(final boolean readOnly) {
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                component.setEnabled(!readOnly);
                return null;
            }
        });
        return this;
    }

    protected void convertInput() {
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                ((TextField)component).processInput();
                return null;
            }
        });
        if (this.x != null && this.y != null) {
            this.setConvertedInput(this.gf.createPoint(new Coordinate(this.x.doubleValue(), this.y.doubleValue())));
        } else {
            this.setConvertedInput(null);
        }
    }

    protected void onModelChanged() {
        this.updateFields();
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                ((TextField)component).clearInput();
                return CONTINUE_TRAVERSAL;
            }
        });
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.xInput.setMaximumFractionDigits(maximumFractionDigits);
        this.yInput.setMaximumFractionDigits(maximumFractionDigits);
    }
}

