/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerPagingNavigator;
import org.geoserver.web.wicket.ParamResourceModel;

public abstract class GeoServerTablePanel<T>
extends Panel {
    private static final int DEFAULT_ITEMS_PER_PAGE = 25;
    TextField filter;
    DataView dataView;
    WebMarkupContainer listContainer;
    PagerDelegate pagerDelegate;
    Pager navigatorTop;
    Pager navigatorBottom;
    GeoServerDataProvider<T> dataProvider;
    Form filterForm;
    CheckBox selectAll;
    AjaxButton hiddenSubmit;
    boolean sortable = true;
    boolean[] selection;
    boolean selectAllValue;

    public GeoServerTablePanel(String id, GeoServerDataProvider<T> dataProvider) {
        this(id, dataProvider, false);
    }

    public GeoServerTablePanel(String id, final GeoServerDataProvider<T> dataProvider, final boolean selectable) {
        super(id);
        this.dataProvider = dataProvider;
        this.selection = new boolean[25];
        this.listContainer = new WebMarkupContainer("listContainer");
        this.filterForm = new Form("filterForm"){

            public void renderHead(IHeaderResponse response) {
                if (this.isRootForm()) {
                    return;
                }
                String markupId = GeoServerTablePanel.this.filterForm.getMarkupId();
                String js = "if (Wicket.Browser.isSafari() || Wicket.Browser.isIE()) {n = document.getElementById('" + markupId + "'); " + "while (n.nodeName.toLowerCase() != 'form') { n = n.parentElement; }; " + "n.setAttribute('onsubmit', \"return document.getElementById('" + GeoServerTablePanel.this.hiddenSubmit.getMarkupId() + "').onclick();\");" + "}";
                response.renderOnLoadJavascript(js);
            }
        };
        this.filterForm.setOutputMarkupId(true);
        this.add(new Component[]{this.filterForm});
        Component[] componentArray = new Component[1];
        this.filter = new TextField("filter", (IModel)new Model());
        componentArray[0] = this.filter;
        this.filterForm.add(componentArray);
        this.filter.add(new IBehavior[]{new SimpleAttributeModifier("title", (CharSequence)String.valueOf(new ResourceModel("GeoServerTablePanel.search", "Search").getObject()))});
        Component[] componentArray2 = new Component[1];
        this.hiddenSubmit = this.hiddenSubmit();
        componentArray2[0] = this.hiddenSubmit;
        this.filterForm.add(componentArray2);
        this.filterForm.setDefaultButton((IFormSubmittingComponent)this.hiddenSubmit);
        this.listContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.listContainer});
        this.dataView = new DataView("items", (IDataProvider)dataProvider){

            protected void populateItem(Item item) {
                final IModel itemModel = item.getModel();
                item.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)(item.getIndex() % 2 == 0 ? "even" : "odd"))});
                WebMarkupContainer cnt = new WebMarkupContainer("selectItemContainer");
                cnt.add(new Component[]{GeoServerTablePanel.this.selectOneCheckbox(item)});
                cnt.setVisible(selectable);
                item.add(new Component[]{cnt});
                ListView items = new ListView("itemProperties", dataProvider.getVisibleProperties()){

                    protected void populateItem(ListItem item) {
                        GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)item.getModelObject();
                        Component component = GeoServerTablePanel.this.getComponentForProperty("component", itemModel, property);
                        if (component == null) {
                            component = new Label("component", property.getModel(itemModel));
                        } else if (!"component".equals(component.getId())) {
                            throw new IllegalArgumentException("getComponentForProperty asked to build a component with id = 'component' for property '" + property.getName() + "', but got '" + component.getId() + "' instead");
                        }
                        item.add(new Component[]{component});
                        GeoServerTablePanel.this.onPopulateItem(property, item);
                    }
                };
                items.setReuseItems(true);
                item.add(new Component[]{items});
            }
        };
        this.dataView.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        this.listContainer.add(new Component[]{this.dataView});
        WebMarkupContainer cnt = new WebMarkupContainer("selectAllContainer");
        Component[] componentArray3 = new Component[1];
        this.selectAll = this.selectAllCheckbox();
        componentArray3[0] = this.selectAll;
        cnt.add(componentArray3);
        cnt.setVisible(selectable);
        this.listContainer.add(new Component[]{cnt});
        this.listContainer.add(new Component[]{new ListView("sortableLinks", dataProvider.getVisibleProperties()){

            protected void populateItem(ListItem item) {
                GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)item.getModelObject();
                IModel titleModel = GeoServerTablePanel.this.getPropertyTitle(property);
                if (GeoServerTablePanel.this.sortable && property.getComparator() != null) {
                    Fragment f = new Fragment("header", "sortableHeader", (MarkupContainer)item);
                    AjaxLink link = GeoServerTablePanel.this.sortLink(dataProvider, item);
                    link.add(new Component[]{new Label("label", titleModel)});
                    f.add(new Component[]{link});
                    item.add(new Component[]{f});
                } else {
                    item.add(new Component[]{new Label("header", titleModel)});
                }
            }
        }});
        this.dataView.setItemsPerPage(25);
        this.pagerDelegate = new PagerDelegate();
        Component[] componentArray4 = new Component[1];
        this.navigatorTop = new Pager("navigatorTop");
        componentArray4[0] = this.navigatorTop;
        this.filterForm.add(componentArray4);
        this.navigatorTop.setOutputMarkupId(true);
        Component[] componentArray5 = new Component[1];
        this.navigatorBottom = new Pager("navigatorBottom");
        componentArray5[0] = this.navigatorBottom;
        this.add(componentArray5);
        this.navigatorBottom.setOutputMarkupId(true);
    }

    public void setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.dataView.setItemReuseStrategy(strategy);
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public Component getTopPager() {
        return this.navigatorTop;
    }

    public Component getBottomPager() {
        return this.navigatorBottom;
    }

    public GeoServerDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    protected void onSelectionUpdate(AjaxRequestTarget target) {
    }

    IModel getPropertyTitle(GeoServerDataProvider.Property<T> property) {
        String pageName = this.getPage().getClass().getSimpleName();
        ResourceModel resMod = new ResourceModel("th." + property.getName(), property.getName());
        return resMod;
    }

    public int getNumSelected() {
        int selected = 0;
        for (boolean itemSelected : this.selection) {
            if (!itemSelected) continue;
            ++selected;
        }
        return selected;
    }

    public List<T> getSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        for (Item item : this.dataView) {
            if (this.selection[i]) {
                result.add(item.getModelObject());
            }
            ++i;
        }
        return result;
    }

    CheckBox selectAllCheckbox() {
        CheckBox sa = new CheckBox("selectAll", (IModel)new PropertyModel((Object)this, "selectAllValue"));
        sa.setOutputMarkupId(true);
        sa.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onclick"){

            protected void onUpdate(AjaxRequestTarget target) {
                GeoServerTablePanel.this.setSelection(GeoServerTablePanel.this.selectAllValue);
                target.addComponent(this.getComponent());
                target.addComponent((Component)GeoServerTablePanel.this.listContainer);
                GeoServerTablePanel.this.onSelectionUpdate(target);
            }
        }});
        return sa;
    }

    protected CheckBox selectOneCheckbox(Item item) {
        CheckBox cb = new CheckBox("selectItem", (IModel)new SelectionModel(item.getIndex()));
        cb.setOutputMarkupId(true);
        cb.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onclick"){

            protected void onUpdate(AjaxRequestTarget target) {
                if (Boolean.FALSE.equals(this.getComponent().getDefaultModelObject())) {
                    GeoServerTablePanel.this.selectAllValue = false;
                    target.addComponent((Component)GeoServerTablePanel.this.selectAll);
                }
                GeoServerTablePanel.this.onSelectionUpdate(target);
            }
        }});
        return cb;
    }

    void setSelection(boolean selected) {
        for (int i = 0; i < this.selection.length; ++i) {
            this.selection[i] = selected;
        }
        this.selectAllValue = selected;
    }

    public void clearSelection() {
        this.setSelection(false);
    }

    public void selectAll() {
        this.setSelection(true);
    }

    public void selectObject(T object) {
        int i = 0;
        for (Item item : this.dataView) {
            if (object.equals(item.getModelObject())) {
                this.selection[i] = true;
                return;
            }
            ++i;
        }
    }

    public void selectIndex(int i) {
        this.selection[i] = true;
    }

    AjaxButton hiddenSubmit() {
        return new AjaxButton("submit"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                GeoServerTablePanel.this.updateFilter(target, GeoServerTablePanel.this.filter.getDefaultModelObjectAsString());
            }
        };
    }

    public void setItemsPerPage(int items) {
        this.dataView.setItemsPerPage(items);
        this.selection = new boolean[items];
    }

    public GeoServerTablePanel<T> setFilterable(boolean filterable) {
        this.filterForm.setVisible(filterable);
        return this;
    }

    AjaxLink sortLink(final GeoServerDataProvider<T> dataProvider, ListItem item) {
        return new AjaxLink("link", item.getModel()){

            public void onClick(AjaxRequestTarget target) {
                SortParam currSort = dataProvider.getSort();
                GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)this.getModelObject();
                if (currSort == null || !property.getName().equals(currSort.getProperty())) {
                    dataProvider.setSort(new SortParam(property.getName(), true));
                } else {
                    dataProvider.setSort(new SortParam(property.getName(), !currSort.isAscending()));
                }
                GeoServerTablePanel.this.setSelection(false);
                target.addComponent((Component)GeoServerTablePanel.this.listContainer);
            }
        };
    }

    private void updateFilter(AjaxRequestTarget target, String flatKeywords) {
        if ("".equals(flatKeywords)) {
            this.dataProvider.setKeywords(null);
            this.filter.setModelObject((Object)"");
            this.dataView.setCurrentPage(0);
        } else {
            String[] keywords = flatKeywords.split("\\s+");
            this.dataProvider.setKeywords(keywords);
            this.dataView.setCurrentPage(0);
        }
        this.navigatorTop.updateMatched();
        this.navigatorBottom.updateMatched();
        this.setSelection(false);
        target.addComponent((Component)this.listContainer);
        target.addComponent((Component)this.navigatorTop);
        target.addComponent((Component)this.navigatorBottom);
    }

    public void reset() {
        this.dataView.setCurrentPage(0);
        this.clearSelection();
        this.dataProvider.setSort(null);
    }

    public void setFilterVisible(boolean filterVisible) {
        this.filterForm.setVisible(filterVisible);
    }

    public void processInputs() {
        this.visitChildren(FormComponent.class, new Component.IVisitor(){

            public Object component(Component component) {
                ((FormComponent)component).processInput();
                return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }

    protected abstract Component getComponentForProperty(String var1, IModel var2, GeoServerDataProvider.Property<T> var3);

    protected void onPopulateItem(GeoServerDataProvider.Property<T> property, ListItem item) {
    }

    IModel showingAllRecords(int first, int last, int size) {
        return new ParamResourceModel("showingAllRecords", (Component)this, first, last, size);
    }

    IModel matchedXOutOfY(int first, int last, int size, int fullSize) {
        return new ParamResourceModel("matchedXOutOfY", (Component)this, first, last, size, fullSize);
    }

    public void setPageable(boolean pageable) {
        if (!pageable) {
            this.navigatorTop.setVisible(false);
            this.navigatorBottom.setVisible(false);
            this.dataView.setItemsPerPage(Integer.MAX_VALUE);
        } else {
            this.navigatorTop.setVisible(true);
            this.navigatorBottom.setVisible(true);
            this.dataView.setItemsPerPage(25);
        }
    }

    public class SelectionModel
    implements IModel {
        int index;

        public SelectionModel(int index) {
            this.index = index;
        }

        public Object getObject() {
            return GeoServerTablePanel.this.selection[this.index];
        }

        public void setObject(Object object) {
            GeoServerTablePanel.this.selection[this.index] = (Boolean)object;
        }

        public void detach() {
        }
    }

    protected class Pager
    extends Panel {
        GeoServerPagingNavigator navigator;
        Label matched;

        Pager(String id) {
            super(id);
            Component[] componentArray = new Component[1];
            this.navigator = this.updatingPagingNavigator();
            componentArray[0] = this.navigator;
            this.add(componentArray);
            Component[] componentArray2 = new Component[1];
            this.matched = new Label("filterMatch", (IModel)new Model());
            componentArray2[0] = this.matched;
            this.add(componentArray2);
            this.updateMatched();
        }

        private GeoServerPagingNavigator updatingPagingNavigator() {
            return new GeoServerPagingNavigator("navigator", (IPageable)GeoServerTablePanel.this.dataView){

                protected void onAjaxEvent(AjaxRequestTarget target) {
                    super.onAjaxEvent(target);
                    GeoServerTablePanel.this.setSelection(false);
                    GeoServerTablePanel.this.pagerDelegate.updateMatched();
                    GeoServerTablePanel.this.navigatorTop.updateMatched();
                    GeoServerTablePanel.this.navigatorBottom.updateMatched();
                    target.addComponent((Component)GeoServerTablePanel.this.navigatorTop);
                    target.addComponent((Component)GeoServerTablePanel.this.navigatorBottom);
                }
            };
        }

        void updateMatched() {
            this.matched.setDefaultModel(GeoServerTablePanel.this.pagerDelegate.model());
        }
    }

    protected class PagerDelegate
    implements Serializable {
        int fullSize;
        int size;
        int first;
        int last;

        public PagerDelegate() {
            this.updateMatched();
        }

        void updateMatched() {
            this.fullSize = GeoServerTablePanel.this.dataProvider.fullSize();
            this.first = this.first(this.fullSize);
            this.last = this.last(this.fullSize);
            if (GeoServerTablePanel.this.dataProvider.getKeywords() != null) {
                this.size = GeoServerTablePanel.this.dataProvider.size();
            }
        }

        public IModel model() {
            if (GeoServerTablePanel.this.dataProvider.getKeywords() == null) {
                return GeoServerTablePanel.this.showingAllRecords(this.first, this.last, this.fullSize);
            }
            return GeoServerTablePanel.this.matchedXOutOfY(this.first, this.last, this.size, this.fullSize);
        }

        int first(int fullSize) {
            int size = fullSize;
            if (GeoServerTablePanel.this.dataProvider.getKeywords() != null) {
                size = GeoServerTablePanel.this.dataView.getDataProvider().size();
            }
            if (size > 0) {
                return GeoServerTablePanel.this.dataView.getItemsPerPage() * GeoServerTablePanel.this.dataView.getCurrentPage() + 1;
            }
            return 0;
        }

        int last(int fullSize) {
            int count = GeoServerTablePanel.this.dataProvider.getKeywords() != null ? GeoServerTablePanel.this.dataView.getPageCount() : this.optGetPageCount(fullSize);
            int page = GeoServerTablePanel.this.dataView.getCurrentPage();
            if (page < count - 1) {
                return GeoServerTablePanel.this.dataView.getItemsPerPage() * (page + 1);
            }
            return GeoServerTablePanel.this.dataProvider.getKeywords() != null ? GeoServerTablePanel.this.dataView.getDataProvider().size() : fullSize;
        }

        int optGetPageCount(int total) {
            int count;
            int page = GeoServerTablePanel.this.dataView.getItemsPerPage();
            if (page * (count = total / page) < total) {
                ++count;
            }
            return count;
        }
    }
}

