/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.DecimalTextField;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EnvelopePanel
extends FormComponentPanel {
    protected Label minXLabel;
    protected Label minYLabel;
    protected Label maxXLabel;
    protected Label maxYLabel;
    protected Double minX;
    protected Double minY;
    protected Double maxX;
    protected Double maxY;
    protected DecimalTextField minXInput;
    protected DecimalTextField minYInput;
    protected DecimalTextField maxXInput;
    protected DecimalTextField maxYInput;
    protected CoordinateReferenceSystem crs;
    protected WebMarkupContainer crsContainer;
    protected CRSPanel crsPanel;
    protected boolean crsRequired;

    public EnvelopePanel(String id) {
        super(id);
        this.initComponents();
    }

    public EnvelopePanel(String id, ReferencedEnvelope e) {
        this(id, (IModel)new Model((Serializable)e));
    }

    public EnvelopePanel(String id, IModel model) {
        super(id, model);
        this.initComponents();
    }

    public void setCRSFieldVisible(boolean visible) {
        this.crsContainer.setVisible(visible);
    }

    public boolean isCRSFieldVisible() {
        return this.crsContainer.isVisible();
    }

    public boolean isCrsRequired() {
        return this.crsRequired;
    }

    public void setCrsRequired(boolean crsRequired) {
        this.crsRequired = crsRequired;
    }

    public void setLabelsVisibility(boolean visible) {
        this.minXLabel.setVisible(visible);
        this.minYLabel.setVisible(visible);
        this.maxXLabel.setVisible(visible);
        this.maxYLabel.setVisible(visible);
    }

    void initComponents() {
        this.updateFields();
        Component[] componentArray = new Component[1];
        this.minXLabel = new Label("minXL", (IModel)new ResourceModel("minX"));
        componentArray[0] = this.minXLabel;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.minYLabel = new Label("minYL", (IModel)new ResourceModel("minY"));
        componentArray2[0] = this.minYLabel;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.maxXLabel = new Label("maxXL", (IModel)new ResourceModel("maxX"));
        componentArray3[0] = this.maxXLabel;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.maxYLabel = new Label("maxYL", (IModel)new ResourceModel("maxY"));
        componentArray4[0] = this.maxYLabel;
        this.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.minXInput = new DecimalTextField("minX", (IModel<Double>)new PropertyModel((Object)this, "minX"));
        componentArray5[0] = this.minXInput;
        this.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.minYInput = new DecimalTextField("minY", (IModel<Double>)new PropertyModel((Object)this, "minY"));
        componentArray6[0] = this.minYInput;
        this.add(componentArray6);
        Component[] componentArray7 = new Component[1];
        this.maxXInput = new DecimalTextField("maxX", (IModel<Double>)new PropertyModel((Object)this, "maxX"));
        componentArray7[0] = this.maxXInput;
        this.add(componentArray7);
        Component[] componentArray8 = new Component[1];
        this.maxYInput = new DecimalTextField("maxY", (IModel<Double>)new PropertyModel((Object)this, "maxY"));
        componentArray8[0] = this.maxYInput;
        this.add(componentArray8);
        this.crsContainer = new WebMarkupContainer("crsContainer");
        this.crsContainer.setVisible(false);
        this.crsPanel = new CRSPanel("crs", (IModel)new PropertyModel((Object)this, "crs"));
        this.crsContainer.add(new Component[]{this.crsPanel});
        this.add(new Component[]{this.crsContainer});
    }

    protected void onBeforeRender() {
        this.updateFields();
        super.onBeforeRender();
    }

    private void updateFields() {
        ReferencedEnvelope e = (ReferencedEnvelope)this.getModelObject();
        if (e != null) {
            this.minX = e.getMinX();
            this.minY = e.getMinY();
            this.maxX = e.getMaxX();
            this.maxY = e.getMaxY();
            this.crs = e.getCoordinateReferenceSystem();
        }
    }

    public EnvelopePanel setReadOnly(final boolean readOnly) {
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                component.setEnabled(!readOnly);
                return null;
            }
        });
        this.crsPanel.setReadOnly(readOnly);
        return this;
    }

    protected void convertInput() {
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                ((TextField)component).processInput();
                return null;
            }
        });
        if (this.isCRSFieldVisible()) {
            this.crsPanel.processInput();
        }
        if (this.minX != null && this.maxX != null && this.minY != null && this.maxY != null) {
            if (this.crsRequired && this.crs == null) {
                this.setConvertedInput(null);
            } else {
                this.setConvertedInput(new ReferencedEnvelope(this.minX.doubleValue(), this.maxX.doubleValue(), this.minY.doubleValue(), this.maxY.doubleValue(), this.crs));
            }
        } else {
            this.setConvertedInput(null);
        }
    }

    protected void onModelChanged() {
        this.updateFields();
        this.visitChildren(TextField.class, new Component.IVisitor(){

            public Object component(Component component) {
                ((TextField)component).clearInput();
                return CONTINUE_TRAVERSAL;
            }
        });
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }
}

