/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.workspace.WorkspaceDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class WorkspaceProvider
extends GeoServerDataProvider<WorkspaceInfo> {
    public static GeoServerDataProvider.Property<WorkspaceInfo> NAME = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("name", "name");
    public static GeoServerDataProvider.Property<WorkspaceInfo> DEFAULT = new GeoServerDataProvider.AbstractProperty<WorkspaceInfo>("default"){

        @Override
        public Object getPropertyValue(WorkspaceInfo item) {
            Catalog catalog = GeoServerApplication.get().getCatalog();
            WorkspaceInfo defaultWorkspace = catalog.getDefaultWorkspace();
            return defaultWorkspace != null && defaultWorkspace.equals(item);
        }
    };
    static List PROPERTIES = Arrays.asList(NAME, DEFAULT);

    public WorkspaceProvider() {
        this.setSort(NAME.getName(), true);
    }

    @Override
    protected List<WorkspaceInfo> getItems() {
        return this.getCatalog().getWorkspaces();
    }

    @Override
    protected List<GeoServerDataProvider.Property<WorkspaceInfo>> getProperties() {
        return PROPERTIES;
    }

    @Override
    public IModel newModel(Object obj) {
        return new WorkspaceDetachableModel((WorkspaceInfo)obj);
    }
}

