/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.MinimumValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.admin.ContactPanel;
import org.geoserver.web.admin.GlobalSettingsPage;
import org.geoserver.web.data.namespace.NamespaceDetachableModel;
import org.geoserver.web.data.workspace.WorkspaceDetachableModel;
import org.geoserver.web.data.workspace.WorkspacePage;
import org.geoserver.web.services.BaseServiceAdminPage;
import org.geoserver.web.services.ServiceMenuPageInfo;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.HelpLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.URIValidator;
import org.geoserver.web.wicket.XMLNameValidator;
import org.geotools.util.logging.Logging;

public class WorkspaceEditPage
extends GeoServerSecuredPage {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.data.workspace");
    IModel wsModel;
    IModel nsModel;
    boolean defaultWs;
    SettingsPanel settingsPanel;
    ServicesPanel servicesPanel;
    GeoServerDialog dialog;

    public WorkspaceEditPage(PageParameters parameters) {
        String wsName = parameters.getString("name");
        WorkspaceInfo wsi = this.getCatalog().getWorkspaceByName(wsName);
        if (wsi == null) {
            this.error((Serializable)((Object)new ParamResourceModel("WorkspaceEditPage.notFound", (Component)this, wsName).getString()));
            this.doReturn(WorkspacePage.class);
            return;
        }
        this.init(wsi);
    }

    public WorkspaceEditPage(WorkspaceInfo ws) {
        this.init(ws);
    }

    private void init(WorkspaceInfo ws) {
        this.defaultWs = ws.getId().equals(this.getCatalog().getDefaultWorkspace().getId());
        this.wsModel = new WorkspaceDetachableModel(ws);
        NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix(ws.getName());
        this.nsModel = new NamespaceDetachableModel(ns);
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this.nsModel)){

            protected void onSubmit() {
                try {
                    WorkspaceEditPage.this.saveWorkspace();
                }
                catch (RuntimeException e) {
                    this.error((Serializable)((Object)e.getMessage()));
                }
            }
        };
        this.add(new Component[]{form});
        boolean isFullAdmin = this.isAuthenticatedAsAdmin();
        TextField name = new TextField("name", (IModel)new PropertyModel((Object)this.wsModel, "name"));
        name.setRequired(true);
        name.setEnabled(isFullAdmin);
        name.add((IValidator)new XMLNameValidator());
        form.add(new Component[]{name});
        TextField uri = new TextField("uri", (IModel)new PropertyModel((Object)this.nsModel, "uRI"), String.class);
        uri.setRequired(true);
        uri.add((IValidator)new URIValidator());
        form.add(new Component[]{uri});
        CheckBox defaultChk = new CheckBox("default", (IModel)new PropertyModel((Object)this, "defaultWs"));
        form.add(new Component[]{defaultChk});
        defaultChk.setEnabled(isFullAdmin);
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.settingsPanel = new SettingsPanel("settings", (IModel<WorkspaceInfo>)this.wsModel);
        componentArray2[0] = this.settingsPanel;
        form.add(componentArray2);
        form.add(new Component[]{new HelpLink("settingsHelp").setDialog(this.dialog)});
        Component[] componentArray3 = new Component[1];
        this.servicesPanel = new ServicesPanel("services", (IModel<WorkspaceInfo>)this.wsModel);
        componentArray3[0] = this.servicesPanel;
        form.add(componentArray3);
        form.add(new Component[]{new HelpLink("servicesHelp").setDialog(this.dialog)});
        SubmitLink submit = new SubmitLink("save");
        form.add(new Component[]{submit});
        form.setDefaultButton((IFormSubmittingComponent)submit);
        form.add(new Component[]{new BookmarkablePageLink("cancel", WorkspacePage.class)});
    }

    private void saveWorkspace() {
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceInfo = (NamespaceInfo)this.nsModel.getObject();
        WorkspaceInfo workspaceInfo = (WorkspaceInfo)this.wsModel.getObject();
        namespaceInfo.setPrefix(workspaceInfo.getName());
        catalog.save(workspaceInfo);
        catalog.save(namespaceInfo);
        if (this.defaultWs) {
            catalog.setDefaultWorkspace(workspaceInfo);
        }
        GeoServer geoServer = this.getGeoServer();
        Settings set = this.settingsPanel.set;
        if (set.enabled.booleanValue()) {
            if (set.model instanceof NewSettingsModel) {
                geoServer.add((SettingsInfo)set.model.getObject());
            } else {
                geoServer.save((SettingsInfo)set.model.getObject());
            }
        } else if (set.model instanceof ExistingSettingsModel) {
            geoServer.remove((SettingsInfo)set.model.getObject());
        }
        for (Service s : this.servicesPanel.services) {
            if (s.enabled.booleanValue()) {
                if (s.model instanceof ExistingServiceModel) continue;
                geoServer.add((ServiceInfo)s.model.getObject());
                continue;
            }
            if (!(s.model instanceof ExistingServiceModel)) continue;
            geoServer.remove((ServiceInfo)s.model.getObject());
        }
        this.doReturn(WorkspacePage.class);
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    class ServicesPanel
    extends FormComponentPanel {
        List<Service> services;

        public ServicesPanel(String id, final IModel<WorkspaceInfo> wsModel) {
            super(id, (IModel)new Model());
            this.services = this.services(wsModel);
            ListView<Service> serviceList = new ListView<Service>("services", this.services){

                protected void populateItem(ListItem<Service> item) {
                    Service service = (Service)item.getModelObject();
                    Link<Service> link = new Link<Service>("link", (IModel)new Model((Serializable)service)){

                        public void onClick() {
                            Service s = (Service)this.getModelObject();
                            Page page = null;
                            if (s.model instanceof ExistingServiceModel) {
                                PageParameters pp = new PageParameters("workspace=" + ((WorkspaceInfo)wsModel.getObject()).getName());
                                try {
                                    page = (Page)s.adminPage.getComponentClass().getConstructor(PageParameters.class).newInstance(pp);
                                }
                                catch (Exception e) {
                                    throw new WicketRuntimeException((Throwable)e);
                                }
                            }
                            try {
                                page = (Page)s.adminPage.getComponentClass().getConstructor(s.adminPage.getServiceClass()).newInstance(s.model.getObject());
                            }
                            catch (Exception e) {
                                throw new WicketRuntimeException((Throwable)e);
                            }
                            ((BaseServiceAdminPage)page).setReturnPage((Page)WorkspaceEditPage.this);
                            this.setResponsePage(page);
                        }
                    };
                    link.setOutputMarkupId(true);
                    link.setEnabled(service.enabled.booleanValue());
                    AjaxCheckBox enabled = new AjaxCheckBox("enabled", (IModel)new PropertyModel((Object)service, "enabled"), (Link)link){
                        final /* synthetic */ Link val$link;
                        {
                            this.val$link = link;
                            super(x0, x1);
                        }

                        protected void onUpdate(AjaxRequestTarget target) {
                            this.val$link.setEnabled(((Boolean)this.getModelObject()).booleanValue());
                            target.addComponent((Component)this.val$link);
                        }
                    };
                    item.add(new Component[]{enabled});
                    ServiceMenuPageInfo info = service.adminPage;
                    link.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new StringResourceModel(info.getDescriptionKey(), (Component)null, null))});
                    link.add(new Component[]{new Label("link.label", (IModel)new StringResourceModel(info.getTitleKey(), (Component)null, null))});
                    Image image = info.getIcon() != null ? new Image("link.icon", new ResourceReference(info.getComponentClass(), info.getIcon())) : new Image("link.icon", new ResourceReference(GeoServerBasePage.class, "img/icons/silk/wrench.png"));
                    image.add(new IBehavior[]{new AttributeModifier("alt", true, (IModel)new ParamResourceModel(info.getTitleKey(), null, new Object[0]))});
                    link.add(new Component[]{image});
                    item.add(new Component[]{link});
                }
            };
            this.add(new Component[]{serviceList});
        }

        List<Service> services(IModel<WorkspaceInfo> wsModel) {
            ArrayList<Service> services = new ArrayList<Service>();
            for (ServiceMenuPageInfo page : WorkspaceEditPage.this.getGeoServerApplication().getBeansOfType(ServiceMenuPageInfo.class)) {
                Service service = new Service();
                service.adminPage = page;
                service.enabled = WorkspaceEditPage.this.getGeoServer().getService((WorkspaceInfo)wsModel.getObject(), page.getServiceClass()) != null;
                Class<ServiceInfo> serviceClass = page.getServiceClass();
                service.model = service.enabled == false ? new NewServiceModel(wsModel, serviceClass) : new ExistingServiceModel(wsModel, serviceClass);
                services.add(service);
            }
            return services;
        }
    }

    static class ExistingServiceModel
    extends LoadableDetachableModel<ServiceInfo> {
        IModel<WorkspaceInfo> wsModel;
        Class<ServiceInfo> serviceClass;

        ExistingServiceModel(IModel<WorkspaceInfo> wsModel, Class<ServiceInfo> serviceClass) {
            this.wsModel = wsModel;
            this.serviceClass = serviceClass;
        }

        protected ServiceInfo load() {
            return GeoServerApplication.get().getGeoServer().getService((WorkspaceInfo)this.wsModel.getObject(), this.serviceClass);
        }
    }

    static class NewServiceModel
    extends Model<ServiceInfo> {
        IModel<WorkspaceInfo> wsModel;
        Class<ServiceInfo> serviceClass;
        ServiceInfo service;

        NewServiceModel(IModel<WorkspaceInfo> wsModel, Class<ServiceInfo> serviceClass) {
            this.wsModel = wsModel;
            this.serviceClass = serviceClass;
        }

        public ServiceInfo getObject() {
            if (this.service == null) {
                this.service = this.create();
            }
            return this.service;
        }

        ServiceInfo create() {
            GeoServer gs = GeoServerApplication.get().getGeoServer();
            ServiceInfo newService = (ServiceInfo)gs.getFactory().create(this.serviceClass);
            ServiceInfo global = gs.getService(this.serviceClass);
            OwsUtils.copy((Object)global, (Object)newService, this.serviceClass);
            newService.setWorkspace((WorkspaceInfo)this.wsModel.getObject());
            ((ServiceInfoImpl)newService).setId(null);
            return newService;
        }
    }

    static class Service
    implements Serializable {
        Boolean enabled;
        ServiceMenuPageInfo adminPage;
        IModel<ServiceInfo> model;

        Service() {
        }
    }

    class SettingsPanel
    extends FormComponentPanel {
        WebMarkupContainer settingsContainer;
        ContactPanel contactPanel;
        WebMarkupContainer otherSettingsPanel;
        Settings set;

        public SettingsPanel(String id, IModel<WorkspaceInfo> model) {
            super(id, (IModel)new Model());
            SettingsInfo settings = WorkspaceEditPage.this.getGeoServer().getSettings((WorkspaceInfo)model.getObject());
            this.set = new Settings();
            this.set.enabled = settings != null;
            this.set.model = settings != null ? new ExistingSettingsModel((IModel<WorkspaceInfo>)WorkspaceEditPage.this.wsModel) : new NewSettingsModel((IModel<WorkspaceInfo>)WorkspaceEditPage.this.wsModel);
            this.add(new Component[]{new CheckBox("enabled", (IModel)new PropertyModel((Object)this.set, "enabled")).add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onclick"){

                protected void onUpdate(AjaxRequestTarget target) {
                    SettingsPanel.this.contactPanel.setVisible(SettingsPanel.this.set.enabled);
                    SettingsPanel.this.otherSettingsPanel.setVisible(SettingsPanel.this.set.enabled.booleanValue());
                    target.addComponent((Component)SettingsPanel.this.settingsContainer);
                }
            }})});
            this.settingsContainer = new WebMarkupContainer("settingsContainer");
            this.settingsContainer.setOutputMarkupId(true);
            this.add(new Component[]{this.settingsContainer});
            this.contactPanel = new ContactPanel("contact", (IModel<ContactInfo>)new CompoundPropertyModel((Object)new PropertyModel(this.set.model, "contact")));
            this.contactPanel.setOutputMarkupId(true);
            this.contactPanel.setVisible(this.set.enabled);
            this.settingsContainer.add(new Component[]{this.contactPanel});
            this.otherSettingsPanel = new WebMarkupContainer("otherSettings", (IModel)new CompoundPropertyModel(this.set.model));
            this.otherSettingsPanel.setOutputMarkupId(true);
            this.otherSettingsPanel.setVisible(this.set.enabled.booleanValue());
            this.otherSettingsPanel.add(new Component[]{new CheckBox("verbose")});
            this.otherSettingsPanel.add(new Component[]{new CheckBox("verboseExceptions")});
            this.otherSettingsPanel.add(new Component[]{new TextField("numDecimals").add((IValidator)new MinimumValidator((Comparable)Integer.valueOf(0)))});
            this.otherSettingsPanel.add(new Component[]{new DropDownChoice("charset", GlobalSettingsPage.AVAILABLE_CHARSETS)});
            this.otherSettingsPanel.add(new Component[]{new TextField("proxyBaseUrl").add((IValidator)new UrlValidator())});
            this.settingsContainer.add(new Component[]{this.otherSettingsPanel});
        }
    }

    static class NewSettingsModel
    extends Model<SettingsInfo> {
        IModel<WorkspaceInfo> wsModel;
        SettingsInfo info;

        NewSettingsModel(IModel<WorkspaceInfo> wsModel) {
            this.wsModel = wsModel;
        }

        public SettingsInfo getObject() {
            if (this.info == null) {
                GeoServer gs = GeoServerApplication.get().getGeoServer();
                this.info = gs.getFactory().createSettings();
                SettingsInfo global = gs.getGlobal().getSettings();
                ContactInfo contact = gs.getFactory().createContact();
                OwsUtils.copy((Object)global.getContact(), (Object)contact, ContactInfo.class);
                OwsUtils.copy((Object)global, (Object)this.info, SettingsInfo.class);
                this.info.setContact(contact);
                this.info.setWorkspace((WorkspaceInfo)this.wsModel.getObject());
            }
            return this.info;
        }
    }

    static class ExistingSettingsModel
    extends LoadableDetachableModel<SettingsInfo> {
        IModel<WorkspaceInfo> wsModel;

        ExistingSettingsModel(IModel<WorkspaceInfo> wsModel) {
            this.wsModel = wsModel;
        }

        protected SettingsInfo load() {
            GeoServer gs = GeoServerApplication.get().getGeoServer();
            return gs.getSettings((WorkspaceInfo)this.wsModel.getObject());
        }
    }

    static class Settings
    implements Serializable {
        Boolean enabled;
        IModel<SettingsInfo> model;

        Settings() {
        }
    }
}

