/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store.panel;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.model.IModel;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.GeoserverDataDirectory;

class FileModel
implements IModel {
    static final Logger LOGGER = Logging.getLogger(FileModel.class);
    IModel delegate;

    FileModel(IModel delegate) {
        this.delegate = delegate;
    }

    private boolean isSubfile(File root, File selection) {
        if (selection == null || "".equals(selection.getPath())) {
            return false;
        }
        if (selection.equals(root)) {
            return true;
        }
        return this.isSubfile(root, selection.getParentFile());
    }

    public Object getObject() {
        return this.delegate.getObject();
    }

    public void detach() {
    }

    public void setObject(Object object) {
        File file;
        String location = (String)object;
        File dataDirectory = this.canonicalize(GeoserverDataDirectory.getGeoserverDataDirectory());
        if (this.isSubfile(dataDirectory, file = this.canonicalize(new File(location)))) {
            String path = null;
            for (File curr = file; curr != null && !curr.equals(dataDirectory); curr = curr.getParentFile()) {
                path = path == null ? curr.getName() : curr.getName() + "/" + path;
            }
            location = "file:" + path;
        } else if (GeoserverDataDirectory.findDataFile((String)location).equals(file)) {
            location = "file://" + file.getAbsolutePath();
        }
        this.delegate.setObject((Object)location);
    }

    File canonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Could not convert " + file + " into canonical form", e);
            return file;
        }
    }
}

